/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.lar;

import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.lar.xstream.XStreamAliasRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.model.impl.BookmarksEntryImpl;
import com.liferay.portlet.bookmarks.model.impl.BookmarksFolderImpl;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class BookmarksPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "bookmarks";

    public BookmarksPortletDataHandler() {
        this.setDataPortletPreferences(new String[]{"rootFolderId"});
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(BookmarksEntry.class), new StagedModelType(BookmarksFolder.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "entries", true, false, null, BookmarksEntry.class.getName())});
        this.setImportControls(this.getExportControls());
        this.setPublishToLiveByDefault(PropsValues.BOOKMARKS_PUBLISH_TO_LIVE_BY_DEFAULT);
        XStreamAliasRegistryUtil.register(BookmarksEntryImpl.class, (String)"BookmarksEntry");
        XStreamAliasRegistryUtil.register(BookmarksFolderImpl.class, (String)"BookmarksFolder");
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(BookmarksPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        BookmarksFolderLocalServiceUtil.deleteFolders((long)portletDataContext.getScopeGroupId());
        BookmarksEntryLocalServiceUtil.deleteEntries((long)portletDataContext.getScopeGroupId(), (long)0L);
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "entries")) {
            return this.getExportDataRootElementString(rootElement);
        }
        portletDataContext.addPortletPermissions("com.liferay.portlet.bookmarks");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        ExportActionableDynamicQuery folderActionableDynamicQuery = BookmarksFolderLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        folderActionableDynamicQuery.performActions();
        ExportActionableDynamicQuery entryActionableDynamicQuery = BookmarksEntryLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        entryActionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "entries")) {
            return null;
        }
        portletDataContext.importPortletPermissions("com.liferay.portlet.bookmarks");
        Element foldersElement = portletDataContext.getImportDataGroupElement(BookmarksFolder.class);
        List folderElements = foldersElement.elements();
        for (Element folderElement : folderElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)folderElement);
        }
        Element entriesElement = portletDataContext.getImportDataGroupElement(BookmarksEntry.class);
        List entryElements = entriesElement.elements();
        for (Element entryElement : entryElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)entryElement);
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ExportActionableDynamicQuery entryExportActionableDynamicQuery = BookmarksEntryLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        entryExportActionableDynamicQuery.performCount();
        ExportActionableDynamicQuery folderExportActionableDynamicQuery = BookmarksFolderLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        folderExportActionableDynamicQuery.performCount();
    }

    protected PortletPreferences doProcessExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        if (rootFolderId != 0L) {
            BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)rootFolderId);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
            portletDataContext.addReferenceElement((ClassedModel)portlet, portletDataContext.getExportDataRootElement(), (ClassedModel)folder, "dependency", !portletDataContext.getBooleanParameter(NAMESPACE, "entries"));
        }
        return portletPreferences;
    }

    protected PortletPreferences doProcessImportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        if (rootFolderId > 0L) {
            String rootFolderPath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)BookmarksFolder.class.getName(), (long)rootFolderId);
            BookmarksFolder folder = (BookmarksFolder)portletDataContext.getZipEntryAsObject(rootFolderPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder);
            Map folderIds = portletDataContext.getNewPrimaryKeysMap(BookmarksFolder.class);
            rootFolderId = MapUtil.getLong((Map)folderIds, (long)rootFolderId, (long)rootFolderId);
            portletPreferences.setValue("rootFolderId", String.valueOf(rootFolderId));
        }
        return portletPreferences;
    }
}

