/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import java.util.List;
import java.util.Map;

public class BookmarksFolderStagedModelDataHandler
extends BaseStagedModelDataHandler<BookmarksFolder> {
    public static final String[] CLASS_NAMES = new String[]{BookmarksFolder.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        BookmarksFolder folder = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (folder != null) {
            BookmarksFolderLocalServiceUtil.deleteFolder((BookmarksFolder)folder);
        }
    }

    public BookmarksFolder fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List folders = BookmarksFolderLocalServiceUtil.getBookmarksFoldersByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)folders)) {
            return null;
        }
        return (BookmarksFolder)folders.get(0);
    }

    public BookmarksFolder fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return BookmarksFolderLocalServiceUtil.fetchBookmarksFolderByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(BookmarksFolder folder) {
        return folder.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, BookmarksFolder folder) throws Exception {
        if (folder.getParentFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, (StagedModel)folder.getParentFolder(), (String)"parent");
        }
        Element folderElement = portletDataContext.getExportDataElement((ClassedModel)folder);
        portletDataContext.addClassedModel(folderElement, ExportImportPathUtil.getModelPath((StagedModel)folder), (ClassedModel)folder);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, BookmarksFolder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(BookmarksFolder.class);
        long parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)folder);
        BookmarksFolder importedFolder = null;
        if (portletDataContext.isDataStrategyMirror()) {
            BookmarksFolder existingFolder = this.fetchStagedModelByUuidAndGroupId(folder.getUuid(), portletDataContext.getScopeGroupId());
            if (existingFolder == null) {
                serviceContext.setUuid(folder.getUuid());
                importedFolder = BookmarksFolderLocalServiceUtil.addFolder((long)userId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedFolder = BookmarksFolderLocalServiceUtil.updateFolder((long)userId, (long)existingFolder.getFolderId(), (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (boolean)false, (ServiceContext)serviceContext);
            }
        } else {
            importedFolder = BookmarksFolderLocalServiceUtil.addFolder((long)userId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)folder, (ClassedModel)importedFolder);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, BookmarksFolder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        BookmarksFolder existingFolder = this.fetchStagedModelByUuidAndGroupId(folder.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFolder == null || !existingFolder.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingFolder.getTrashHandler();
        if (trashHandler.isRestorable(existingFolder.getFolderId())) {
            trashHandler.restoreTrashEntry(userId, existingFolder.getFolderId());
        }
    }
}

