/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.bookmarks.asset.BookmarksFolderAssetRenderer;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class BookmarksFolderAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "bookmark_folder";

    public BookmarksFolderAssetRendererFactory() {
        this.setCategorizable(false);
    }

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException {
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)classPK);
        BookmarksFolderAssetRenderer bookmarksFolderAssetRenderer = new BookmarksFolderAssetRenderer(folder);
        bookmarksFolderAssetRenderer.setAssetRendererType(type);
        return bookmarksFolderAssetRenderer;
    }

    public String getClassName() {
        return BookmarksFolder.class.getName();
    }

    public String getIconCssClass() {
        return "icon-folder-close";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("28", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException wse) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)classPK);
        return BookmarksFolderPermission.contains(permissionChecker, folder, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return themeDisplay.getPathThemeImages() + "/common/folder.png";
    }
}

