/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.bookmarks.asset.BookmarksEntryAssetRenderer;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import com.liferay.portlet.bookmarks.service.permission.BookmarksPermission;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class BookmarksEntryAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "bookmark";

    public BookmarksEntryAssetRendererFactory() {
        this.setLinkable(true);
    }

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        BookmarksEntryAssetRenderer bookmarksEntryAssetRenderer = new BookmarksEntryAssetRenderer(entry);
        bookmarksEntryAssetRenderer.setAssetRendererType(type);
        return bookmarksEntryAssetRenderer;
    }

    public String getClassName() {
        return BookmarksEntry.class.getName();
    }

    public String getIconCssClass() {
        return "icon-bookmark-empty";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        LiferayPortletURL portletURL = liferayPortletResponse.createRenderURL("28");
        portletURL.setParameter("struts_action", "/bookmarks/edit_entry");
        portletURL.setParameter("folderId", String.valueOf(AssetPublisherUtil.getRecentFolderId((PortletRequest)liferayPortletRequest, (String)this.getClassName())));
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("28", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException wse) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasAddPermission(PermissionChecker permissionChecker, long groupId, long classTypeId) throws Exception {
        return BookmarksPermission.contains(permissionChecker, groupId, "ADD_ENTRY");
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return BookmarksEntryPermission.contains(permissionChecker, classPK, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return themeDisplay.getPathThemeImages() + "/ratings/star_hover.png";
    }
}

