/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.bookmarks.FolderNameException;
import com.liferay.portlet.bookmarks.NoSuchFolderException;
import com.liferay.portlet.bookmarks.action.ActionUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksFolderServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFolderAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFolder(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFolders(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteFolders(actionRequest, true);
            } else if (cmd.equals("subscribe")) {
                this.subscribeFolder(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeFolder(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFolderException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.bookmarks.error");
            }
            if (e instanceof FolderNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFolder((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFolderException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.bookmarks.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.bookmarks.edit_folder"));
    }

    protected void deleteFolders(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteFolderIds = null;
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        deleteFolderIds = folderId > 0L ? new long[]{folderId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        ArrayList<BookmarksFolder> trashedModels = new ArrayList<BookmarksFolder>();
        for (long deleteFolderId : deleteFolderIds) {
            if (moveToTrash) {
                BookmarksFolder folder = BookmarksFolderServiceUtil.moveFolderToTrash((long)deleteFolderId);
                trashedModels.add(folder);
            } else {
                BookmarksFolderServiceUtil.deleteFolder((long)deleteFolderId);
            }
            AssetPublisherUtil.removeRecentFolderId((PortletRequest)actionRequest, (String)BookmarksEntry.class.getName(), (long)deleteFolderId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void subscribeFolder(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        BookmarksFolderServiceUtil.subscribeFolder((long)themeDisplay.getScopeGroupId(), (long)folderId);
    }

    protected void unsubscribeFolder(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        BookmarksFolderServiceUtil.unsubscribeFolder((long)themeDisplay.getScopeGroupId(), (long)folderId);
    }

    protected void updateFolder(ActionRequest actionRequest) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long parentFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentFolderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        boolean mergeWithParentFolder = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeWithParentFolder");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)BookmarksFolder.class.getName(), (PortletRequest)actionRequest);
        if (folderId <= 0L) {
            BookmarksFolderServiceUtil.addFolder((long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
        } else {
            BookmarksFolderServiceUtil.updateFolder((long)folderId, (long)parentFolderId, (String)name, (String)description, (boolean)mergeWithParentFolder, (ServiceContext)serviceContext);
        }
    }
}

