/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.action;

import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.bookmarks.EntryURLException;
import com.liferay.portlet.bookmarks.NoSuchEntryException;
import com.liferay.portlet.bookmarks.NoSuchFolderException;
import com.liferay.portlet.bookmarks.action.ActionUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditEntryAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            BookmarksEntry entry = null;
            if (cmd.equals("add") || cmd.equals("update")) {
                entry = this.updateEntry(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteEntry(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteEntry(actionRequest, true);
            } else if (cmd.equals("subscribe")) {
                this.subscribeEntry(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeEntry(actionRequest);
            }
            WindowState windowState = actionRequest.getWindowState();
            if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                this.sendRedirect(actionRequest, actionResponse);
            } else {
                String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                if (Validator.isNotNull((String)redirect)) {
                    if (cmd.equals("add") && entry != null) {
                        String portletId = HttpUtil.getParameter((String)redirect, (String)"p_p_id", (boolean)false);
                        String namespace = PortalUtil.getPortletNamespace((String)portletId);
                        redirect = HttpUtil.addParameter((String)redirect, (String)(namespace + "className"), (String)BookmarksEntry.class.getName());
                        redirect = HttpUtil.addParameter((String)redirect, (String)(namespace + "classPK"), (long)entry.getEntryId());
                    }
                    actionResponse.sendRedirect(redirect);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.bookmarks.error");
            }
            if (e instanceof EntryURLException || e instanceof NoSuchFolderException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getEntry((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.bookmarks.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.bookmarks.edit_entry"));
    }

    protected void deleteEntry(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteEntryIds = null;
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        deleteEntryIds = entryId > 0L ? new long[]{entryId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteEntryIds"), (long)0L);
        ArrayList<BookmarksEntry> trashedModels = new ArrayList<BookmarksEntry>();
        for (long deleteEntryId : deleteEntryIds) {
            if (moveToTrash) {
                BookmarksEntry entry = BookmarksEntryServiceUtil.moveEntryToTrash((long)deleteEntryId);
                trashedModels.add(entry);
                continue;
            }
            BookmarksEntryServiceUtil.deleteEntry((long)deleteEntryId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void subscribeEntry(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        BookmarksEntryServiceUtil.subscribeEntry((long)entryId);
    }

    protected void unsubscribeEntry(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        BookmarksEntryServiceUtil.unsubscribeEntry((long)entryId);
    }

    protected BookmarksEntry updateEntry(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        long groupId = themeDisplay.getScopeGroupId();
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String url = ParamUtil.getString((PortletRequest)actionRequest, (String)"url");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)BookmarksEntry.class.getName(), (PortletRequest)actionRequest);
        BookmarksEntry entry = null;
        if (entryId <= 0L) {
            entry = BookmarksEntryServiceUtil.addEntry((long)groupId, (long)folderId, (String)name, (String)url, (String)description, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, (String)BookmarksEntry.class.getName(), (long)entry.getEntryId(), (int)-1);
        } else {
            entry = BookmarksEntryServiceUtil.updateEntry((long)entryId, (long)groupId, (long)folderId, (String)name, (String)url, (String)description, (ServiceContext)serviceContext);
        }
        AssetPublisherUtil.addRecentFolderId((PortletRequest)actionRequest, (String)BookmarksEntry.class.getName(), (long)folderId);
        return entry;
    }
}

