/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.ParameterMapSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.TypedSettings;
import java.util.Map;

public class BookmarksSettings {
    public static final String[] ALL_KEYS = new String[]{"emailEntryAddedBody", "emailEntryAddedSubject", "emailEntryUpdatedBody", "emailEntryUpdatedSubject", "emailFromAddress", "emailFromName", "entriesPerPage", "entryColumns", "folderColumns", "foldersPerPage", "rootFolderId", "emailEntryAddedEnabled", "emailEntryUpdatedEnabled", "enableRelatedAssets", "showFoldersSearch", "showSubfolders"};
    private static final String[] _MULTI_VALUED_KEYS = new String[]{"entryColumns", "folderColumns"};
    private TypedSettings _typedSettings;

    public static BookmarksSettings getInstance(long groupId) throws PortalException {
        Settings settings = SettingsFactoryUtil.getGroupServiceSettings((long)groupId, (String)"com.liferay.portlet.bookmarks");
        return new BookmarksSettings(settings);
    }

    public static BookmarksSettings getInstance(long groupId, Map<String, String[]> parameterMap) throws PortalException {
        Settings settings = SettingsFactoryUtil.getGroupServiceSettings((long)groupId, (String)"com.liferay.portlet.bookmarks");
        ParameterMapSettings parameterMapSettings = new ParameterMapSettings(parameterMap, settings);
        return new BookmarksSettings((Settings)parameterMapSettings);
    }

    public BookmarksSettings(Settings settings) {
        this._typedSettings = new TypedSettings(settings);
    }

    public LocalizedValuesMap getEmailEntryAddedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailEntryAddedBody");
    }

    public String getEmailEntryAddedBodyXml() {
        LocalizedValuesMap emailEntryAddedBody = this.getEmailEntryAddedBody();
        return emailEntryAddedBody.getLocalizationXml();
    }

    public LocalizedValuesMap getEmailEntryAddedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailEntryAddedSubject");
    }

    public String getEmailEntryAddedSubjectXml() {
        LocalizedValuesMap emailEntryAddedSubject = this.getEmailEntryAddedSubject();
        return emailEntryAddedSubject.getLocalizationXml();
    }

    public LocalizedValuesMap getEmailEntryUpdatedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailEntryUpdatedBody");
    }

    public String getEmailEntryUpdatedBodyXml() {
        LocalizedValuesMap emailEntryUpdatedBody = this.getEmailEntryUpdatedBody();
        return emailEntryUpdatedBody.getLocalizationXml();
    }

    public LocalizedValuesMap getEmailEntryUpdatedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailEntryUpdatedSubject");
    }

    public String getEmailEntryUpdatedSubjectXml() {
        LocalizedValuesMap emailEntryUpdatedSubject = this.getEmailEntryUpdatedSubject();
        return emailEntryUpdatedSubject.getLocalizationXml();
    }

    public String getEmailFromAddress() {
        return this._typedSettings.getValue("emailFromAddress");
    }

    public String getEmailFromName() {
        return this._typedSettings.getValue("emailFromName");
    }

    public int getEntriesPerPage() {
        return this._typedSettings.getIntegerValue("entriesPerPage");
    }

    public String[] getEntryColumns() {
        return this._typedSettings.getValues("entryColumns");
    }

    public String[] getFolderColumns() {
        return this._typedSettings.getValues("folderColumns");
    }

    public int getFoldersPerPage() {
        return this._typedSettings.getIntegerValue("foldersPerPage");
    }

    public long getRootFolderId() {
        return this._typedSettings.getLongValue("rootFolderId", 0L);
    }

    public boolean isEmailEntryAddedEnabled() {
        return this._typedSettings.getBooleanValue("emailEntryAddedEnabled");
    }

    public boolean isEmailEntryUpdatedEnabled() {
        return this._typedSettings.getBooleanValue("emailEntryUpdatedEnabled");
    }

    public boolean isEnableRelatedAssets() {
        return this._typedSettings.getBooleanValue("enableRelatedAssets");
    }

    public boolean isShowFoldersSearch() {
        return this._typedSettings.getBooleanValue("showFoldersSearch");
    }

    public boolean isShowSubfolders() {
        return this._typedSettings.getBooleanValue("showSubfolders");
    }

    private static FallbackKeys _getFallbackKeys() {
        FallbackKeys fallbackKeys = new FallbackKeys();
        fallbackKeys.add("emailEntryAddedBody", new String[]{"bookmarks.email.entry.added.body"});
        fallbackKeys.add("emailEntryAddedEnabled", new String[]{"bookmarks.email.entry.added.enabled"});
        fallbackKeys.add("emailEntryAddedSubject", new String[]{"bookmarks.email.entry.added.subject"});
        fallbackKeys.add("emailEntryUpdatedBody", new String[]{"bookmarks.email.entry.updated.body"});
        fallbackKeys.add("emailEntryUpdatedEnabled", new String[]{"bookmarks.email.entry.updated.enabled"});
        fallbackKeys.add("emailEntryUpdatedSubject", new String[]{"bookmarks.email.entry.updated.subject"});
        fallbackKeys.add("emailFromAddress", new String[]{"bookmarks.email.from.address", "admin.email.from.address"});
        fallbackKeys.add("emailFromName", new String[]{"bookmarks.email.from.name", "admin.email.from.name"});
        fallbackKeys.add("enableRelatedAssets", new String[]{"bookmarks.related.assets.enabled"});
        fallbackKeys.add("entriesPerPage", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("entryColumns", new String[]{"bookmarks.entry.columns"});
        fallbackKeys.add("folderColumns", new String[]{"bookmarks.folder.columns"});
        fallbackKeys.add("foldersPerPage", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("showFoldersSearch", new String[]{"bookmarks.folders.search.visible"});
        fallbackKeys.add("showSubfolders", new String[]{"bookmarks.subfolders.visible"});
        return fallbackKeys;
    }

    static {
        SettingsFactory settingsFactory = SettingsFactoryUtil.getSettingsFactory();
        settingsFactory.registerSettingsMetadata("com.liferay.portlet.bookmarks", BookmarksSettings._getFallbackKeys(), _MULTI_VALUED_KEYS);
    }
}

