/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.dao.search.SearchContainerResults;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.service.AssetEntryServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.blogs.model.BlogsEntry;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.portlet.PortletRequest;

public class BlogsUtil {
    public static final String DISPLAY_STYLE_ABSTRACT = "abstract";
    public static final String DISPLAY_STYLE_FULL_CONTENT = "full-content";
    public static final String DISPLAY_STYLE_TITLE = "title";
    private static Pattern _friendlyURLPattern = Pattern.compile("[^a-z0-9_-]");

    public static CommentManager getCommentManager() {
        return (CommentManager)PortalBeanLocatorUtil.locate((String)CommentManager.class.getName());
    }

    public static int getCommentsCount(BlogsEntry entry) {
        CommentManager commentManager = BlogsUtil.getCommentManager();
        return commentManager.getCommentsCount(BlogsEntry.class.getName(), entry.getEntryId());
    }

    public static Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$BLOGS_ENTRY_CONTENT$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-blog-entry-content"));
        definitionTerms.put("[$BLOGS_ENTRY_CREATE_DATE$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-date-the-blog-entry-was-created"));
        definitionTerms.put("[$BLOGS_ENTRY_DESCRIPTION$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-blog-entry-description"));
        definitionTerms.put("[$BLOGS_ENTRY_SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-site-where-the-blog-entry-was-created"));
        definitionTerms.put("[$BLOGS_ENTRY_STATUS_BY_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-updated-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_TITLE$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-blog-entry-title"));
        definitionTerms.put("[$BLOGS_ENTRY_UPDATE_COMMENT$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-comment-of-the-user-who-updated-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_USER_PORTRAIT_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-portrait-url-of-the-user-who-added-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_USER_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-public-site-url-of-the-user-who-added-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-blog-entry-url"));
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-blog"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-blog"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-blog"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)emailFromName));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        definitionTerms.put("[$PORTLET_NAME$]", PortalUtil.getPortletTitle((PortletRequest)portletRequest));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-blog"));
        definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient"));
        definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient"));
        return definitionTerms;
    }

    public static Map<String, String> getEmailFromDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$BLOGS_ENTRY_USER_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-email-address-of-the-user-who-added-the-blog-entry"));
        definitionTerms.put("[$BLOGS_ENTRY_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-blog-entry"));
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-blog"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-blog"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-blog"));
        definitionTerms.put("[$PORTLET_NAME$]", PortalUtil.getPortletTitle((PortletRequest)portletRequest));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-blog"));
        return definitionTerms;
    }

    public static SearchContainerResults<AssetEntry> getSearchContainerResults(SearchContainer<?> searchContainer) throws PortalException {
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery(BlogsEntry.class.getName(), searchContainer);
        assetEntryQuery.setExcludeZeroViewCount(false);
        assetEntryQuery.setVisible(Boolean.TRUE);
        int total = AssetEntryServiceUtil.getEntriesCount((AssetEntryQuery)assetEntryQuery);
        assetEntryQuery.setEnd(searchContainer.getEnd());
        assetEntryQuery.setStart(searchContainer.getStart());
        List assetEntries = AssetEntryServiceUtil.getEntries((AssetEntryQuery)assetEntryQuery);
        return new SearchContainerResults(assetEntries, total);
    }

    public static String getUrlTitle(long entryId, String title) {
        if (title == null) {
            return String.valueOf(entryId);
        }
        title = Validator.isNull((String)(title = StringUtil.toLowerCase((String)title.trim()))) || Validator.isNumber((String)title) || title.equals("rss") ? String.valueOf(entryId) : FriendlyURLNormalizerUtil.normalize((String)title, (Pattern)_friendlyURLPattern);
        return ModelHintsUtil.trimString((String)BlogsEntry.class.getName(), (String)"urlTitle", (String)title);
    }
}

