/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class BlogsEntryTrashHandler
extends BaseTrashHandler {
    public void deleteTrashEntry(long classPK) throws PortalException {
        BlogsEntryLocalServiceUtil.deleteEntry((long)classPK);
    }

    public String getClassName() {
        return BlogsEntry.class.getName();
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)classPK);
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK, false);
        portletURL.setParameter("entryId", String.valueOf(entry.getEntryId()));
        portletURL.setParameter("urlTitle", entry.getUrlTitle());
        return portletURL.toString();
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        PortletURL portletURL = this.getRestoreURL(portletRequest, classPK, true);
        return portletURL.toString();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return themeDisplay.translate("blogs");
    }

    public boolean isInTrash(long classPK) throws PortalException {
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)classPK);
        return entry.isInTrash();
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        BlogsEntryLocalServiceUtil.restoreEntryFromTrash((long)userId, (long)classPK);
    }

    protected PortletURL getRestoreURL(PortletRequest portletRequest, long classPK, boolean isContainerModel) throws PortalException {
        String portletId = "33";
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)classPK);
        long plid = PortalUtil.getPlidFromPortletId((long)entry.getGroupId(), (String)"33");
        if (plid == 0L) {
            portletId = "161";
            plid = PortalUtil.getControlPanelPlid((PortletRequest)portletRequest);
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        if (!isContainerModel) {
            if (portletId.equals("33")) {
                portletURL.setParameter("struts_action", "/blogs/view_entry");
            } else {
                portletURL.setParameter("struts_action", "/blogs_admin/view_entry");
            }
        }
        return portletURL;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        return BlogsEntryPermission.contains(permissionChecker, classPK, actionId);
    }
}

