/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.trackback;

import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.blogs.linkback.LinkbackConsumer;
import com.liferay.portlet.blogs.linkback.LinkbackConsumerUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.trackback.Trackback;
import com.liferay.portlet.blogs.util.BlogsUtil;

public class TrackbackImpl
implements Trackback {
    private CommentManager _commentManager = BlogsUtil.getCommentManager();
    private LinkbackConsumer _linkbackConsumer = LinkbackConsumerUtil.getLinkbackConsumer();

    @Override
    public void addTrackback(BlogsEntry entry, ThemeDisplay themeDisplay, String excerpt, String url, String blogName, String title, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        long userId = UserLocalServiceUtil.getDefaultUserId((long)themeDisplay.getCompanyId());
        long groupId = entry.getGroupId();
        String className = BlogsEntry.class.getName();
        long classPK = entry.getEntryId();
        String body = this.buildBody(themeDisplay, excerpt, url);
        long commentId = this._commentManager.addComment(userId, groupId, className, classPK, blogName, title, body, serviceContextFunction);
        String entryURL = this.buildEntryURL(entry, themeDisplay);
        this._linkbackConsumer.addNewTrackback(commentId, url, entryURL);
    }

    @Override
    public void setCommentManager(CommentManager commentManager) {
        this._commentManager = commentManager;
    }

    @Override
    public void setLinkbackConsumer(LinkbackConsumer linkbackConsumer) {
        this._linkbackConsumer = linkbackConsumer;
    }

    protected String buildBody(ThemeDisplay themeDisplay, String excerpt, String url) {
        url = StringUtil.replace((String)url, (String[])new String[]{"]", "["}, (String[])new String[]{"%5D", "%5B"});
        StringBundler sb = new StringBundler(7);
        sb.append("[...] ");
        sb.append(excerpt);
        sb.append(" [...] [url=");
        sb.append(url);
        sb.append("]");
        sb.append(themeDisplay.translate("read-more"));
        sb.append("[/url]");
        return sb.toString();
    }

    protected String buildEntryURL(BlogsEntry entry, ThemeDisplay themeDisplay) throws PortalException {
        StringBundler sb = new StringBundler(4);
        sb.append(PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay));
        sb.append("/-/");
        sb.append("blogs/");
        sb.append(entry.getUrlTitle());
        return sb.toString();
    }
}

