/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.blogs.BlogsSettings;
import com.liferay.portlet.blogs.EntryContentException;
import com.liferay.portlet.blogs.EntryDisplayDateException;
import com.liferay.portlet.blogs.EntrySmallImageNameException;
import com.liferay.portlet.blogs.EntrySmallImageSizeException;
import com.liferay.portlet.blogs.EntryTitleException;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.base.BlogsEntryLocalServiceBaseImpl;
import com.liferay.portlet.blogs.util.BlogsUtil;
import com.liferay.portlet.blogs.util.LinkbackProducerUtil;
import com.liferay.portlet.blogs.util.comparator.EntryDisplayDateComparator;
import com.liferay.portlet.trash.model.TrashEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

public class BlogsEntryLocalServiceImpl
extends BlogsEntryLocalServiceBaseImpl {
    @BeanReference(type=CommentManager.class)
    protected CommentManager commentManager;
    private static Log _log = LogFactoryUtil.getLog(BlogsEntryLocalServiceImpl.class);

    @Deprecated
    public BlogsEntry addEntry(long userId, String title, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, boolean smallImage, String smallImageURL, String smallImageFileName, InputStream smallImageInputStream, ServiceContext serviceContext) throws PortalException {
        ImageSelector imageSelector = null;
        if (smallImage && Validator.isNotNull((String)smallImageFileName) && smallImageInputStream != null) {
            FileEntry fileEntry = TempFileEntryUtil.addTempFileEntry((long)serviceContext.getScopeGroupId(), (long)userId, (String)BlogsEntry.class.getName(), (String)smallImageFileName, (InputStream)smallImageInputStream, (String)MimeTypesUtil.getContentType((String)smallImageFileName));
            imageSelector = new ImageSelector(fileEntry.getFileEntryId(), smallImageURL);
        }
        return this.addEntry(userId, title, "", description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, imageSelector, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BlogsEntry addEntry(long userId, String title, String subtitle, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, ImageSelector imageSelector, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), EntryDisplayDateException.class);
        boolean smallImage = false;
        long smallImageFileEntryId = 0L;
        String smallImageURL = null;
        if (imageSelector != null) {
            smallImage = !imageSelector.isRemoveSmallImage();
            smallImageFileEntryId = imageSelector.getImageId();
            smallImageURL = imageSelector.getImageURL();
        }
        long entryId = this.counterLocalService.increment();
        if (smallImageFileEntryId != 0L) {
            FileEntry tempFileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)smallImageFileEntryId);
            Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)groupId, (long)userId, (String)"33", (long)0L, (String)String.valueOf(entryId), (ServiceContext)serviceContext);
            FileEntry fileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)BlogsEntry.class.getName(), (long)entryId, (String)"33", (long)folder.getFolderId(), (InputStream)tempFileEntry.getContentStream(), (String)tempFileEntry.getTitle(), (String)tempFileEntry.getMimeType(), (boolean)false);
            smallImageFileEntryId = fileEntry.getFileEntryId();
            PortletFileRepositoryUtil.deletePortletFileEntry((long)tempFileEntry.getFileEntryId());
        }
        Date now = new Date();
        this.validate(title, content, smallImageFileEntryId);
        BlogsEntry entry = this.blogsEntryPersistence.create(entryId);
        entry.setUuid(serviceContext.getUuid());
        entry.setGroupId(groupId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setCreateDate(serviceContext.getCreateDate(now));
        entry.setModifiedDate(serviceContext.getModifiedDate(now));
        entry.setTitle(title);
        entry.setSubtitle(subtitle);
        entry.setUrlTitle(this.getUniqueUrlTitle(entryId, title, null, serviceContext));
        entry.setDescription(description);
        entry.setContent(content);
        entry.setDisplayDate(displayDate);
        entry.setAllowPingbacks(allowPingbacks);
        entry.setAllowTrackbacks(allowTrackbacks);
        entry.setSmallImage(smallImage);
        entry.setSmallImageFileEntryId(smallImageFileEntryId);
        entry.setSmallImageURL(smallImageURL);
        entry.setStatus(2);
        entry.setStatusByUserId(userId);
        entry.setStatusDate(serviceContext.getModifiedDate(now));
        entry.setExpandoBridgeAttributes(serviceContext);
        this.blogsEntryPersistence.update((BaseModel)entry);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addEntryResources(entry, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addEntryResources(entry, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this.addDiscussion(entry, userId, groupId);
        if (ArrayUtil.isNotEmpty((Object[])trackbacks)) {
            serviceContext.setAttribute("trackbacks", (Serializable)trackbacks);
        } else {
            serviceContext.setAttribute("trackbacks", null);
        }
        return this.startWorkflowInstance(userId, entry, serviceContext);
    }

    public void addEntryResources(BlogsEntry entry, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BlogsEntry.class.getName(), entry.getEntryId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addEntryResources(BlogsEntry entry, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BlogsEntry.class.getName(), entry.getEntryId(), groupPermissions, guestPermissions);
    }

    public void addEntryResources(long entryId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, addGroupPermissions, addGuestPermissions);
    }

    public void addEntryResources(long entryId, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, groupPermissions, guestPermissions);
    }

    public void checkEntries() throws PortalException {
        Date now = new Date();
        int count = this.blogsEntryPersistence.countByLtD_S(now, 7);
        if (count == 0) {
            return;
        }
        List entries = this.blogsEntryPersistence.findByLtD_S(now, 7);
        for (BlogsEntry entry : entries) {
            ServiceContext serviceContext = new ServiceContext();
            String[] trackbacks = StringUtil.split((String)entry.getTrackbacks());
            serviceContext.setAttribute("trackbacks", (Serializable)trackbacks);
            serviceContext.setCommand("update");
            String layoutFullURL = PortalUtil.getLayoutFullURL((long)entry.getGroupId(), (String)"33");
            serviceContext.setLayoutFullURL(layoutFullURL);
            serviceContext.setScopeGroupId(entry.getGroupId());
            this.blogsEntryLocalService.updateStatus(entry.getStatusByUserId(), entry.getEntryId(), 0, serviceContext, new HashMap());
        }
    }

    public void deleteEntries(long groupId) throws PortalException {
        for (BlogsEntry entry : this.blogsEntryPersistence.findByGroupId(groupId)) {
            this.blogsEntryLocalService.deleteEntry(entry);
        }
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public BlogsEntry deleteEntry(BlogsEntry entry) throws PortalException {
        this.blogsEntryPersistence.remove((BaseModel)entry);
        this.resourceLocalService.deleteResource(entry.getCompanyId(), BlogsEntry.class.getName(), 4, entry.getEntryId());
        this.imageLocalService.deleteImage(entry.getSmallImageId());
        long smallImageFolderId = entry.getSmallImageFolderId();
        if (smallImageFolderId != 0L) {
            PortletFileRepositoryUtil.deletePortletFolder((long)smallImageFolderId);
        }
        this.subscriptionLocalService.deleteSubscriptions(entry.getCompanyId(), BlogsEntry.class.getName(), entry.getEntryId());
        this.blogsStatsUserLocalService.updateStatsUser(entry.getGroupId(), entry.getUserId(), entry.getDisplayDate());
        this.assetEntryLocalService.deleteEntry(BlogsEntry.class.getName(), entry.getEntryId());
        this.deleteDiscussion(entry);
        this.expandoRowLocalService.deleteRows(entry.getEntryId());
        this.ratingsStatsLocalService.deleteStats(BlogsEntry.class.getName(), entry.getEntryId());
        this.trashEntryLocalService.deleteEntry(BlogsEntry.class.getName(), entry.getEntryId());
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(BlogsEntry.class);
        indexer.delete((Object)entry);
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(entry.getCompanyId(), entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId());
        return entry;
    }

    public void deleteEntry(long entryId) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.blogsEntryLocalService.deleteEntry(entry);
    }

    @Deprecated
    public List<BlogsEntry> getCompanyEntries(long companyId, Date displayDate, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.getCompanyEntries(companyId, displayDate, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    @Deprecated
    public List<BlogsEntry> getCompanyEntries(long companyId, Date displayDate, int status, int start, int end, OrderByComparator<BlogsEntry> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.getCompanyEntries(companyId, displayDate, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    public List<BlogsEntry> getCompanyEntries(long companyId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.findByC_LtD_NotS(companyId, displayDate, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
        }
        return this.blogsEntryPersistence.findByC_LtD_S(companyId, displayDate, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
    }

    @Deprecated
    public int getCompanyEntriesCount(long companyId, Date displayDate, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getCompanyEntriesCount(companyId, displayDate, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    public int getCompanyEntriesCount(long companyId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.countByC_LtD_NotS(companyId, displayDate, queryDefinition.getStatus());
        }
        return this.blogsEntryPersistence.countByC_LtD_S(companyId, displayDate, queryDefinition.getStatus());
    }

    public BlogsEntry[] getEntriesPrevAndNext(long entryId) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        return this.blogsEntryPersistence.findByG_S_PrevAndNext(entry.getEntryId(), entry.getGroupId(), 0, (OrderByComparator)new EntryDisplayDateComparator(true));
    }

    public BlogsEntry getEntry(long entryId) throws PortalException {
        return this.blogsEntryPersistence.findByPrimaryKey(entryId);
    }

    public BlogsEntry getEntry(long groupId, String urlTitle) throws PortalException {
        return this.blogsEntryPersistence.findByG_UT(groupId, urlTitle);
    }

    @Deprecated
    public List<BlogsEntry> getGroupEntries(long groupId, Date displayDate, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.getGroupEntries(groupId, displayDate, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    @Deprecated
    public List<BlogsEntry> getGroupEntries(long groupId, Date displayDate, int status, int start, int end, OrderByComparator<BlogsEntry> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.getGroupEntries(groupId, displayDate, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.findByG_LtD_NotS(groupId, displayDate, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
        }
        return this.blogsEntryPersistence.findByG_LtD_S(groupId, displayDate, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
    }

    @Deprecated
    public List<BlogsEntry> getGroupEntries(long groupId, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.getGroupEntries(groupId, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    @Deprecated
    public List<BlogsEntry> getGroupEntries(long groupId, int status, int start, int end, OrderByComparator<BlogsEntry> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.getGroupEntries(groupId, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.findByG_NotS(groupId, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
        }
        return this.blogsEntryPersistence.findByG_S(groupId, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
    }

    @Deprecated
    public int getGroupEntriesCount(long groupId, Date displayDate, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getGroupEntriesCount(groupId, displayDate, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    public int getGroupEntriesCount(long groupId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.countByG_LtD_NotS(groupId, displayDate, queryDefinition.getStatus());
        }
        return this.blogsEntryPersistence.countByG_LtD_S(groupId, displayDate, queryDefinition.getStatus());
    }

    @Deprecated
    public int getGroupEntriesCount(long groupId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getGroupEntriesCount(groupId, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    public int getGroupEntriesCount(long groupId, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.countByG_NotS(groupId, queryDefinition.getStatus());
        }
        return this.blogsEntryPersistence.countByG_S(groupId, queryDefinition.getStatus());
    }

    @Deprecated
    public List<BlogsEntry> getGroupsEntries(long companyId, long groupId, Date displayDate, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.getGroupsEntries(companyId, groupId, displayDate, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    public List<BlogsEntry> getGroupsEntries(long companyId, long groupId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        return this.blogsEntryFinder.findByGroupIds(companyId, groupId, displayDate, queryDefinition);
    }

    @Deprecated
    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, Date displayDate, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.getGroupUserEntries(groupId, userId, displayDate, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    @Deprecated
    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, Date displayDate, int status, int start, int end, OrderByComparator<BlogsEntry> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.getGroupUserEntries(groupId, userId, displayDate, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.findByG_U_NotS(groupId, userId, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
        }
        return this.blogsEntryPersistence.findByG_U_S(groupId, userId, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd(), queryDefinition.getOrderByComparator());
    }

    @Deprecated
    public int getGroupUserEntriesCount(long groupId, long userId, Date displayDate, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getGroupUserEntriesCount(groupId, userId, displayDate, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    public int getGroupUserEntriesCount(long groupId, long userId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.blogsEntryPersistence.countByG_U_LtD_NotS(groupId, userId, displayDate, queryDefinition.getStatus());
        }
        return this.blogsEntryPersistence.countByG_U_LtD_S(groupId, userId, displayDate, queryDefinition.getStatus());
    }

    public List<BlogsEntry> getNoAssetEntries() {
        return this.blogsEntryFinder.findByNoAssets();
    }

    @Deprecated
    public List<BlogsEntry> getOrganizationEntries(long organizationId, Date displayDate, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.getOrganizationEntries(organizationId, displayDate, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    @Deprecated
    public List<BlogsEntry> getOrganizationEntries(long organizationId, Date displayDate, int status, int start, int end, OrderByComparator<BlogsEntry> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.getOrganizationEntries(organizationId, displayDate, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    public List<BlogsEntry> getOrganizationEntries(long organizationId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        return this.blogsEntryFinder.findByOrganizationId(organizationId, displayDate, queryDefinition);
    }

    @Deprecated
    public int getOrganizationEntriesCount(long organizationId, Date displayDate, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getOrganizationEntriesCount(organizationId, displayDate, (QueryDefinition<BlogsEntry>)queryDefinition);
    }

    public int getOrganizationEntriesCount(long organizationId, Date displayDate, QueryDefinition<BlogsEntry> queryDefinition) {
        return this.blogsEntryFinder.countByOrganizationId(organizationId, displayDate, queryDefinition);
    }

    public void moveEntriesToTrash(long groupId, long userId) throws PortalException {
        List entries = this.blogsEntryPersistence.findByGroupId(groupId);
        for (BlogsEntry entry : entries) {
            this.blogsEntryLocalService.moveEntryToTrash(userId, entry);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public BlogsEntry moveEntryToTrash(long userId, BlogsEntry entry) throws PortalException {
        int oldStatus = entry.getStatus();
        if (oldStatus == 1) {
            entry.setStatus(2);
            this.blogsEntryPersistence.update((BaseModel)entry);
        }
        entry = this.updateStatus(userId, entry.getEntryId(), 8, new ServiceContext());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", entry.getTitle());
        this.socialActivityLocalService.addActivity(userId, entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), 10007, extraDataJSONObject.toString(), 0L);
        if (oldStatus == 1) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(entry.getCompanyId(), entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId());
        }
        return entry;
    }

    public BlogsEntry moveEntryToTrash(long userId, long entryId) throws PortalException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        return this.blogsEntryLocalService.moveEntryToTrash(userId, entry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BlogsEntry restoreEntryFromTrash(long userId, long entryId) throws PortalException {
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(BlogsEntry.class.getName(), entryId);
        BlogsEntry entry = this.updateStatus(userId, entryId, trashEntry.getStatus(), new ServiceContext());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", entry.getTitle());
        this.socialActivityLocalService.addActivity(userId, trashEntry.getGroupId(), BlogsEntry.class.getName(), entryId, 10008, extraDataJSONObject.toString(), 0L);
        return entry;
    }

    public void subscribe(long userId, long groupId) throws PortalException {
        this.subscriptionLocalService.addSubscription(userId, groupId, BlogsEntry.class.getName(), groupId);
    }

    public void unsubscribe(long userId, long groupId) throws PortalException {
        this.subscriptionLocalService.deleteSubscription(userId, BlogsEntry.class.getName(), groupId);
    }

    public void updateAsset(long userId, BlogsEntry entry, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        boolean visible = false;
        if (entry.isApproved()) {
            visible = true;
        }
        String summary = HtmlUtil.extractText((String)StringUtil.shorten((String)entry.getContent(), (int)500));
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, entry.getGroupId(), entry.getCreateDate(), entry.getModifiedDate(), BlogsEntry.class.getName(), entry.getEntryId(), entry.getUuid(), 0L, assetCategoryIds, assetTagNames, visible, null, null, null, "text/html", entry.getTitle(), entry.getDescription(), summary, null, null, 0, 0, null, false);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Deprecated
    public BlogsEntry updateEntry(long userId, long entryId, String title, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, boolean smallImage, String smallImageURL, String smallImageFileName, InputStream smallImageInputStream, ServiceContext serviceContext) throws PortalException {
        ImageSelector imageSelector = null;
        if (smallImage) {
            if (Validator.isNotNull((String)smallImageFileName) && smallImageInputStream != null) {
                FileEntry fileEntry = TempFileEntryUtil.addTempFileEntry((long)serviceContext.getScopeGroupId(), (long)userId, (String)BlogsEntry.class.getName(), (String)smallImageFileName, (InputStream)smallImageInputStream, (String)MimeTypesUtil.getContentType((String)smallImageFileName));
                imageSelector = new ImageSelector(fileEntry.getFileEntryId(), smallImageURL);
            }
        } else {
            imageSelector = new ImageSelector(0L);
        }
        return this.updateEntry(userId, entryId, title, "", description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, imageSelector, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BlogsEntry updateEntry(long userId, long entryId, String title, String subtitle, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, ImageSelector imageSelector, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), EntryDisplayDateException.class);
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        boolean smallImage = entry.isSmallImage();
        long smallImageFileEntryId = 0L;
        String smallImageURL = null;
        if (imageSelector != null) {
            if (imageSelector.getImageId() == 0L) {
                if (entry.getSmallImageFileEntryId() != 0L) {
                    PortletFileRepositoryUtil.deletePortletFileEntry((long)entry.getSmallImageFileEntryId());
                }
            } else if (imageSelector.getImageId() != entry.getSmallImageFileEntryId()) {
                if (entry.getSmallImageFileEntryId() != 0L) {
                    PortletFileRepositoryUtil.deletePortletFileEntry((long)entry.getSmallImageFileEntryId());
                }
                FileEntry tempFileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)imageSelector.getImageId());
                FileEntry fileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)entry.getGroupId(), (long)userId, (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (String)"33", (long)0L, (InputStream)tempFileEntry.getContentStream(), (String)tempFileEntry.getTitle(), (String)tempFileEntry.getMimeType(), (boolean)false);
                smallImageFileEntryId = fileEntry.getFileEntryId();
                PortletFileRepositoryUtil.deletePortletFileEntry((long)tempFileEntry.getFileEntryId());
            }
            smallImage = !imageSelector.isRemoveSmallImage();
            smallImageURL = imageSelector.getImageURL();
        }
        this.validate(title, content, smallImageFileEntryId);
        String oldUrlTitle = entry.getUrlTitle();
        entry.setModifiedDate(serviceContext.getModifiedDate(null));
        entry.setTitle(title);
        entry.setSubtitle(subtitle);
        entry.setUrlTitle(this.getUniqueUrlTitle(entryId, title, oldUrlTitle, serviceContext));
        entry.setDescription(description);
        entry.setContent(content);
        entry.setDisplayDate(displayDate);
        entry.setAllowPingbacks(allowPingbacks);
        entry.setAllowTrackbacks(allowTrackbacks);
        entry.setSmallImage(smallImage);
        entry.setSmallImageFileEntryId(smallImageFileEntryId);
        entry.setSmallImageURL(smallImageURL);
        if (!entry.isPending() && !entry.isDraft()) {
            entry.setStatus(2);
        }
        entry.setExpandoBridgeAttributes(serviceContext);
        this.blogsEntryPersistence.update((BaseModel)entry);
        if (serviceContext.getGroupPermissions() != null || serviceContext.getGuestPermissions() != null) {
            this.updateEntryResources(entry, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        boolean pingOldTrackbacks = false;
        if (!oldUrlTitle.equals(entry.getUrlTitle())) {
            pingOldTrackbacks = true;
        }
        serviceContext.setAttribute("pingOldTrackbacks", (Serializable)((Object)String.valueOf(pingOldTrackbacks)));
        if (ArrayUtil.isNotEmpty((Object[])trackbacks)) {
            serviceContext.setAttribute("trackbacks", (Serializable)trackbacks);
        } else {
            serviceContext.setAttribute("trackbacks", null);
        }
        return this.startWorkflowInstance(userId, entry, serviceContext);
    }

    public void updateEntryResources(BlogsEntry entry, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.updateResources(entry.getCompanyId(), entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), groupPermissions, guestPermissions);
    }

    @Deprecated
    public BlogsEntry updateStatus(long userId, long entryId, int status, ServiceContext serviceContext) throws PortalException {
        return this.updateStatus(userId, entryId, status, serviceContext, new HashMap<String, Serializable>());
    }

    @Indexable(type=IndexableType.REINDEX)
    public BlogsEntry updateStatus(long userId, long entryId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        int oldStatus = entry.getStatus();
        if (status == 0 && now.before(entry.getDisplayDate())) {
            status = 7;
        }
        entry.setModifiedDate(serviceContext.getModifiedDate(now));
        entry.setStatus(status);
        entry.setStatusByUserId(user.getUserId());
        entry.setStatusByUserName(user.getFullName());
        entry.setStatusDate(serviceContext.getModifiedDate(now));
        this.blogsEntryPersistence.update((BaseModel)entry);
        this.blogsStatsUserLocalService.updateStatsUser(entry.getGroupId(), entry.getUserId(), entry.getDisplayDate());
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(BlogsEntry.class.getName(), entryId);
        if (assetEntry == null || assetEntry.getPublishDate() == null) {
            serviceContext.setCommand("add");
        }
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", entry.getTitle());
        if (status == 0) {
            this.assetEntryLocalService.updateEntry(BlogsEntry.class.getName(), entryId, entry.getDisplayDate(), true);
            if (oldStatus != 8 && oldStatus != 7) {
                if (serviceContext.isCommandUpdate()) {
                    this.socialActivityLocalService.addActivity(user.getUserId(), entry.getGroupId(), BlogsEntry.class.getName(), entryId, 3, extraDataJSONObject.toString(), 0L);
                } else {
                    this.socialActivityLocalService.addUniqueActivity(user.getUserId(), entry.getGroupId(), BlogsEntry.class.getName(), entryId, 2, extraDataJSONObject.toString(), 0L);
                }
            }
            if (oldStatus == 8) {
                this.trashEntryLocalService.deleteEntry(BlogsEntry.class.getName(), entryId);
            }
            if (oldStatus != 8) {
                this.notifySubscribers(entry, serviceContext, workflowContext);
                String[] trackbacks = (String[])serviceContext.getAttribute("trackbacks");
                Boolean pingOldTrackbacks = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"pingOldTrackbacks");
                this.pingGoogle(entry, serviceContext);
                this.pingPingback(entry, serviceContext);
                this.pingTrackbacks(entry, trackbacks, pingOldTrackbacks, serviceContext);
            }
        } else {
            this.assetEntryLocalService.updateVisible(BlogsEntry.class.getName(), entryId, false);
            if (status == 7 && oldStatus != 8) {
                if (serviceContext.isCommandUpdate()) {
                    this.socialActivityLocalService.addActivity(user.getUserId(), entry.getGroupId(), BlogsEntry.class.getName(), entryId, 3, extraDataJSONObject.toString(), 0L);
                } else {
                    this.socialActivityLocalService.addUniqueActivity(user.getUserId(), entry.getGroupId(), BlogsEntry.class.getName(), entryId, 2, extraDataJSONObject.toString(), 0L);
                }
            }
            if (status == 8) {
                this.trashEntryLocalService.addTrashEntry(userId, entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), entry.getUuid(), null, oldStatus, null, null);
            } else if (oldStatus == 8) {
                this.trashEntryLocalService.deleteEntry(BlogsEntry.class.getName(), entryId);
            }
        }
        return entry;
    }

    protected void addDiscussion(BlogsEntry entry, long userId, long groupId) throws PortalException {
        if (PropsValues.BLOGS_ENTRY_COMMENTS_ENABLED) {
            this.commentManager.addDiscussion(userId, groupId, BlogsEntry.class.getName(), entry.getEntryId(), entry.getUserName());
        }
    }

    protected void deleteDiscussion(BlogsEntry entry) throws PortalException {
        this.commentManager.deleteDiscussion(BlogsEntry.class.getName(), entry.getEntryId());
    }

    protected String getEntryURL(BlogsEntry entry, ServiceContext serviceContext) throws PortalException {
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null) {
            return "";
        }
        String layoutURL = this.getLayoutURL(entry.getGroupId(), "33", serviceContext);
        if (Validator.isNotNull((String)layoutURL)) {
            return layoutURL + "/-/" + "blogs" + "/" + entry.getEntryId();
        }
        long controlPanelPlid = PortalUtil.getControlPanelPlid((long)serviceContext.getCompanyId());
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"161", (long)controlPanelPlid, (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/blogs_admin/view_entry");
        portletURL.setParameter("entryId", String.valueOf(entry.getEntryId()));
        return portletURL.toString();
    }

    protected String getUniqueUrlTitle(long entryId, long groupId, String title) {
        BlogsEntry entry;
        String urlTitle = BlogsUtil.getUrlTitle(entryId, title);
        int i = 1;
        while ((entry = this.blogsEntryPersistence.fetchByG_UT(groupId, urlTitle)) != null && entryId != entry.getEntryId()) {
            String suffix = "-" + i;
            String prefix = urlTitle;
            if (urlTitle.length() > suffix.length()) {
                prefix = urlTitle.substring(0, urlTitle.length() - suffix.length());
            }
            urlTitle = prefix + suffix;
            ++i;
        }
        return urlTitle;
    }

    protected String getUniqueUrlTitle(long entryId, String title, String oldUrlTitle, ServiceContext serviceContext) {
        String serviceContextUrlTitle = ParamUtil.getString((ServiceContext)serviceContext, (String)"urlTitle");
        String urlTitle = null;
        if (Validator.isNotNull((String)serviceContextUrlTitle)) {
            urlTitle = BlogsUtil.getUrlTitle(entryId, serviceContextUrlTitle);
        } else {
            if (Validator.isNotNull((String)oldUrlTitle)) {
                return oldUrlTitle;
            }
            urlTitle = this.getUniqueUrlTitle(entryId, serviceContext.getScopeGroupId(), title);
        }
        BlogsEntry urlTitleEntry = this.blogsEntryPersistence.fetchByG_UT(serviceContext.getScopeGroupId(), urlTitle);
        if (urlTitleEntry != null && urlTitleEntry.getEntryId() != entryId) {
            urlTitle = this.getUniqueUrlTitle(entryId, serviceContext.getScopeGroupId(), urlTitle);
        }
        return urlTitle;
    }

    protected void notifySubscribers(BlogsEntry entry, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        String entryURL = (String)((Object)workflowContext.get("url"));
        if (!entry.isApproved() || Validator.isNull((String)entryURL)) {
            return;
        }
        BlogsSettings blogsSettings = BlogsSettings.getInstance(entry.getGroupId());
        boolean sendEmailEntryUpdated = GetterUtil.getBoolean((Object)serviceContext.getAttribute("sendEmailEntryUpdated"));
        if (!(serviceContext.isCommandAdd() && blogsSettings.isEmailEntryAddedEnabled() || sendEmailEntryUpdated && serviceContext.isCommandUpdate() && blogsSettings.isEmailEntryUpdatedEnabled())) {
            return;
        }
        String entryTitle = entry.getTitle();
        String fromName = blogsSettings.getEmailFromName();
        String fromAddress = blogsSettings.getEmailFromAddress();
        LocalizedValuesMap subjectLocalizedValuesMap = null;
        LocalizedValuesMap bodyLocalizedValuesMap = null;
        if (serviceContext.isCommandUpdate()) {
            subjectLocalizedValuesMap = blogsSettings.getEmailEntryUpdatedSubject();
            bodyLocalizedValuesMap = blogsSettings.getEmailEntryUpdatedBody();
        } else {
            subjectLocalizedValuesMap = blogsSettings.getEmailEntryAddedSubject();
            bodyLocalizedValuesMap = blogsSettings.getEmailEntryAddedBody();
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setClassPK(entry.getEntryId());
        subscriptionSender.setClassName(entry.getModelClassName());
        subscriptionSender.setCompanyId(entry.getCompanyId());
        subscriptionSender.setContextAttribute("[$BLOGS_ENTRY_CONTENT$]", (Object)StringUtil.shorten((String)HtmlUtil.stripHtml((String)entry.getContent()), (int)500), false);
        subscriptionSender.setContextAttributes(new Object[]{"[$BLOGS_ENTRY_CREATE_DATE$]", Time.getSimpleDate((Date)entry.getCreateDate(), (String)"yyyy/MM/dd"), "[$BLOGS_ENTRY_DESCRIPTION$]", entry.getDescription(), "[$BLOGS_ENTRY_SITE_NAME$]", this.groupLocalService.getGroupDescriptiveName(entry.getGroupId(), serviceContext.getLocale()), "[$BLOGS_ENTRY_STATUS_BY_USER_NAME$]", entry.getStatusByUserName(), "[$BLOGS_ENTRY_TITLE$]", entryTitle, "[$BLOGS_ENTRY_UPDATE_COMMENT$]", HtmlUtil.replaceNewLine((String)GetterUtil.getString((Object)serviceContext.getAttribute("emailEntryUpdatedComment"))), "[$BLOGS_ENTRY_URL$]", entryURL, "[$BLOGS_ENTRY_USER_PORTRAIT_URL$]", workflowContext.get("userPortraitURL"), "[$BLOGS_ENTRY_USER_URL$]", workflowContext.get("userURL")});
        subscriptionSender.setContextUserPrefix("BLOGS_ENTRY");
        subscriptionSender.setEntryTitle(entryTitle);
        subscriptionSender.setEntryURL(entryURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap((Map)bodyLocalizedValuesMap);
        subscriptionSender.setLocalizedSubjectMap((Map)subjectLocalizedValuesMap);
        subscriptionSender.setMailId("blogs_entry", new Object[]{entry.getEntryId()});
        int notificationType = 0;
        if (serviceContext.isCommandUpdate()) {
            notificationType = 1;
        }
        subscriptionSender.setNotificationType(notificationType);
        subscriptionSender.setPortletId("33");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(entry.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setUserId(entry.getUserId());
        subscriptionSender.addPersistedSubscribers(BlogsEntry.class.getName(), entry.getGroupId());
        subscriptionSender.addPersistedSubscribers(BlogsEntry.class.getName(), entry.getEntryId());
        subscriptionSender.flushNotificationsAsync();
    }

    protected void pingGoogle(BlogsEntry entry, ServiceContext serviceContext) throws PortalException {
        if (!PropsValues.BLOGS_PING_GOOGLE_ENABLED || !entry.isApproved()) {
            return;
        }
        String layoutFullURL = PortalUtil.getLayoutFullURL((long)serviceContext.getScopeGroupId(), (String)"33");
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        if (layoutFullURL.contains("://localhost")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not pinging Google because of localhost URL " + layoutFullURL));
            }
            return;
        }
        Group group = this.groupPersistence.findByPrimaryKey(entry.getGroupId());
        StringBundler sb = new StringBundler(6);
        String name = group.getDescriptiveName();
        String url = layoutFullURL + "/-/" + "blogs";
        String changesURL = layoutFullURL + "/-/" + "blogs/rss";
        sb.append("http://blogsearch.google.com/ping?name=");
        sb.append(HttpUtil.encodeURL((String)name));
        sb.append("&url=");
        sb.append(HttpUtil.encodeURL((String)url));
        sb.append("&changesURL=");
        sb.append(HttpUtil.encodeURL((String)changesURL));
        String location = sb.toString();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Pinging Google at " + location));
        }
        try {
            String response = HttpUtil.URLtoString((String)sb.toString());
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Google ping response: " + response));
            }
        }
        catch (IOException ioe) {
            _log.error((Object)("Unable to ping Google at " + location), (Throwable)ioe);
        }
    }

    protected void pingPingback(BlogsEntry entry, ServiceContext serviceContext) throws PortalException {
        if (!(PropsValues.BLOGS_PINGBACK_ENABLED && entry.isAllowPingbacks() && entry.isApproved())) {
            return;
        }
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String layoutFullURL = PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay);
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        String sourceUri = layoutFullURL + "/-/" + "blogs/" + entry.getUrlTitle();
        Source source = new Source((CharSequence)entry.getContent());
        List tags = source.getAllStartTags("a");
        for (StartTag tag : tags) {
            String targetUri = tag.getAttributeValue("href");
            if (!Validator.isNotNull((String)targetUri)) continue;
            try {
                LinkbackProducerUtil.sendPingback(sourceUri, targetUri);
            }
            catch (Exception e) {
                _log.error((Object)("Error while sending pingback " + targetUri), (Throwable)e);
            }
        }
    }

    protected void pingTrackbacks(BlogsEntry entry, String[] trackbacks, boolean pingOldTrackbacks, ServiceContext serviceContext) throws PortalException {
        if (!(PropsValues.BLOGS_TRACKBACK_ENABLED && entry.isAllowTrackbacks() && entry.isApproved())) {
            return;
        }
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String layoutFullURL = PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay);
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        HashMap<String, String> parts = new HashMap<String, String>();
        String excerpt = StringUtil.shorten((String)HtmlUtil.extractText((String)entry.getContent()), (int)PropsValues.BLOGS_LINKBACK_EXCERPT_LENGTH);
        String url = layoutFullURL + "/-/" + "blogs/" + entry.getUrlTitle();
        parts.put("title", entry.getTitle());
        parts.put("excerpt", excerpt);
        parts.put("url", url);
        parts.put("blog_name", entry.getUserName());
        HashSet trackbacksSet = null;
        trackbacksSet = ArrayUtil.isNotEmpty((Object[])trackbacks) ? SetUtil.fromArray((Object[])trackbacks) : new HashSet();
        if (pingOldTrackbacks) {
            trackbacksSet.addAll(SetUtil.fromArray((Object[])StringUtil.split((String)entry.getTrackbacks())));
            entry.setTrackbacks("");
            this.blogsEntryPersistence.update((BaseModel)entry);
        }
        Set oldTrackbacks = SetUtil.fromArray((Object[])StringUtil.split((String)entry.getTrackbacks()));
        HashSet<String> validTrackbacks = new HashSet<String>();
        for (String trackback : trackbacksSet) {
            if (oldTrackbacks.contains(trackback)) continue;
            try {
                if (!LinkbackProducerUtil.sendTrackback(trackback, parts)) continue;
                validTrackbacks.add(trackback);
            }
            catch (Exception e) {
                _log.error((Object)("Error while sending trackback at " + trackback), (Throwable)e);
            }
        }
        if (!validTrackbacks.isEmpty()) {
            String newTrackbacks = StringUtil.merge(validTrackbacks);
            if (Validator.isNotNull((String)entry.getTrackbacks())) {
                newTrackbacks = newTrackbacks + "," + entry.getTrackbacks();
            }
            entry.setTrackbacks(newTrackbacks);
            this.blogsEntryPersistence.update((BaseModel)entry);
        }
    }

    protected BlogsEntry startWorkflowInstance(long userId, BlogsEntry entry, ServiceContext serviceContext) throws PortalException {
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        workflowContext.put("url", this.getEntryURL(entry, serviceContext));
        String userPortraitURL = "";
        String userURL = "";
        if (serviceContext.getThemeDisplay() != null) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            userPortraitURL = user.getPortraitURL(serviceContext.getThemeDisplay());
            userURL = user.getDisplayURL(serviceContext.getThemeDisplay());
        }
        workflowContext.put("userPortraitURL", userPortraitURL);
        workflowContext.put("userURL", userURL);
        return (BlogsEntry)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)entry.getCompanyId(), (long)entry.getGroupId(), (long)userId, (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (Object)entry, (ServiceContext)serviceContext, workflowContext);
    }

    protected void validate(String title, String content, long smallImageFileEntryId) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new EntryTitleException();
        }
        if (Validator.isNull((String)content)) {
            throw new EntryContentException();
        }
        String[] imageExtensions = PrefsPropsUtil.getStringArray("blogs.image.extensions", ",");
        if (smallImageFileEntryId != 0L) {
            FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)smallImageFileEntryId);
            boolean validSmallImageExtension = false;
            for (String _imageExtension : imageExtensions) {
                if (!"*".equals(_imageExtension) && !_imageExtension.equals("." + fileEntry.getExtension())) continue;
                validSmallImageExtension = true;
                break;
            }
            if (!validSmallImageExtension) {
                throw new EntrySmallImageNameException("Invalid small image for file entry " + smallImageFileEntryId);
            }
            long smallImageMaxSize = PrefsPropsUtil.getLong("blogs.image.small.max.size");
            if (smallImageMaxSize > 0L && fileEntry.getSize() > smallImageMaxSize) {
                throw new EntrySmallImageSizeException();
            }
        }
    }
}

