/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;

public class BlogsEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<BlogsEntry> {
    public static final String[] CLASS_NAMES = new String[]{BlogsEntry.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(BlogsEntryStagedModelDataHandler.class);

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        BlogsEntry entry = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (entry != null) {
            BlogsEntryLocalServiceUtil.deleteEntry((BlogsEntry)entry);
        }
    }

    public BlogsEntry fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List entries = BlogsEntryLocalServiceUtil.getBlogsEntriesByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)entries)) {
            return null;
        }
        return (BlogsEntry)entries.get(0);
    }

    public BlogsEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return BlogsEntryLocalServiceUtil.fetchBlogsEntryByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(BlogsEntry entry) {
        return entry.getTitle();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)entry);
        if (entry.isSmallImage()) {
            Image smallImage = ImageLocalServiceUtil.fetchImage((long)entry.getSmallImageId());
            if (Validator.isNotNull((String)entry.getSmallImageURL())) {
                String smallImageURL = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)entry, (String)(entry.getSmallImageURL() + " "), (boolean)true);
                entry.setSmallImageURL(smallImageURL);
            } else if (smallImage != null) {
                String smallImagePath = ExportImportPathUtil.getModelPath((StagedModel)entry, (String)(smallImage.getImageId() + "." + smallImage.getType()));
                entryElement.addAttribute("small-image-path", smallImagePath);
                entry.setSmallImageType(smallImage.getType());
                portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
            }
        }
        if (entry.getSmallImageFileEntryId() != 0L) {
            FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)entry.getSmallImageFileEntryId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)entry, (StagedModel)fileEntry, (String)"weak");
        }
        String content = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)entry, (String)entry.getContent(), (boolean)portletDataContext.getBooleanParameter("blogs", "referenced-content"));
        entry.setContent(content);
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)entry), (ClassedModel)entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        long userId = portletDataContext.getUserId(entry.getUserUuid());
        Element entryElement = portletDataContext.getImportDataStagedModelElement((StagedModel)entry);
        String content = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (StagedModel)entry, (String)entry.getContent());
        entry.setContent(content);
        Calendar displayDateCal = CalendarFactoryUtil.getCalendar();
        displayDateCal.setTime(entry.getDisplayDate());
        int displayDateMonth = displayDateCal.get(2);
        int displayDateDay = displayDateCal.get(5);
        int displayDateYear = displayDateCal.get(1);
        int displayDateHour = displayDateCal.get(10);
        int displayDateMinute = displayDateCal.get(12);
        if (displayDateCal.get(9) == 1) {
            displayDateHour += 12;
        }
        boolean allowPingbacks = entry.isAllowPingbacks();
        boolean allowTrackbacks = entry.isAllowTrackbacks();
        String[] trackbacks = StringUtil.split((String)entry.getTrackbacks());
        long smallImageFileEntryId = 0L;
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)entry);
        if (entry.isSmallImage()) {
            String smallImagePath = entryElement.attributeValue("small-image-path");
            if (Validator.isNotNull((String)entry.getSmallImageURL())) {
                String smallImageURL = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (StagedModel)entry, (String)entry.getSmallImageURL());
                entry.setSmallImageURL(smallImageURL);
            } else if (Validator.isNotNull((String)smallImagePath)) {
                String smallImageFileName = entry.getSmallImageId() + "." + entry.getSmallImageType();
                InputStream inputStream = null;
                try {
                    inputStream = portletDataContext.getZipEntryAsInputStream(smallImagePath);
                    FileEntry fileEntry = TempFileEntryUtil.addTempFileEntry((long)serviceContext.getScopeGroupId(), (long)userId, (String)BlogsEntry.class.getName(), (String)smallImageFileName, (InputStream)inputStream, (String)MimeTypesUtil.getContentType((String)smallImageFileName));
                    smallImageFileEntryId = fileEntry.getFileEntryId();
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            }
        }
        if (smallImageFileEntryId == 0L) {
            List attachmentElements = portletDataContext.getReferenceDataElements((StagedModel)entry, DLFileEntry.class, "weak");
            for (Element attachmentElement : attachmentElements) {
                InputStream inputStream = this.getSmallImageInputStream(portletDataContext, attachmentElement);
                if (inputStream == null) continue;
                String path = attachmentElement.attributeValue("path");
                FileEntry fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
                FileEntry smallImageFileEntry = TempFileEntryUtil.addTempFileEntry((long)serviceContext.getScopeGroupId(), (long)userId, (String)BlogsEntry.class.getName(), (String)fileEntry.getTitle(), (InputStream)inputStream, (String)fileEntry.getMimeType());
                if (fileEntry == null) continue;
                smallImageFileEntryId = smallImageFileEntry.getFileEntryId();
            }
        }
        ImageSelector imageSelector = null;
        imageSelector = !entry.isSmallImage() ? new ImageSelector(0L) : new ImageSelector(smallImageFileEntryId, entry.getSmallImageURL());
        BlogsEntry importedEntry = null;
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setAttribute("urlTitle", (Serializable)((Object)entry.getUrlTitle()));
            BlogsEntry existingEntry = this.fetchStagedModelByUuidAndGroupId(entry.getUuid(), portletDataContext.getScopeGroupId());
            if (existingEntry == null) {
                serviceContext.setUuid(entry.getUuid());
                importedEntry = BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)entry.getTitle(), (String)entry.getSubtitle(), (String)entry.getDescription(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (ImageSelector)imageSelector, (ServiceContext)serviceContext);
            } else {
                importedEntry = BlogsEntryLocalServiceUtil.updateEntry((long)userId, (long)existingEntry.getEntryId(), (String)entry.getTitle(), (String)entry.getSubtitle(), (String)entry.getDescription(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (ImageSelector)imageSelector, (ServiceContext)serviceContext);
            }
        } else {
            importedEntry = BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)entry.getTitle(), (String)entry.getSubtitle(), (String)entry.getDescription(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (ImageSelector)imageSelector, (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)entry, (ClassedModel)importedEntry);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        long userId = portletDataContext.getUserId(entry.getUserUuid());
        BlogsEntry existingEntry = this.fetchStagedModelByUuidAndGroupId(entry.getUuid(), portletDataContext.getScopeGroupId());
        if (existingEntry == null || !existingEntry.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingEntry.getTrashHandler();
        if (trashHandler.isRestorable(existingEntry.getEntryId())) {
            trashHandler.restoreTrashEntry(userId, existingEntry.getEntryId());
        }
    }

    protected InputStream getSmallImageInputStream(PortletDataContext portletDataContext, Element attachmentElement) {
        InputStream inputStream = null;
        String path = attachmentElement.attributeValue("path");
        FileEntry fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
        String binPath = attachmentElement.attributeValue("bin-path");
        if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
            try {
                inputStream = FileEntryUtil.getContentStream(fileEntry);
            }
            catch (Exception e) {}
        } else {
            inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
        }
        if (inputStream == null && _log.isWarnEnabled()) {
            _log.warn((Object)("Unable to import small image file entry " + fileEntry.getFileEntryId()));
        }
        return inputStream;
    }
}

