/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.blogs.NoSuchEntryException;
import com.liferay.portlet.blogs.TrackbackValidationException;
import com.liferay.portlet.blogs.action.ActionUtil;
import com.liferay.portlet.blogs.action.TrackbackServiceContextFunction;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.trackback.Trackback;
import com.liferay.portlet.blogs.trackback.TrackbackImpl;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class TrackbackAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;
    private static Log _log = LogFactoryUtil.getLog(TrackbackAction.class);
    private Trackback _trackback;

    public TrackbackAction() {
        this._trackback = new TrackbackImpl();
    }

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.addTrackback(actionRequest, actionResponse);
        }
        catch (NoSuchEntryException nsee) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsee, (Throwable)nsee);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
    }

    protected TrackbackAction(Trackback trackback) {
        this._trackback = trackback;
    }

    protected void addTrackback(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            BlogsEntry entry = this.getBlogsEntry(actionRequest);
            this.validate(entry);
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            HttpServletRequest originalRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)request);
            String excerpt = ParamUtil.getString((HttpServletRequest)originalRequest, (String)"excerpt");
            String url = ParamUtil.getString((HttpServletRequest)originalRequest, (String)"url");
            String blogName = ParamUtil.getString((HttpServletRequest)originalRequest, (String)"blog_name");
            String title = ParamUtil.getString((HttpServletRequest)originalRequest, (String)"title");
            this.validate(actionRequest, request.getRemoteAddr(), url);
            this._trackback.addTrackback(entry, themeDisplay, excerpt, url, blogName, title, new TrackbackServiceContextFunction((PortletRequest)actionRequest));
        }
        catch (TrackbackValidationException tve) {
            this.sendError(actionRequest, actionResponse, tve.getMessage());
            return;
        }
        this.sendSuccess(actionRequest, actionResponse);
    }

    protected BlogsEntry getBlogsEntry(ActionRequest actionRequest) throws Exception {
        try {
            ActionUtil.getEntry((PortletRequest)actionRequest);
        }
        catch (PrincipalException pe) {
            throw new TrackbackValidationException("Blog entry must have guest view permissions to enable trackbacks");
        }
        return (BlogsEntry)actionRequest.getAttribute("BLOGS_ENTRY");
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected boolean isCommentsEnabled(ActionRequest actionRequest) throws Exception {
        PortletPreferences portletPreferences = this.getStrictPortletSetup((PortletRequest)actionRequest);
        if (portletPreferences == null) {
            portletPreferences = actionRequest.getPreferences();
        }
        return GetterUtil.getBoolean((String)portletPreferences.getValue("enableComments", null), (boolean)true);
    }

    protected void sendError(ActionRequest actionRequest, ActionResponse actionResponse, String msg) throws Exception {
        this.sendResponse(actionRequest, actionResponse, msg, false);
    }

    protected void sendResponse(ActionRequest actionRequest, ActionResponse actionResponse, String msg, boolean success) throws Exception {
        StringBundler sb = new StringBundler(7);
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        sb.append("<response>");
        if (success) {
            sb.append("<error>0</error>");
        } else {
            sb.append("<error>1</error>");
            sb.append("<message>");
            sb.append(msg);
            sb.append("</message>");
        }
        sb.append("</response>");
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])sb.toString().getBytes("UTF-8"), (String)"text/xml; charset=UTF-8");
    }

    protected void sendSuccess(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.sendResponse(actionRequest, actionResponse, null, true);
    }

    protected void validate(ActionRequest actionRequest, String remoteIP, String url) throws Exception {
        if (!this.isCommentsEnabled(actionRequest)) {
            throw new TrackbackValidationException("Comments are disabled");
        }
        if (Validator.isNull((String)url)) {
            throw new TrackbackValidationException("Trackback requires a valid permanent URL");
        }
        String trackbackIP = HttpUtil.getIpAddress((String)url);
        if (!remoteIP.equals(trackbackIP)) {
            throw new TrackbackValidationException("Remote IP does not match the trackback URL's IP");
        }
    }

    protected void validate(BlogsEntry entry) throws TrackbackValidationException {
        if (!entry.isAllowTrackbacks()) {
            throw new TrackbackValidationException("Trackbacks are not enabled");
        }
    }
}

