/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.ParameterMapSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.model.Layout;
import com.liferay.portal.util.PortalUtil;
import java.util.Map;

public class BlogsPortletInstanceSettings {
    public static final String[] ALL_KEYS = new String[]{"displayStyle", "displayStyleGroupId", "pageDelta", "rssDelta", "rssDisplayStyle", "rssFeedType", "socialBookmarksDisplayPosition", "socialBookmarksDisplayStyle", "socialBookmarksTypes", "enableCommentRatings", "enableComments", "enableFlags", "enableRatings", "enableRelatedAssets", "enableRss", "enableSocialBookmarks"};
    private static final String[] _MULTI_VALUED_KEYS = new String[0];
    private TypedSettings _typedSettings;

    public static BlogsPortletInstanceSettings getInstance(Layout layout, String portletId) throws PortalException {
        Settings settings = SettingsFactoryUtil.getPortletInstanceSettings((Layout)layout, (String)portletId);
        return new BlogsPortletInstanceSettings(settings);
    }

    public static BlogsPortletInstanceSettings getInstance(Layout layout, String portletId, Map<String, String[]> parameterMap) throws PortalException {
        Settings settings = SettingsFactoryUtil.getPortletInstanceSettings((Layout)layout, (String)portletId);
        return new BlogsPortletInstanceSettings((Settings)new ParameterMapSettings(parameterMap, settings));
    }

    public BlogsPortletInstanceSettings(Settings settings) {
        this._typedSettings = new TypedSettings(settings);
    }

    public String getDisplayStyle() {
        return this._typedSettings.getValue("displayStyle");
    }

    public long getDisplayStyleGroupId(long defaultDisplayStyleGroupId) {
        return this._typedSettings.getLongValue("displayStyleGroupId", defaultDisplayStyleGroupId);
    }

    public int getPageDelta() {
        return this._typedSettings.getIntegerValue("pageDelta");
    }

    public int getRssDelta() {
        return this._typedSettings.getIntegerValue("rssDelta");
    }

    public String getRssDisplayStyle() {
        return this._typedSettings.getValue("rssDisplayStyle");
    }

    public String getRssFeedType() {
        return this._typedSettings.getValue("rssFeedType");
    }

    public String getSocialBookmarksDisplayPosition() {
        return this._typedSettings.getValue("socialBookmarksDisplayPosition");
    }

    public String getSocialBookmarksDisplayStyle() {
        return this._typedSettings.getValue("socialBookmarksDisplayStyle");
    }

    public String getSocialBookmarksTypes() {
        return this._typedSettings.getValue("socialBookmarksTypes");
    }

    public boolean isEnableCommentRatings() {
        return this._typedSettings.getBooleanValue("enableCommentRatings");
    }

    public boolean isEnableComments() {
        return this._typedSettings.getBooleanValue("enableComments");
    }

    public boolean isEnableFlags() {
        return this._typedSettings.getBooleanValue("enableFlags");
    }

    public boolean isEnableRatings() {
        return this._typedSettings.getBooleanValue("enableRatings");
    }

    public boolean isEnableRelatedAssets() {
        return this._typedSettings.getBooleanValue("enableRelatedAssets");
    }

    public boolean isEnableRSS() {
        if (!PortalUtil.isRSSFeedsEnabled()) {
            return false;
        }
        return this._typedSettings.getBooleanValue("enableRss");
    }

    public boolean isEnableSocialBookmarks() {
        return this._typedSettings.getBooleanValue("enableSocialBookmarks");
    }

    private static FallbackKeys _getFallbackKeys() {
        FallbackKeys fallbackKeys = new FallbackKeys();
        fallbackKeys.add("enableComments", new String[]{"blogs.entry.comments.enabled"});
        fallbackKeys.add("enableCommentRatings", new String[]{"blogs.comment.ratings.enabled"});
        fallbackKeys.add("enableFlags", new String[]{"blogs.flags.enabled"});
        fallbackKeys.add("enableRatings", new String[]{"blogs.ratings.enabled"});
        fallbackKeys.add("enableRelatedAssets", new String[]{"blogs.related.assets.enabled"});
        fallbackKeys.add("enableRss", new String[]{"blogs.rss.enabled"});
        fallbackKeys.add("enableSocialBookmarks", new String[]{"blogs.social.bookmarks.enabled"});
        fallbackKeys.add("displayStyle", new String[]{"blogs.display.style"});
        fallbackKeys.add("pageDelta", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("rssDelta", new String[]{"search.container.page.default.delta"});
        fallbackKeys.add("rssDisplayStyle", new String[]{"rss.feed.display.style.default"});
        fallbackKeys.add("rssFeedType", new String[]{"rss.feed.type.default"});
        fallbackKeys.add("socialBookmarksDisplayPosition", new String[]{"blogs.social.bookmarks.display.position"});
        fallbackKeys.add("socialBookmarksDisplayStyle", new String[]{"blogs.social.bookmarks.display.style"});
        fallbackKeys.add("socialBookmarksTypes", new String[]{"social.bookmark.types"});
        return fallbackKeys;
    }

    static {
        SettingsFactory settingsFactory = SettingsFactoryUtil.getSettingsFactory();
        settingsFactory.registerSettingsMetadata("33", BlogsPortletInstanceSettings._getFallbackKeys(), _MULTI_VALUED_KEYS);
        settingsFactory.registerSettingsMetadata("161", BlogsPortletInstanceSettings._getFallbackKeys(), _MULTI_VALUED_KEYS);
    }
}

