/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assettagadmin.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.service.AssetTagServiceUtil;
import com.liferay.portlet.assettagadmin.action.ActionUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditTagAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateTag(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteTag(actionRequest);
            } else if (cmd.equals("merge")) {
                this.mergeTag(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            if (e instanceof NoSuchTagException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.asset_tag_admin.error");
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ActionUtil.getTag((PortletRequest)renderRequest);
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.asset_tag_admin.edit_tag"));
    }

    protected void deleteTag(ActionRequest actionRequest) throws PortalException {
        long[] deleteTagIds = null;
        long tagId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"tagId");
        deleteTagIds = tagId > 0L ? new long[]{tagId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteTagIds"), (long)0L);
        for (long deleteTagId : deleteTagIds) {
            AssetTagServiceUtil.deleteTag((long)deleteTagId);
        }
    }

    protected String[] getTagProperties(ActionRequest actionRequest) {
        int[] tagPropertiesIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"tagPropertiesIndexes"), (int)0);
        String[] tagProperties = new String[tagPropertiesIndexes.length];
        for (int i = 0; i < tagPropertiesIndexes.length; ++i) {
            int tagPropertiesIndex = tagPropertiesIndexes[i];
            String key = ParamUtil.getString((PortletRequest)actionRequest, (String)("key" + tagPropertiesIndex));
            if (Validator.isNull((String)key)) continue;
            String value = ParamUtil.getString((PortletRequest)actionRequest, (String)("value" + tagPropertiesIndex));
            tagProperties[i] = key + "_KEY_VALUE_" + value;
        }
        return tagProperties;
    }

    protected void mergeTag(ActionRequest actionRequest) throws Exception {
        long[] mergeTagIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"mergeTagIds"), (long)0L);
        long targetTagId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"targetTagId");
        boolean overrideTagsProperties = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"overrideTagsProperties");
        for (long mergeTagId : mergeTagIds) {
            if (targetTagId == mergeTagId) continue;
            AssetTagServiceUtil.mergeTags((long)mergeTagId, (long)targetTagId, (boolean)overrideTagsProperties);
        }
    }

    protected void updateTag(ActionRequest actionRequest) throws Exception {
        long tagId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"tagId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String[] tagProperties = this.getTagProperties(actionRequest);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)AssetTag.class.getName(), (PortletRequest)actionRequest);
        if (tagId <= 0L) {
            AssetTagServiceUtil.addTag((String)name, (String[])tagProperties, (ServiceContext)serviceContext);
        } else {
            AssetTagServiceUtil.updateTag((long)tagId, (String)name, (String[])tagProperties, (ServiceContext)serviceContext);
        }
    }
}

