/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.util;

import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.portlet.assetpublisher.util.AssetPublisherHelper;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class AssetPublisherHelperImpl
implements AssetPublisherHelper {
    @Override
    public String getAssetViewURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, AssetEntry assetEntry) {
        return this.getAssetViewURL(liferayPortletRequest, liferayPortletResponse, assetEntry, false);
    }

    @Override
    public String getAssetViewURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, AssetEntry assetEntry, boolean viewInContext) {
        PortletURL viewFullContentURL = liferayPortletResponse.createRenderURL();
        viewFullContentURL.setParameter("struts_action", "/asset_publisher/view_content");
        viewFullContentURL.setParameter("assetEntryId", String.valueOf(assetEntry.getEntryId()));
        AssetRendererFactory assetRendererFactory = assetEntry.getAssetRendererFactory();
        AssetRenderer assetRenderer = assetEntry.getAssetRenderer();
        viewFullContentURL.setParameter("type", assetRendererFactory.getType());
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (Validator.isNotNull((String)assetRenderer.getUrlTitle())) {
            if (assetRenderer.getGroupId() != themeDisplay.getScopeGroupId()) {
                viewFullContentURL.setParameter("groupId", String.valueOf(assetRenderer.getGroupId()));
            }
            viewFullContentURL.setParameter("urlTitle", assetRenderer.getUrlTitle());
        }
        String viewURL = null;
        String currentURL = null;
        if (viewInContext) {
            currentURL = PortalUtil.getCurrentURL((PortletRequest)liferayPortletRequest);
            String viewFullContentURLString = viewFullContentURL.toString();
            viewFullContentURLString = HttpUtil.setParameter((String)viewFullContentURLString, (String)"redirect", (String)currentURL);
            try {
                viewURL = assetRenderer.getURLViewInContext(liferayPortletRequest, liferayPortletResponse, viewFullContentURLString);
            }
            catch (Exception e) {}
        } else {
            PortletURL currentURLObj = PortletURLUtil.getCurrent((LiferayPortletRequest)liferayPortletRequest, (LiferayPortletResponse)liferayPortletResponse);
            currentURL = currentURLObj.toString();
        }
        if (Validator.isNull(viewURL)) {
            viewURL = viewFullContentURL.toString();
        }
        viewURL = AssetUtil.checkViewURL(assetEntry, viewInContext, viewURL, currentURL, themeDisplay);
        return viewURL;
    }
}

