/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.context;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.ClassType;
import com.liferay.portlet.asset.model.ClassTypeField;
import com.liferay.portlet.asset.model.ClassTypeReader;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMIndexerUtil;
import com.liferay.portlet.portletdisplaytemplate.util.PortletDisplayTemplateUtil;
import com.liferay.util.RSSUtil;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;

public class AssetPublisherDisplayContext {
    private Integer _abstractLength;
    private long[] _allAssetCategoryIds;
    private String[] _allAssetTagNames;
    private Boolean _anyAssetType;
    private String _assetLinkBehavior;
    private long[] _availableClassNameIds;
    private long[] _classNameIds;
    private long[] _classTypeIds;
    private String[] _compilerTagNames;
    private String _ddmStructureDisplayFieldValue;
    private String _ddmStructureFieldLabel;
    private String _ddmStructureFieldName;
    private String _ddmStructureFieldValue;
    private Integer _delta;
    private String _displayStyle;
    private Long _displayStyleGroupId;
    private Boolean _enableCommentRatings;
    private Boolean _enableComments;
    private Boolean _enableConversions;
    private Boolean _enableFlags;
    private Boolean _enablePermissions;
    private Boolean _enablePrint;
    private Boolean _enableRatings;
    private Boolean _enableRelatedAssets;
    private Boolean _enableRSS;
    private Boolean _enableSocialBookmarks;
    private Boolean _enableTagBasedNavigation;
    private Boolean _excludeZeroViewCount;
    private String[] _extensions;
    private long[] _groupIds;
    private Boolean _mergeLayoutTags;
    private Boolean _mergeURLTags;
    private String[] _metadataFields;
    private Boolean _openOfficeServerEnabled;
    private String _orderByColumn1;
    private String _orderByColumn2;
    private String _orderByType1;
    private String _orderByType2;
    private String _paginationType;
    private Long _portletDisplayDDMTemplateId;
    private PortletPreferences _portletPreferences;
    private String _portletResource;
    private HttpServletRequest _request;
    private String _rootPortletId;
    private Integer _rssDelta;
    private String _rssDisplayStyle;
    private String _rssFeedType;
    private String _rssName;
    private String _selectionStyle;
    private Boolean _showAddContentButton;
    private Boolean _showAssetTitle;
    private Boolean _showAvailableLocales;
    private Boolean _showContextLink;
    private Boolean _showExtraInfo;
    private Boolean _showMetadataDescriptions;
    private Boolean _showOnlyLayoutAssets;
    private String _socialBookmarksDisplayPosition;
    private String _socialBookmarksDisplayStyle;
    private Boolean _subtypeFieldsFilterEnabled;

    public AssetPublisherDisplayContext(HttpServletRequest request, PortletPreferences portletPreferences) {
        this._request = request;
        this._portletPreferences = portletPreferences;
    }

    public int getAbstractLength() {
        if (this._abstractLength == null) {
            this._abstractLength = GetterUtil.getInteger((String)this._portletPreferences.getValue("abstractLength", null), (int)200);
        }
        return this._abstractLength;
    }

    public long[] getAllAssetCategoryIds() throws Exception {
        if (this._allAssetCategoryIds != null) {
            return this._allAssetCategoryIds;
        }
        this._allAssetCategoryIds = new long[0];
        long assetCategoryId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"categoryId");
        String selectionStyle = this.getSelectionStyle();
        if (selectionStyle.equals("dynamic")) {
            this._allAssetCategoryIds = AssetPublisherUtil.getAssetCategoryIds((PortletPreferences)this._portletPreferences);
        }
        if (assetCategoryId > 0L && !ArrayUtil.contains((long[])this._allAssetCategoryIds, (long)assetCategoryId)) {
            this._allAssetCategoryIds = ArrayUtil.append((long[])this._allAssetCategoryIds, (long)assetCategoryId);
        }
        return this._allAssetCategoryIds;
    }

    public String[] getAllAssetTagNames() throws Exception {
        if (this._allAssetTagNames != null) {
            return this._allAssetTagNames;
        }
        this._allAssetTagNames = new String[0];
        String assetTagName = ParamUtil.getString((HttpServletRequest)this._request, (String)"tag");
        String selectionStyle = this.getSelectionStyle();
        if (selectionStyle.equals("dynamic")) {
            this._allAssetTagNames = AssetPublisherUtil.getAssetTagNames((PortletPreferences)this._portletPreferences);
        }
        if (Validator.isNotNull((String)assetTagName) && !ArrayUtil.contains((Object[])this._allAssetTagNames, (Object)assetTagName)) {
            this._allAssetTagNames = (String[])ArrayUtil.append((Object[])this._allAssetTagNames, (Object)assetTagName);
        }
        if (this.isMergeURLTags() || this.isMergeLayoutTags()) {
            this._allAssetTagNames = (String[])ArrayUtil.append((Object[])this._allAssetTagNames, (Object[])this.getCompilerTagNames());
        }
        this._allAssetTagNames = ArrayUtil.distinct((String[])this._allAssetTagNames, (Comparator)new StringComparator());
        return this._allAssetTagNames;
    }

    public AssetEntryQuery getAssetEntryQuery() throws Exception {
        AssetEntry layoutAssetEntry;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        AssetEntryQuery assetEntryQuery = AssetPublisherUtil.getAssetEntryQuery((PortletPreferences)this._portletPreferences, (long[])this.getGroupIds(), (long[])this.getAllAssetCategoryIds(), (String[])this.getAllAssetTagNames());
        String portletName = this.getPortletName();
        if (!portletName.equals("175")) {
            assetEntryQuery.setGroupIds(this.getGroupIds());
        }
        assetEntryQuery.setClassTypeIds(this.getClassTypeIds());
        assetEntryQuery.setEnablePermissions(this.isEnablePermissions().booleanValue());
        assetEntryQuery.setExcludeZeroViewCount(this.isExcludeZeroViewCount());
        this.configureSubtypeFieldFilter(assetEntryQuery, themeDisplay.getLocale());
        if (this.isShowOnlyLayoutAssets()) {
            assetEntryQuery.setLayout(themeDisplay.getLayout());
        }
        if (portletName.equals("175") && (layoutAssetEntry = (AssetEntry)this._request.getAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY")) != null) {
            assetEntryQuery.setLinkedAssetEntryId(layoutAssetEntry.getEntryId());
        }
        assetEntryQuery.setPaginationType(this.getPaginationType());
        assetEntryQuery.setOrderByCol1(this.getOrderByColumn1());
        assetEntryQuery.setOrderByCol2(this.getOrderByColumn2());
        assetEntryQuery.setOrderByType1(this.getOrderByType1());
        assetEntryQuery.setOrderByType2(this.getOrderByType2());
        AssetPublisherUtil.processAssetEntryQuery((User)themeDisplay.getUser(), (PortletPreferences)this._portletPreferences, (AssetEntryQuery)assetEntryQuery);
        return assetEntryQuery;
    }

    public String getAssetLinkBehavior() {
        if (this._assetLinkBehavior == null) {
            this._assetLinkBehavior = GetterUtil.getString((String)this._portletPreferences.getValue("assetLinkBehavior", "showFullContent"));
        }
        return this._assetLinkBehavior;
    }

    public long[] getAvailableClassNameIds() {
        if (this._availableClassNameIds == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._availableClassNameIds = AssetRendererFactoryRegistryUtil.getClassNameIds((long)themeDisplay.getCompanyId(), (boolean)true);
        }
        return this._availableClassNameIds;
    }

    public long[] getClassNameIds() {
        if (this._classNameIds == null) {
            this._classNameIds = AssetPublisherUtil.getClassNameIds((PortletPreferences)this._portletPreferences, (long[])this.getAvailableClassNameIds());
        }
        return this._classNameIds;
    }

    public long[] getClassTypeIds() {
        if (this._classTypeIds == null) {
            this._classTypeIds = GetterUtil.getLongValues((String[])this._portletPreferences.getValues("classTypeIds", null));
        }
        return this._classTypeIds;
    }

    public String[] getCompilerTagNames() {
        Set<String> layoutTagNames;
        if (this._compilerTagNames != null) {
            return this._compilerTagNames;
        }
        this._compilerTagNames = new String[0];
        if (this.isMergeURLTags()) {
            this._compilerTagNames = ParamUtil.getParameterValues((HttpServletRequest)this._request, (String)"tags");
        }
        if (this.isMergeLayoutTags() && !(layoutTagNames = AssetUtil.getLayoutTagNames(this._request)).isEmpty()) {
            this._compilerTagNames = (String[])ArrayUtil.append((Object[])this._compilerTagNames, (Object[])layoutTagNames.toArray(new String[layoutTagNames.size()]));
        }
        return this._compilerTagNames;
    }

    public String getDDMStructureDisplayFieldValue() throws Exception {
        if (this._ddmStructureDisplayFieldValue == null) {
            this.setDDMStructure();
        }
        return this._ddmStructureDisplayFieldValue;
    }

    public String getDDMStructureFieldLabel() throws Exception {
        if (this._ddmStructureFieldLabel == null) {
            this.setDDMStructure();
        }
        return this._ddmStructureFieldLabel;
    }

    public String getDDMStructureFieldName() throws Exception {
        if (this._ddmStructureFieldName == null) {
            this.setDDMStructure();
        }
        return this._ddmStructureFieldName;
    }

    public String getDDMStructureFieldValue() throws Exception {
        if (this._ddmStructureFieldValue == null) {
            this.setDDMStructure();
        }
        return this._ddmStructureFieldValue;
    }

    public Integer getDelta() {
        if (this._delta != null) {
            return this._delta;
        }
        this._delta = GetterUtil.getInteger((String)this._portletPreferences.getValue("delta", null), (int)SearchContainer.DEFAULT_DELTA);
        String portletName = this.getPortletName();
        if (portletName.equals("173")) {
            this._delta = PropsValues.RECENT_CONTENT_MAX_DISPLAY_ITEMS;
        }
        return this._delta;
    }

    public String getDisplayStyle() {
        if (this._displayStyle == null) {
            this._displayStyle = GetterUtil.getString((String)this._portletPreferences.getValue("displayStyle", PropsValues.ASSET_PUBLISHER_DISPLAY_STYLE_DEFAULT));
        }
        return this._displayStyle;
    }

    public long getDisplayStyleGroupId() {
        if (this._displayStyleGroupId == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._displayStyleGroupId = GetterUtil.getLong((String)this._portletPreferences.getValue("displayStyleGroupId", null), (long)themeDisplay.getScopeGroupId());
        }
        return this._displayStyleGroupId;
    }

    public String[] getExtensions() {
        if (this._extensions == null) {
            this._extensions = this._portletPreferences.getValues("extensions", new String[0]);
        }
        return this._extensions;
    }

    public String[] getExtensions(AssetRenderer assetRenderer) {
        final String[] supportedConversions = assetRenderer.getSupportedConversions();
        if (supportedConversions == null) {
            return this.getExtensions();
        }
        return (String[])ArrayUtil.filter((Object[])this.getExtensions(), (PredicateFilter)new PredicateFilter<String>(){

            public boolean filter(String extension) {
                return ArrayUtil.contains((Object[])supportedConversions, (Object)extension);
            }
        });
    }

    public long[] getGroupIds() {
        if (this._groupIds == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._groupIds = AssetPublisherUtil.getGroupIds((PortletPreferences)this._portletPreferences, (long)themeDisplay.getScopeGroupId(), (Layout)themeDisplay.getLayout());
        }
        return this._groupIds;
    }

    public String[] getMetadataFields() {
        if (this._metadataFields == null) {
            this._metadataFields = StringUtil.split((String)this._portletPreferences.getValue("metadataFields", ""));
        }
        return this._metadataFields;
    }

    public String getOrderByColumn1() {
        if (this._orderByColumn1 == null) {
            this._orderByColumn1 = GetterUtil.getString((String)this._portletPreferences.getValue("orderByColumn1", "modifiedDate"));
        }
        return this._orderByColumn1;
    }

    public String getOrderByColumn2() {
        if (this._orderByColumn2 == null) {
            this._orderByColumn2 = GetterUtil.getString((String)this._portletPreferences.getValue("orderByColumn2", "title"));
        }
        return this._orderByColumn2;
    }

    public String getOrderByType1() {
        if (this._orderByType1 == null) {
            this._orderByType1 = GetterUtil.getString((String)this._portletPreferences.getValue("orderByType1", "DESC"));
        }
        return this._orderByType1;
    }

    public String getOrderByType2() {
        if (this._orderByType2 == null) {
            this._orderByType2 = GetterUtil.getString((String)this._portletPreferences.getValue("orderByType2", "ASC"));
        }
        return this._orderByType2;
    }

    public String getPaginationType() {
        if (this._paginationType == null) {
            this._paginationType = GetterUtil.getString((String)this._portletPreferences.getValue("paginationType", "none"));
        }
        return this._paginationType;
    }

    public Long getPortletDisplayDDMTemplateId() {
        if (this._portletDisplayDDMTemplateId == null) {
            this._portletDisplayDDMTemplateId = PortletDisplayTemplateUtil.getPortletDisplayTemplateDDMTemplateId((long)this.getDisplayStyleGroupId(), (String)this.getDisplayStyle());
        }
        return this._portletDisplayDDMTemplateId;
    }

    public String getPortletResource() {
        if (this._portletResource == null) {
            this._portletResource = ParamUtil.getString((HttpServletRequest)this._request, (String)"portletResource");
        }
        return this._portletResource;
    }

    public String getRootPortletId() {
        if (this._rootPortletId == null) {
            this._rootPortletId = PortletConstants.getRootPortletId((String)this.getPortletResource());
        }
        return this._rootPortletId;
    }

    public int getRSSDelta() {
        if (this._rssDelta == null) {
            this._rssDelta = GetterUtil.getInteger((String)this._portletPreferences.getValue("rssDelta", ""), (int)SearchContainer.DEFAULT_DELTA);
        }
        return this._rssDelta;
    }

    public String getRSSDisplayStyle() {
        if (this._rssDisplayStyle == null) {
            this._rssDisplayStyle = this._portletPreferences.getValue("rssDisplayStyle", "abstract");
        }
        return this._rssDisplayStyle;
    }

    public String getRSSFeedType() {
        if (this._rssFeedType == null) {
            this._rssFeedType = this._portletPreferences.getValue("rssFeedType", RSSUtil.FEED_TYPE_DEFAULT);
        }
        return this._rssFeedType;
    }

    public String getRSSName() {
        if (this._rssName != null) {
            return this._rssName;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        this._rssName = this._portletPreferences.getValue("rssName", portletDisplay.getTitle());
        return this._rssName;
    }

    public String getSelectionStyle() {
        if (this._selectionStyle == null) {
            this._selectionStyle = GetterUtil.getString((String)this._portletPreferences.getValue("selectionStyle", null), (String)"dynamic");
        }
        return this._selectionStyle;
    }

    public String getSocialBookmarksDisplayPosition() {
        if (this._socialBookmarksDisplayPosition == null) {
            this._socialBookmarksDisplayPosition = this._portletPreferences.getValue("socialBookmarksDisplayPosition", "bottom");
        }
        return this._socialBookmarksDisplayPosition;
    }

    public String getSocialBookmarksDisplayStyle() {
        if (this._socialBookmarksDisplayStyle != null) {
            return this._socialBookmarksDisplayStyle;
        }
        this._socialBookmarksDisplayStyle = this._portletPreferences.getValue("socialBookmarksDisplayStyle", null);
        if (Validator.isNull((String)this._socialBookmarksDisplayStyle)) {
            String[] socialBookmarksDisplayStyles = PropsUtil.getArray((String)"social.bookmark.display.styles");
            this._socialBookmarksDisplayStyle = socialBookmarksDisplayStyles[0];
        }
        return this._socialBookmarksDisplayStyle;
    }

    public Boolean isAnyAssetType() {
        if (this._anyAssetType == null) {
            this._anyAssetType = GetterUtil.getBoolean((String)this._portletPreferences.getValue("anyAssetType", null), (boolean)true);
        }
        return this._anyAssetType;
    }

    public boolean isAssetLinkBehaviorShowFullContent() {
        String assetLinkBehavior = this.getAssetLinkBehavior();
        return assetLinkBehavior.equals("showFullContent");
    }

    public boolean isAssetLinkBehaviorViewInPortlet() {
        String assetLinkBehavior = this.getAssetLinkBehavior();
        return assetLinkBehavior.equals("viewInPortlet");
    }

    public boolean isEnableCommentRatings() {
        if (this._enableCommentRatings == null) {
            this._enableCommentRatings = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableCommentRatings", null));
        }
        return this._enableCommentRatings;
    }

    public boolean isEnableComments() {
        if (this._enableComments == null) {
            this._enableComments = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableComments", null));
        }
        return this._enableComments;
    }

    public Boolean isEnableConversions() throws Exception {
        if (this._enableConversions == null) {
            this._enableConversions = this.isOpenOfficeServerEnabled() && ArrayUtil.isNotEmpty((Object[])this.getExtensions());
        }
        return this._enableConversions;
    }

    public boolean isEnableFlags() {
        if (this._enableFlags == null) {
            this._enableFlags = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableFlags", null));
        }
        return this._enableFlags;
    }

    public Boolean isEnablePermissions() {
        if (this._enablePermissions != null) {
            return this._enablePermissions;
        }
        String portletName = this.getPortletName();
        if (!portletName.equals("194") && !portletName.equals("193") && PropsValues.ASSET_PUBLISHER_SEARCH_WITH_INDEX) {
            this._enablePermissions = true;
            return this._enablePermissions;
        }
        if (!PropsValues.ASSET_PUBLISHER_PERMISSION_CHECKING_CONFIGURABLE) {
            this._enablePermissions = true;
            return this._enablePermissions;
        }
        this._enablePermissions = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enablePermissions", null));
        return this._enablePermissions;
    }

    public boolean isEnablePrint() {
        if (this._enablePrint == null) {
            this._enablePrint = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enablePrint", null));
        }
        return this._enablePrint;
    }

    public boolean isEnableRatings() {
        if (this._enableRatings == null) {
            this._enableRatings = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableRatings", null));
        }
        return this._enableRatings;
    }

    public boolean isEnableRelatedAssets() {
        if (this._enableRelatedAssets == null) {
            this._enableRelatedAssets = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableRelatedAssets", null), (boolean)true);
        }
        return this._enableRelatedAssets;
    }

    public boolean isEnableRSS() {
        if (this._enableRSS == null) {
            this._enableRSS = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableRss", null));
        }
        return this._enableRSS;
    }

    public boolean isEnableSocialBookmarks() {
        if (this._enableSocialBookmarks == null) {
            this._enableSocialBookmarks = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableSocialBookmarks", null), (boolean)true);
        }
        return this._enableSocialBookmarks;
    }

    public boolean isEnableTagBasedNavigation() {
        if (this._enableTagBasedNavigation == null) {
            this._enableTagBasedNavigation = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableTagBasedNavigation", null));
        }
        return this._enableTagBasedNavigation;
    }

    public boolean isExcludeZeroViewCount() {
        if (this._excludeZeroViewCount == null) {
            this._excludeZeroViewCount = GetterUtil.getBoolean((String)this._portletPreferences.getValue("excludeZeroViewCount", null));
        }
        return this._excludeZeroViewCount;
    }

    public boolean isMergeLayoutTags() {
        if (this._mergeLayoutTags == null) {
            this._mergeLayoutTags = GetterUtil.getBoolean((String)this._portletPreferences.getValue("mergeLayoutTags", null), (boolean)false);
        }
        return this._mergeLayoutTags;
    }

    public boolean isMergeURLTags() {
        if (this._mergeURLTags == null) {
            this._mergeURLTags = GetterUtil.getBoolean((String)this._portletPreferences.getValue("mergeUrlTags", null), (boolean)true);
        }
        return this._mergeURLTags;
    }

    public boolean isOpenOfficeServerEnabled() {
        if (this._openOfficeServerEnabled == null) {
            this._openOfficeServerEnabled = PrefsPropsUtil.getBoolean((String)"openoffice.server.enabled", (boolean)PropsValues.OPENOFFICE_SERVER_ENABLED);
        }
        return this._openOfficeServerEnabled;
    }

    public boolean isOrderingAndGroupingEnabled() {
        String rootPortletId = this.getRootPortletId();
        return !rootPortletId.equals("194") && !rootPortletId.equals("193");
    }

    public boolean isOrderingByTitleEnabled() {
        String rootPortletId = this.getRootPortletId();
        return PropsValues.ASSET_PUBLISHER_SEARCH_WITH_INDEX && !rootPortletId.equals("175");
    }

    public boolean isPaginationTypeNone() {
        String paginationType = this.getPaginationType();
        return paginationType.equals("none");
    }

    public boolean isPaginationTypeRegular() {
        String paginationType = this.getPaginationType();
        return paginationType.equals("regular");
    }

    public boolean isPaginationTypeSimple() {
        String paginationType = this.getPaginationType();
        return paginationType.equals("simple");
    }

    public boolean isSelectionStyleDynamic() {
        String selectionStyle = this.getSelectionStyle();
        return selectionStyle.equals("dynamic");
    }

    public boolean isSelectionStyleEnabled() {
        String rootPortletId = this.getRootPortletId();
        return !rootPortletId.equals("194") && !rootPortletId.equals("193") && !rootPortletId.equals("175");
    }

    public boolean isSelectionStyleManual() {
        String selectionStyle = this.getSelectionStyle();
        return selectionStyle.equals("manual");
    }

    public boolean isShowAddContentButton() {
        if (this._showAddContentButton == null) {
            this._showAddContentButton = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showAddContentButton", null), (boolean)true);
        }
        return this._showAddContentButton;
    }

    public Boolean isShowAssetTitle() {
        if (this._showAssetTitle == null) {
            this._showAssetTitle = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showAssetTitle", null), (boolean)true);
        }
        return this._showAssetTitle;
    }

    public Boolean isShowAvailableLocales() {
        if (this._showAvailableLocales == null) {
            this._showAvailableLocales = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showAvailableLocales", null));
        }
        return this._showAvailableLocales;
    }

    public Boolean isShowContextLink() {
        if (this._showContextLink == null) {
            this._showContextLink = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showContextLink", null), (boolean)true);
        }
        return this._showContextLink;
    }

    public boolean isShowEnableAddContentButton() {
        String rootPortletId = this.getRootPortletId();
        return !rootPortletId.equals("194") && !rootPortletId.equals("193");
    }

    public Boolean isShowEnablePermissions() {
        if (PropsValues.ASSET_PUBLISHER_SEARCH_WITH_INDEX) {
            return false;
        }
        return PropsValues.ASSET_PUBLISHER_PERMISSION_CHECKING_CONFIGURABLE;
    }

    public boolean isShowEnableRelatedAssets() {
        String rootPortletId = this.getRootPortletId();
        return !rootPortletId.equals("175");
    }

    public boolean isShowExtraInfo() {
        if (this._showExtraInfo == null) {
            this._showExtraInfo = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showExtraInfo", null), (boolean)true);
        }
        return this._showExtraInfo;
    }

    public boolean isShowMetadataDescriptions() {
        if (this._showMetadataDescriptions == null) {
            this._showMetadataDescriptions = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showMetadataDescriptions", null), (boolean)true);
        }
        return this._showMetadataDescriptions;
    }

    public boolean isShowOnlyLayoutAssets() {
        if (this._showOnlyLayoutAssets == null) {
            this._showOnlyLayoutAssets = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showOnlyLayoutAssets", null));
        }
        return this._showOnlyLayoutAssets;
    }

    public boolean isShowScopeSelector() {
        String rootPortletId = this.getRootPortletId();
        return !rootPortletId.equals("175");
    }

    public boolean isShowSubtypeFieldsFilter() {
        String rootPortletId = this.getRootPortletId();
        return PropsValues.ASSET_PUBLISHER_SEARCH_WITH_INDEX && !rootPortletId.equals("175");
    }

    public boolean isSubtypeFieldsFilterEnabled() {
        if (this._subtypeFieldsFilterEnabled == null) {
            this._subtypeFieldsFilterEnabled = GetterUtil.getBoolean((String)this._portletPreferences.getValue("subtypeFieldsFilterEnabled", Boolean.FALSE.toString()));
        }
        return this._subtypeFieldsFilterEnabled;
    }

    public void setSelectionStyle(String selectionStyle) {
        this._selectionStyle = selectionStyle;
    }

    public void setShowContextLink(Boolean showContextLink) {
        this._showContextLink = showContextLink;
    }

    protected void configureSubtypeFieldFilter(AssetEntryQuery assetEntryQuery, Locale locale) throws Exception {
        long[] classNameIds = this.getClassNameIds();
        long[] classTypeIds = this.getClassTypeIds();
        if (!this.isSubtypeFieldsFilterEnabled() || classNameIds.length != 1 || classTypeIds.length != 1 || Validator.isNull((String)this.getDDMStructureFieldName()) || Validator.isNull((String)this.getDDMStructureFieldValue())) {
            return;
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)classNameIds[0]);
        ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
        ClassType classType = classTypeReader.getClassType(classTypeIds[0], locale);
        ClassTypeField classTypeField = classType.getClassTypeField(this.getDDMStructureFieldName());
        assetEntryQuery.setAttribute("ddmStructureFieldName", (Serializable)((Object)DDMIndexerUtil.encodeName((long)classTypeField.getClassTypeId(), (String)this.getDDMStructureFieldName(), (Locale)locale)));
        assetEntryQuery.setAttribute("ddmStructureFieldValue", (Serializable)((Object)this.getDDMStructureFieldValue()));
    }

    protected String getPortletName() {
        PortletConfig portletConfig = (PortletConfig)this._request.getAttribute("javax.portlet.config");
        if (portletConfig == null) {
            return "";
        }
        return portletConfig.getPortletName();
    }

    protected void setDDMStructure() throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._ddmStructureDisplayFieldValue = "";
        this._ddmStructureFieldLabel = "";
        this._ddmStructureFieldName = "";
        this._ddmStructureFieldValue = null;
        long[] classNameIds = this.getClassNameIds();
        long[] classTypeIds = this.getClassTypeIds();
        if (!this.isSubtypeFieldsFilterEnabled() || classNameIds.length != 1 || classTypeIds.length != 1) {
            return;
        }
        this._ddmStructureDisplayFieldValue = GetterUtil.getString((String)this._portletPreferences.getValue("ddmStructureDisplayFieldValue", ""));
        this._ddmStructureFieldName = GetterUtil.getString((String)this._portletPreferences.getValue("ddmStructureFieldName", ""));
        this._ddmStructureFieldValue = this._portletPreferences.getValue("ddmStructureFieldValue", "");
        if (Validator.isNotNull((String)this._ddmStructureFieldName) && Validator.isNotNull((String)this._ddmStructureFieldValue)) {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)classNameIds[0]);
            ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
            ClassType classType = classTypeReader.getClassType(classTypeIds[0], themeDisplay.getLocale());
            ClassTypeField classTypeField = classType.getClassTypeField(this._ddmStructureFieldName);
            this._ddmStructureFieldLabel = classTypeField.getLabel();
        }
    }
}

