/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.asset.DuplicateQueryRuleException;
import com.liferay.portlet.asset.model.AssetQueryRule;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.ClassTypeReader;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import com.liferay.util.ContentUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;

public class ConfigurationActionImpl
extends DefaultConfigurationAction {
    public void postProcess(long companyId, PortletRequest portletRequest, PortletPreferences portletPreferences) {
        String languageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        this.removeDefaultValue(portletRequest, portletPreferences, "emailAssetEntryAddedBody_" + languageId, ContentUtil.get((String)PropsValues.ASSET_PUBLISHER_EMAIL_ASSET_ENTRY_ADDED_BODY));
        this.removeDefaultValue(portletRequest, portletPreferences, "emailAssetEntryAddedSubject_" + languageId, ContentUtil.get((String)PropsValues.ASSET_PUBLISHER_EMAIL_ASSET_ENTRY_ADDED_SUBJECT));
    }

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = actionRequest.getPreferences();
        if (cmd.equals("translate")) {
            super.processAction(portletConfig, actionRequest, actionResponse);
        } else if (cmd.equals("update")) {
            try {
                this.validateEmail(actionRequest, "emailAssetEntryAdded");
                this.validateEmailFrom(actionRequest);
                this.updateDisplaySettings(actionRequest);
                String selectionStyle = this.getParameter((PortletRequest)actionRequest, "selectionStyle");
                if (selectionStyle.equals("dynamic")) {
                    this.updateQueryLogic(actionRequest, preferences);
                }
                this.updateDefaultAssetPublisher(actionRequest);
                super.processAction(portletConfig, actionRequest, actionResponse);
            }
            catch (Exception e) {
                if (e instanceof AssetTagException || e instanceof DuplicateQueryRuleException) {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                }
                throw e;
            }
        } else {
            String redirect;
            if (cmd.equals("add-scope")) {
                this.addScope(actionRequest, preferences);
            } else if (cmd.equals("add-selection")) {
                AssetPublisherUtil.addSelection((PortletRequest)actionRequest, (PortletPreferences)preferences, (String)portletResource);
            } else if (cmd.equals("move-selection-down")) {
                this.moveSelectionDown(actionRequest, preferences);
            } else if (cmd.equals("move-selection-up")) {
                this.moveSelectionUp(actionRequest, preferences);
            } else if (cmd.equals("remove-selection")) {
                this.removeSelection(actionRequest, preferences);
            } else if (cmd.equals("remove-scope")) {
                this.removeScope(actionRequest, preferences);
            } else if (cmd.equals("select-scope")) {
                this.setScopes(actionRequest, preferences);
            } else if (cmd.equals("selection-style")) {
                this.setSelectionStyle(actionRequest, preferences);
            }
            if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                preferences.store();
                SessionMessages.add((PortletRequest)actionRequest, (String)(PortalUtil.getPortletId((PortletRequest)actionRequest) + ".refreshPortlet"), (Object)portletResource);
                SessionMessages.add((PortletRequest)actionRequest, (String)(PortalUtil.getPortletId((PortletRequest)actionRequest) + ".updatedConfiguration"));
            }
            if (Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))))) {
                actionResponse.sendRedirect(redirect);
            }
        }
    }

    public void serveResource(PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String cmd = ParamUtil.getString((PortletRequest)resourceRequest, (String)"cmd");
        if (!cmd.equals("getFieldValue")) {
            return;
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)resourceRequest);
        long structureId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"structureId");
        Fields fields = (Fields)serviceContext.getAttribute(Fields.class.getName() + structureId);
        if (fields == null) {
            String fieldsNamespace = ParamUtil.getString((PortletRequest)resourceRequest, (String)"fieldsNamespace");
            fields = DDMUtil.getFields((long)structureId, (String)fieldsNamespace, (ServiceContext)serviceContext);
        }
        String fieldName = ParamUtil.getString((PortletRequest)resourceRequest, (String)"name");
        Field field = fields.get(fieldName);
        Serializable fieldValue = field.getValue(themeDisplay.getLocale(), 0);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (fieldValue == null) {
            jsonObject.put("success", false);
            this.writeJSON((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, jsonObject);
            return;
        }
        jsonObject.put("success", true);
        DDMStructure ddmStructure = field.getDDMStructure();
        String type = ddmStructure.getFieldType(fieldName);
        Serializable displayValue = DDMUtil.getDisplayFieldValue((ThemeDisplay)themeDisplay, (Serializable)fieldValue, (String)type);
        jsonObject.put("displayValue", String.valueOf(displayValue));
        if (fieldValue instanceof Boolean) {
            jsonObject.put("value", ((Boolean)fieldValue).booleanValue());
        } else if (fieldValue instanceof Date) {
            DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMMddHHmmss");
            jsonObject.put("value", dateFormat.format(fieldValue));
        } else if (fieldValue instanceof Double) {
            jsonObject.put("value", ((Double)fieldValue).doubleValue());
        } else if (fieldValue instanceof Float) {
            jsonObject.put("value", (double)((Float)fieldValue).floatValue());
        } else if (fieldValue instanceof Integer) {
            jsonObject.put("value", ((Integer)fieldValue).intValue());
        } else if (fieldValue instanceof Number) {
            jsonObject.put("value", String.valueOf(fieldValue));
        } else {
            jsonObject.put("value", (String)((Object)fieldValue));
        }
        this.writeJSON((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, jsonObject);
    }

    protected void addScope(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        Object[] scopeIds = preferences.getValues("scopeIds", new String[]{"Group_default"});
        String scopeId = ParamUtil.getString((PortletRequest)actionRequest, (String)"scopeId");
        this.checkPermission(actionRequest, scopeId);
        if (!ArrayUtil.contains((Object[])scopeIds, (Object)scopeId)) {
            scopeIds = (String[])ArrayUtil.append((Object[])scopeIds, (Object)scopeId);
        }
        preferences.setValues("scopeIds", (String[])scopeIds);
    }

    protected void checkPermission(ActionRequest actionRequest, String scopeId) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (!AssetPublisherUtil.isScopeIdSelectable((PermissionChecker)themeDisplay.getPermissionChecker(), (String)scopeId, (long)themeDisplay.getCompanyGroupId(), (Layout)layout)) {
            throw new PrincipalException();
        }
    }

    protected String getAssetClassName(ActionRequest actionRequest, String[] classNameIds) throws Exception {
        String anyAssetTypeString = this.getParameter((PortletRequest)actionRequest, "anyAssetType");
        boolean anyAssetType = GetterUtil.getBoolean((String)anyAssetTypeString);
        if (anyAssetType) {
            return null;
        }
        long defaultAssetTypeId = GetterUtil.getLong((String)anyAssetTypeString);
        if (defaultAssetTypeId == 0L && classNameIds.length == 1) {
            defaultAssetTypeId = GetterUtil.getLong((String)classNameIds[0]);
        }
        if (defaultAssetTypeId <= 0L) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String className = PortalUtil.getClassName((long)defaultAssetTypeId);
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
        List classTypes = classTypeReader.getAvailableClassTypes(PortalUtil.getCurrentAndAncestorSiteGroupIds((long)themeDisplay.getSiteGroupId()), themeDisplay.getLocale());
        if (classTypes.isEmpty()) {
            return null;
        }
        String assetClassName = AssetPublisherUtil.getClassName((AssetRendererFactory)assetRendererFactory);
        return assetClassName;
    }

    protected String[] getClassTypeIds(ActionRequest actionRequest, String[] classNameIds) throws Exception {
        String assetClassName = this.getAssetClassName(actionRequest, classNameIds);
        if (assetClassName == null) {
            return null;
        }
        String anyAssetClassTypeString = this.getParameter((PortletRequest)actionRequest, "anyClassType" + assetClassName);
        boolean anyAssetClassType = GetterUtil.getBoolean((String)anyAssetClassTypeString);
        if (anyAssetClassType) {
            return null;
        }
        long defaultAssetClassTypeId = GetterUtil.getLong((String)anyAssetClassTypeString);
        if (defaultAssetClassTypeId > 0L) {
            return new String[]{String.valueOf(defaultAssetClassTypeId)};
        }
        return StringUtil.split((String)this.getParameter((PortletRequest)actionRequest, "classTypeIds" + assetClassName));
    }

    protected AssetQueryRule getQueryRule(ActionRequest actionRequest, int index) {
        boolean contains = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("queryContains" + index));
        boolean andOperator = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("queryAndOperator" + index));
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)("queryName" + index));
        String[] values = null;
        values = name.equals("assetTags") ? StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("queryTagNames" + index))) : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("queryCategoryIds" + index)));
        return new AssetQueryRule(contains, andOperator, name, values);
    }

    protected boolean getSubtypesFieldsFilterEnabled(ActionRequest actionRequest, String[] classNameIds) throws Exception {
        String assetClassName = this.getAssetClassName(actionRequest, classNameIds);
        if (assetClassName == null) {
            return false;
        }
        return GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "subtypeFieldsFilterEnabled" + assetClassName));
    }

    protected void moveSelectionDown(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetEntryOrder");
        if (assetEntryOrder >= (manualEntries = preferences.getValues("assetEntryXml", new String[0])).length - 1 || assetEntryOrder < 0) {
            return;
        }
        String temp = manualEntries[assetEntryOrder + 1];
        manualEntries[assetEntryOrder + 1] = manualEntries[assetEntryOrder];
        manualEntries[assetEntryOrder] = temp;
        preferences.setValues("assetEntryXml", manualEntries);
    }

    protected void moveSelectionUp(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetEntryOrder");
        if (assetEntryOrder >= (manualEntries = preferences.getValues("assetEntryXml", new String[0])).length || assetEntryOrder <= 0) {
            return;
        }
        String temp = manualEntries[assetEntryOrder - 1];
        manualEntries[assetEntryOrder - 1] = manualEntries[assetEntryOrder];
        manualEntries[assetEntryOrder] = temp;
        preferences.setValues("assetEntryXml", manualEntries);
    }

    protected void removeScope(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] scopeIds = preferences.getValues("scopeIds", new String[]{"Group_default"});
        String scopeId = ParamUtil.getString((PortletRequest)actionRequest, (String)"scopeId");
        scopeIds = ArrayUtil.remove((String[])scopeIds, (String)scopeId);
        if (scopeId.startsWith("ParentGroup_")) {
            scopeId = scopeId.substring("Parent".length());
            scopeIds = ArrayUtil.remove((String[])scopeIds, (String)scopeId);
        }
        preferences.setValues("scopeIds", scopeIds);
    }

    protected void removeSelection(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetEntryOrder");
        if (assetEntryOrder >= (manualEntries = preferences.getValues("assetEntryXml", new String[0])).length) {
            return;
        }
        String[] newEntries = new String[manualEntries.length - 1];
        int j = 0;
        for (int i = 0; i < manualEntries.length; ++i) {
            if (i == assetEntryOrder) continue;
            newEntries[j++] = manualEntries[i];
        }
        preferences.setValues("assetEntryXml", newEntries);
    }

    protected void setScopes(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] scopeIds = StringUtil.split((String)this.getParameter((PortletRequest)actionRequest, "scopeIds"));
        preferences.setValues("scopeIds", scopeIds);
    }

    protected void setSelectionStyle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String selectionStyle = this.getParameter((PortletRequest)actionRequest, "selectionStyle");
        String displayStyle = this.getParameter((PortletRequest)actionRequest, "displayStyle");
        preferences.setValue("selectionStyle", selectionStyle);
        if (selectionStyle.equals("manual") || selectionStyle.equals("view-count")) {
            preferences.setValue("enableRss", String.valueOf(false));
            preferences.setValue("showQueryLogic", Boolean.FALSE.toString());
            preferences.reset("rssDelta");
            preferences.reset("rssDisplayStyle");
            preferences.reset("rssFormat");
            preferences.reset("rssName");
        }
        if (!selectionStyle.equals("view-count") && displayStyle.equals("view-count-details")) {
            preferences.setValue("displayStyle", "full-content");
        }
    }

    protected void updateDefaultAssetPublisher(ActionRequest actionRequest) throws Exception {
        boolean defaultAssetPublisher = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"defaultAssetPublisher");
        Layout layout = (Layout)actionRequest.getAttribute("LAYOUT");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        if (defaultAssetPublisher) {
            typeSettingsProperties.setProperty("default-asset-publisher-portlet-id", portletResource);
        } else {
            String defaultAssetPublisherPortletId = typeSettingsProperties.getProperty("default-asset-publisher-portlet-id");
            if (Validator.isNotNull((String)defaultAssetPublisherPortletId) && defaultAssetPublisherPortletId.equals(portletResource)) {
                typeSettingsProperties.setProperty("default-asset-publisher-portlet-id", "");
            }
        }
        layout = LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
        if (LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            LayoutSetBranch layoutSetBranch = LayoutStagingUtil.getLayoutSetBranch((LayoutSet)layout.getLayoutSet());
            long layoutSetBranchId = layoutSetBranch.getLayoutSetBranchId();
            long layoutRevisionId = StagingUtil.getRecentLayoutRevisionId((HttpServletRequest)request, (long)layoutSetBranchId, (long)layout.getPlid());
            LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.getLayoutRevision((long)layoutRevisionId);
            PortletPreferencesImpl portletPreferences = (PortletPreferencesImpl)actionRequest.getPreferences();
            if (layoutRevision != null) {
                portletPreferences.setPlid(layoutRevision.getLayoutRevisionId());
            }
        }
    }

    protected void updateDisplaySettings(ActionRequest actionRequest) throws Exception {
        String[] classNameIds = StringUtil.split((String)this.getParameter((PortletRequest)actionRequest, "classNameIds"));
        String[] classTypeIds = this.getClassTypeIds(actionRequest, classNameIds);
        String[] extensions = actionRequest.getParameterValues("extensions");
        boolean subtypeFieldsFilterEnabled = this.getSubtypesFieldsFilterEnabled(actionRequest, classNameIds);
        this.setPreference((PortletRequest)actionRequest, "classNameIds", classNameIds);
        this.setPreference((PortletRequest)actionRequest, "classTypeIds", classTypeIds);
        this.setPreference((PortletRequest)actionRequest, "extensions", extensions);
        this.setPreference((PortletRequest)actionRequest, "subtypeFieldsFilterEnabled", String.valueOf(subtypeFieldsFilterEnabled));
    }

    protected void updateQueryLogic(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long userId = themeDisplay.getUserId();
        long groupId = themeDisplay.getSiteGroupId();
        int[] queryRulesIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"queryLogicIndexes"), (int)0);
        int i = 0;
        ArrayList<AssetQueryRule> queryRules = new ArrayList<AssetQueryRule>();
        for (int queryRulesIndex : queryRulesIndexes) {
            AssetQueryRule queryRule = this.getQueryRule(actionRequest, queryRulesIndex);
            this.validateQueryRule(userId, groupId, queryRules, queryRule);
            queryRules.add(queryRule);
            this.setPreference((PortletRequest)actionRequest, "queryContains" + i, String.valueOf(queryRule.isContains()));
            this.setPreference((PortletRequest)actionRequest, "queryAndOperator" + i, String.valueOf(queryRule.isAndOperator()));
            this.setPreference((PortletRequest)actionRequest, "queryName" + i, queryRule.getName());
            this.setPreference((PortletRequest)actionRequest, "queryValues" + i, queryRule.getValues());
            ++i;
        }
        String[] values = preferences.getValues("queryValues" + i, new String[0]);
        while (values.length > 0) {
            this.setPreference((PortletRequest)actionRequest, "queryContains" + i, "");
            this.setPreference((PortletRequest)actionRequest, "queryAndOperator" + i, "");
            this.setPreference((PortletRequest)actionRequest, "queryName" + i, "");
            this.setPreference((PortletRequest)actionRequest, "queryValues" + i, new String[0]);
            values = preferences.getValues("queryValues" + ++i, new String[0]);
        }
    }

    protected void validateQueryRule(long userId, long groupId, List<AssetQueryRule> queryRules, AssetQueryRule queryRule) throws Exception {
        String name = queryRule.getName();
        if (name.equals("assetTags")) {
            AssetTagLocalServiceUtil.checkTags((long)userId, (long)groupId, (String[])queryRule.getValues());
        }
        if (queryRules.contains(queryRule)) {
            throw new DuplicateQueryRuleException(queryRule.isContains(), queryRule.isAndOperator(), queryRule.getName());
        }
    }
}

