/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetcategoryadmin.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.asset.DuplicateVocabularyException;
import com.liferay.portlet.asset.NoSuchVocabularyException;
import com.liferay.portlet.asset.VocabularyNameException;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetVocabularyServiceUtil;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import com.liferay.portlet.assetcategoryadmin.action.ActionUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditVocabularyAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateVocabulary(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteVocabulary(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchVocabularyException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.asset_category_admin.error");
            }
            if (e instanceof DuplicateVocabularyException || e instanceof VocabularyNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ActionUtil.getVocabulary((PortletRequest)renderRequest);
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.asset_category_admin.edit_vocabulary"));
    }

    protected void deleteVocabulary(ActionRequest actionRequest) throws PortalException {
        long[] deleteVocabularyIds = null;
        long vocabularyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"vocabularyId");
        deleteVocabularyIds = vocabularyId > 0L ? new long[]{vocabularyId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteVocabularyIds"), (long)0L);
        for (long deleteVocabularyId : deleteVocabularyIds) {
            AssetVocabularyServiceUtil.deleteVocabulary((long)deleteVocabularyId);
        }
    }

    protected String getSettings(ActionRequest actionRequest) {
        AssetVocabularySettingsHelper vocabularySettingsHelper = new AssetVocabularySettingsHelper();
        int[] indexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"indexes"), (int)0);
        long[] classNameIds = new long[indexes.length];
        long[] classTypePKs = new long[indexes.length];
        boolean[] requireds = new boolean[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            int index = indexes[i];
            classNameIds[i] = ParamUtil.getLong((PortletRequest)actionRequest, (String)("classNameId" + index));
            classTypePKs[i] = ParamUtil.getLong((PortletRequest)actionRequest, (String)("subtype" + classNameIds[i] + "-classNameId" + index), (long)-1L);
            requireds[i] = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("required" + index));
        }
        vocabularySettingsHelper.setClassNameIdsAndClassTypePKs(classNameIds, classTypePKs, requireds);
        boolean multiValued = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"multiValued");
        vocabularySettingsHelper.setMultiValued(multiValued);
        return vocabularySettingsHelper.toString();
    }

    protected void updateVocabulary(ActionRequest actionRequest) throws Exception {
        long vocabularyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"vocabularyId");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)AssetVocabulary.class.getName(), (PortletRequest)actionRequest);
        if (vocabularyId <= 0L) {
            AssetVocabularyServiceUtil.addVocabulary((String)"", (Map)titleMap, (Map)descriptionMap, (String)this.getSettings(actionRequest), (ServiceContext)serviceContext);
        } else {
            AssetVocabularyServiceUtil.updateVocabulary((long)vocabularyId, (String)"", (Map)titleMap, (Map)descriptionMap, (String)this.getSettings(actionRequest), (ServiceContext)serviceContext);
        }
    }
}

