/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetcategoryadmin.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.asset.AssetCategoryNameException;
import com.liferay.portlet.asset.DuplicateCategoryException;
import com.liferay.portlet.asset.NoSuchCategoryException;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.AssetCategoryServiceUtil;
import com.liferay.portlet.assetcategoryadmin.action.ActionUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditCategoryAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateCategory(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteCategory(actionRequest);
            } else if (cmd.equals("move")) {
                this.moveCategory(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchCategoryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.asset_category_admin.error");
            }
            if (e instanceof AssetCategoryNameException || e instanceof DuplicateCategoryException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ActionUtil.getCategory((PortletRequest)renderRequest);
        ActionUtil.getVocabularies((PortletRequest)renderRequest);
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.asset_category_admin.edit_category"));
    }

    protected void deleteCategory(ActionRequest actionRequest) throws PortalException {
        long[] deleteCategoryIds = null;
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"categoryId");
        deleteCategoryIds = categoryId > 0L ? new long[]{categoryId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteCategoryIds"), (long)0L);
        for (long deleteCategoryId : deleteCategoryIds) {
            AssetCategoryServiceUtil.deleteCategory((long)deleteCategoryId);
        }
    }

    protected String[] getCategoryProperties(ActionRequest actionRequest) {
        int[] categoryPropertiesIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"categoryPropertiesIndexes"), (int)0);
        String[] categoryProperties = new String[categoryPropertiesIndexes.length];
        for (int i = 0; i < categoryPropertiesIndexes.length; ++i) {
            int categoryPropertiesIndex = categoryPropertiesIndexes[i];
            String key = ParamUtil.getString((PortletRequest)actionRequest, (String)("key" + categoryPropertiesIndex));
            if (Validator.isNull((String)key)) continue;
            String value = ParamUtil.getString((PortletRequest)actionRequest, (String)("value" + categoryPropertiesIndex));
            categoryProperties[i] = key + "_KEY_VALUE_" + value;
        }
        return categoryProperties;
    }

    protected void moveCategory(ActionRequest actionRequest) throws Exception {
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"categoryId");
        long parentCategoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentCategoryId");
        long vocabularyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"vocabularyId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)AssetCategory.class.getName(), (PortletRequest)actionRequest);
        AssetCategoryServiceUtil.moveCategory((long)categoryId, (long)parentCategoryId, (long)vocabularyId, (ServiceContext)serviceContext);
    }

    protected void updateCategory(ActionRequest actionRequest) throws Exception {
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"categoryId");
        long parentCategoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentCategoryId");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        long vocabularyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"vocabularyId");
        String[] categoryProperties = this.getCategoryProperties(actionRequest);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)AssetCategory.class.getName(), (PortletRequest)actionRequest);
        if (categoryId <= 0L) {
            AssetCategoryServiceUtil.addCategory((long)parentCategoryId, (Map)titleMap, (Map)descriptionMap, (long)vocabularyId, (String[])categoryProperties, (ServiceContext)serviceContext);
        } else {
            AssetCategoryServiceUtil.updateCategory((long)categoryId, (long)parentCategoryId, (Map)titleMap, (Map)descriptionMap, (long)vocabularyId, (String[])categoryProperties, (ServiceContext)serviceContext);
        }
    }
}

