/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.util.AssetEntryValidator;
import java.util.List;

public class BaseAssetEntryValidator
implements AssetEntryValidator {
    @Override
    public void validate(long groupId, String className, long classTypePK, long[] categoryIds, String[] entryNames) throws PortalException {
        List vocabularies = AssetVocabularyLocalServiceUtil.getGroupVocabularies((long)groupId, (boolean)false);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (!group.isCompany()) {
            try {
                Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)group.getCompanyId());
                vocabularies = ListUtil.copy((List)vocabularies);
                vocabularies.addAll(AssetVocabularyLocalServiceUtil.getGroupVocabularies((long)companyGroup.getGroupId()));
            }
            catch (NoSuchGroupException nsge) {
                // empty catch block
            }
        }
        long classNameId = ClassNameLocalServiceUtil.getClassNameId((String)className);
        for (AssetVocabulary vocabulary : vocabularies) {
            this.validate(classNameId, classTypePK, categoryIds, vocabulary);
        }
    }

    protected boolean isAssetCategorizable(long classNameId) {
        String className = PortalUtil.getClassName((long)classNameId);
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        return assetRendererFactory != null && assetRendererFactory.isCategorizable();
    }

    protected void validate(long classNameId, long classTypePK, long[] categoryIds, AssetVocabulary vocabulary) throws PortalException {
        if (!vocabulary.isAssociatedToClassNameIdAndClassTypePK(classNameId, classTypePK)) {
            return;
        }
        if (!this.isAssetCategorizable(classNameId)) {
            return;
        }
        if (vocabulary.isMissingRequiredCategory(classNameId, classTypePK, categoryIds)) {
            throw new AssetCategoryException(vocabulary, 1);
        }
        if (!vocabulary.isMultiValued() && vocabulary.hasMoreThanOneCategorySelected(categoryIds)) {
            throw new AssetCategoryException(vocabulary, 2);
        }
    }
}

