/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

public class AssetVocabularyUtil {
    public static List<AssetVocabulary> getVocabularies(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<AssetVocabulary> vocabularies = new ArrayList<AssetVocabulary>(documents.size());
        for (Document document : documents) {
            long vocabularyId = GetterUtil.getLong((String)document.get("assetVocabularyId"));
            AssetVocabulary vocabulary = AssetVocabularyLocalServiceUtil.getVocabulary((long)vocabularyId);
            if (vocabulary == null) {
                vocabularies = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(AssetVocabulary.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (vocabularies == null) continue;
            vocabularies.add(vocabulary);
        }
        return vocabularies;
    }
}

