/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.service.permission.AssetVocabularyPermission;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;

public class AssetVocabularyIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{AssetVocabulary.class.getName()};
    public static final String PORTLET_ID = "147";
    private static Log _log = LogFactoryUtil.getLog(AssetVocabularyIndexer.class);

    public AssetVocabularyIndexer() {
        this.setCommitImmediately(true);
        this.setDefaultSelectedFieldNames(new String[]{"assetVocabularyId", "companyId", "groupId", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        AssetVocabulary vocabulary = AssetVocabularyLocalServiceUtil.getVocabulary((long)entryClassPK);
        return AssetVocabularyPermission.contains(permissionChecker, vocabulary, "VIEW");
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String title = (String)((Object)searchContext.getAttribute("title"));
        if (Validator.isNotNull((String)title)) {
            BooleanQuery localizedQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            this.addSearchLocalizedTerm(localizedQuery, searchContext, "title", true);
            searchQuery.add((Query)localizedQuery, BooleanClauseOccur.SHOULD);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        AssetVocabulary vocabulary = (AssetVocabulary)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, vocabulary.getVocabularyId());
        SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)vocabulary.getCompanyId(), (String)document.get("uid"), (boolean)this.isCommitImmediately());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        AssetVocabulary vocabulary = (AssetVocabulary)obj;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing vocabulary " + vocabulary));
        }
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)vocabulary);
        document.addKeyword("assetVocabularyId", vocabulary.getVocabularyId());
        document.addLocalizedText("description", vocabulary.getDescriptionMap());
        document.addText("name", vocabulary.getName());
        document.addLocalizedText("title", vocabulary.getTitleMap());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + vocabulary + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    protected void doReindex(Object obj) throws Exception {
        AssetVocabulary vocabulary = (AssetVocabulary)obj;
        Document document = this.getDocument(vocabulary);
        if (document != null) {
            SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)vocabulary.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        AssetVocabulary vocabulary = AssetVocabularyLocalServiceUtil.getVocabulary((long)classPK);
        this.doReindex(vocabulary);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexVocabularies(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexVocabularies(long companyId) throws PortalException {
        final ActionableDynamicQuery actionableDynamicQuery = AssetVocabularyLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                AssetVocabulary assetVocabulary = (AssetVocabulary)object;
                Document document = AssetVocabularyIndexer.this.getDocument(assetVocabulary);
                if (document != null) {
                    actionableDynamicQuery.addDocument(document);
                }
            }
        });
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }
}

