/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.comparator.ModelResourceComparator;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetCategoryProperty;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetTagProperty;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.model.ClassType;
import com.liferay.portlet.asset.model.ClassTypeReader;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetCategoryPropertyLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagPropertyLocalServiceUtil;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.portlet.asset.service.permission.AssetTagPermission;
import com.liferay.portlet.asset.service.permission.AssetVocabularyPermission;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.assetpublisher.util.AssetSearcher;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class AssetUtil {
    public static final String CLASSNAME_SEPARATOR = "_CLASSNAME_";
    public static final char[] INVALID_CHARACTERS = new char[]{'&', '\'', '@', '\\', ']', '}', ':', ',', '=', '>', '/', '<', '\n', '[', '{', '%', '|', '+', '#', '`', '?', '\"', '\r', ';', '/', '*', '~'};
    private static Log _log = LogFactoryUtil.getLog(AssetUtil.class);

    public static Set<String> addLayoutTags(HttpServletRequest request, List<AssetTag> tags) {
        Set<String> layoutTags = AssetUtil.getLayoutTagNames(request);
        for (AssetTag tag : tags) {
            layoutTags.add(tag.getName());
        }
        return layoutTags;
    }

    public static void addPortletBreadcrumbEntries(long assetCategoryId, HttpServletRequest request, PortletURL portletURL) throws Exception {
        AssetCategory assetCategory = AssetCategoryLocalServiceUtil.getCategory((long)assetCategoryId);
        List ancestorCategories = assetCategory.getAncestors();
        Collections.reverse(ancestorCategories);
        for (AssetCategory ancestorCategory : ancestorCategories) {
            portletURL.setParameter("categoryId", String.valueOf(ancestorCategory.getCategoryId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorCategory.getTitleCurrentValue(), (String)portletURL.toString());
        }
        portletURL.setParameter("categoryId", String.valueOf(assetCategoryId));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)assetCategory.getTitleCurrentValue(), (String)portletURL.toString());
    }

    public static String checkViewURL(AssetEntry assetEntry, boolean viewInContext, String viewURL, String currentURL, ThemeDisplay themeDisplay) {
        if (Validator.isNull((String)viewURL)) {
            return viewURL;
        }
        viewURL = HttpUtil.setParameter((String)viewURL, (String)"inheritRedirect", (boolean)viewInContext);
        Layout layout = themeDisplay.getLayout();
        String assetEntryLayoutUuid = assetEntry.getLayoutUuid();
        if (!viewInContext || Validator.isNotNull((String)assetEntryLayoutUuid) && !assetEntryLayoutUuid.equals(layout.getUuid())) {
            viewURL = HttpUtil.setParameter((String)viewURL, (String)"redirect", (String)currentURL);
        }
        return viewURL;
    }

    public static long[] filterCategoryIds(PermissionChecker permissionChecker, long[] categoryIds) throws PortalException {
        ArrayList<Long> viewableCategoryIds = new ArrayList<Long>();
        for (long categoryId : categoryIds) {
            AssetCategory category = AssetCategoryLocalServiceUtil.fetchCategory((long)categoryId);
            if (category == null || !AssetCategoryPermission.contains(permissionChecker, categoryId, "VIEW")) continue;
            viewableCategoryIds.add(categoryId);
        }
        return ArrayUtil.toArray((Long[])viewableCategoryIds.toArray(new Long[viewableCategoryIds.size()]));
    }

    public static long[] filterTagIds(PermissionChecker permissionChecker, long[] tagIds) throws PortalException {
        ArrayList<Long> viewableTagIds = new ArrayList<Long>();
        for (long tagId : tagIds) {
            if (!AssetTagPermission.contains(permissionChecker, tagId, "VIEW")) continue;
            viewableTagIds.add(tagId);
        }
        return ArrayUtil.toArray((Long[])viewableTagIds.toArray(new Long[viewableTagIds.size()]));
    }

    public static long[][] filterTagIdsArray(PermissionChecker permissionChecker, long[][] tagIdsArray) throws PortalException {
        ArrayList<long[]> viewableTagIdsArray = new ArrayList<long[]>();
        for (int i = 0; i < tagIdsArray.length; ++i) {
            long[] tagIds = tagIdsArray[i];
            ArrayList<Long> viewableTagIds = new ArrayList<Long>();
            for (long tagId : tagIds) {
                if (!AssetTagPermission.contains(permissionChecker, tagId, "VIEW")) continue;
                viewableTagIds.add(tagId);
            }
            viewableTagIdsArray.add(ArrayUtil.toArray((Long[])viewableTagIds.toArray(new Long[viewableTagIds.size()])));
        }
        return (long[][])viewableTagIdsArray.toArray((T[])new long[viewableTagIdsArray.size()][]);
    }

    public static List<AssetVocabulary> filterVocabularies(List<AssetVocabulary> vocabularies, String className, final long classTypePK) {
        final long classNameId = PortalUtil.getClassNameId((String)className);
        PredicateFilter<AssetVocabulary> predicateFilter = new PredicateFilter<AssetVocabulary>(){

            public boolean filter(AssetVocabulary assetVocabulary) {
                return assetVocabulary.isAssociatedToClassNameIdAndClassTypePK(classNameId, classTypePK);
            }
        };
        return ListUtil.filter(vocabularies, (PredicateFilter)predicateFilter);
    }

    public static long[] filterVocabularyIds(PermissionChecker permissionChecker, long[] vocabularyIds) throws PortalException {
        ArrayList<Long> viewableVocabularyIds = new ArrayList<Long>();
        for (long vocabularyId : vocabularyIds) {
            if (!AssetVocabularyPermission.contains(permissionChecker, vocabularyId, "VIEW")) continue;
            viewableVocabularyIds.add(vocabularyId);
        }
        return ArrayUtil.toArray((Long[])viewableVocabularyIds.toArray(new Long[viewableVocabularyIds.size()]));
    }

    public static PortletURL getAddPortletURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long groupId, String className, long classTypeId, long[] allAssetCategoryIds, String[] allAssetTagNames, String redirect) throws Exception {
        String referringPortletResource;
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null || !assetRendererFactory.hasAddPermission(themeDisplay.getPermissionChecker(), groupId, classTypeId)) {
            return null;
        }
        PortletURL addPortletURL = assetRendererFactory.getURLAdd(liferayPortletRequest, liferayPortletResponse);
        if (addPortletURL == null) {
            return null;
        }
        if (redirect != null) {
            addPortletURL.setParameter("redirect", redirect);
        }
        if (Validator.isNotNull((String)(referringPortletResource = ParamUtil.getString((PortletRequest)liferayPortletRequest, (String)"portletResource")))) {
            addPortletURL.setParameter("referringPortletResource", referringPortletResource);
        } else {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            addPortletURL.setParameter("referringPortletResource", portletDisplay.getId());
            if (allAssetCategoryIds != null) {
                HashMap<Long, String> assetVocabularyAssetCategoryIds = new HashMap<Long, String>();
                for (long assetCategoryId : allAssetCategoryIds) {
                    AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)assetCategoryId);
                    if (assetCategory == null) continue;
                    long assetVocabularyId = assetCategory.getVocabularyId();
                    if (assetVocabularyAssetCategoryIds.containsKey(assetVocabularyId)) {
                        String assetCategoryIds = (String)assetVocabularyAssetCategoryIds.get(assetVocabularyId);
                        assetVocabularyAssetCategoryIds.put(assetVocabularyId, assetCategoryIds + "," + assetCategoryId);
                        continue;
                    }
                    assetVocabularyAssetCategoryIds.put(assetVocabularyId, String.valueOf(assetCategoryId));
                }
                for (Map.Entry entry : assetVocabularyAssetCategoryIds.entrySet()) {
                    long assetVocabularyId = (Long)entry.getKey();
                    String assetCategoryIds = (String)entry.getValue();
                    addPortletURL.setParameter("assetCategoryIds_" + assetVocabularyId, assetCategoryIds);
                }
            }
            if (allAssetTagNames != null) {
                addPortletURL.setParameter("assetTagNames", StringUtil.merge((Object[])allAssetTagNames));
            }
        }
        if (classTypeId > 0L) {
            addPortletURL.setParameter("classTypeId", String.valueOf(classTypeId));
            if (className.equals(DLFileEntry.class.getName())) {
                addPortletURL.setParameter("cmd", "add");
                addPortletURL.setParameter("folderId", String.valueOf(0L));
                addPortletURL.setParameter("fileEntryTypeId", String.valueOf(classTypeId));
            }
            if (className.equals(JournalArticle.class.getName())) {
                DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)classTypeId);
                addPortletURL.setParameter("structureId", ddmStructure.getStructureKey());
            }
        }
        addPortletURL.setPortletMode(PortletMode.VIEW);
        addPortletURL.setWindowState(LiferayWindowState.POP_UP);
        return addPortletURL;
    }

    @Deprecated
    public static PortletURL getAddPortletURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String className, long classTypeId, long[] allAssetCategoryIds, String[] allAssetTagNames, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return AssetUtil.getAddPortletURL(liferayPortletRequest, liferayPortletResponse, themeDisplay.getScopeGroupId(), className, classTypeId, allAssetCategoryIds, allAssetTagNames, redirect);
    }

    public static Map<String, PortletURL> getAddPortletURLs(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long groupId, long[] classNameIds, long[] classTypeIds, long[] allAssetCategoryIds, String[] allAssetTagNames, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        TreeMap<String, PortletURL> addPortletURLs = new TreeMap<String, PortletURL>((Comparator<String>)new ModelResourceComparator(themeDisplay.getLocale()));
        if (Validator.isNull((String)redirect)) {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            LiferayPortletURL redirectURL = liferayPortletResponse.createLiferayPortletURL(themeDisplay.getPlid(), portletDisplay.getId(), "RENDER_PHASE", false);
            redirectURL.setParameter("struts_action", "/asset_publisher/add_asset_redirect");
            redirectURL.setParameter("redirect", themeDisplay.getURLCurrent());
            redirectURL.setWindowState(LiferayWindowState.POP_UP);
            redirect = redirectURL.toString();
        }
        for (long classNameId : classNameIds) {
            PortletURL addPortletURL;
            String className = PortalUtil.getClassName((long)classNameId);
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)assetRendererFactory.getPortletId());
            if (!portlet.isActive()) continue;
            ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
            List classTypes = classTypeReader.getAvailableClassTypes(PortalUtil.getCurrentAndAncestorSiteGroupIds((long)themeDisplay.getScopeGroupId()), themeDisplay.getLocale());
            if ((classTypeIds.length == 0 || classTypes.isEmpty()) && (addPortletURL = AssetUtil.getAddPortletURL(liferayPortletRequest, liferayPortletResponse, groupId, className, 0L, allAssetCategoryIds, allAssetTagNames, redirect)) != null) {
                addPortletURLs.put(className, addPortletURL);
            }
            for (ClassType classType : classTypes) {
                PortletURL addPortletURL2;
                long classTypeId = classType.getClassTypeId();
                if (!ArrayUtil.contains((long[])classTypeIds, (long)classTypeId) && classTypeIds.length != 0 || (addPortletURL2 = AssetUtil.getAddPortletURL(liferayPortletRequest, liferayPortletResponse, groupId, className, classTypeId, allAssetCategoryIds, allAssetTagNames, redirect)) == null) continue;
                String mesage = className + CLASSNAME_SEPARATOR + classType.getName();
                addPortletURLs.put(mesage, addPortletURL2);
            }
        }
        return addPortletURLs;
    }

    @Deprecated
    public static Map<String, PortletURL> getAddPortletURLs(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long[] classNameIds, long[] classTypeIds, long[] allAssetCategoryIds, String[] allAssetTagNames, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return AssetUtil.getAddPortletURLs(liferayPortletRequest, liferayPortletResponse, themeDisplay.getScopeGroupId(), classNameIds, classTypeIds, allAssetCategoryIds, allAssetTagNames, redirect);
    }

    public static List<AssetEntry> getAssetEntries(Hits hits) {
        ArrayList<AssetEntry> assetEntries = new ArrayList<AssetEntry>();
        for (Document document : hits.getDocs()) {
            String className = GetterUtil.getString((String)document.get("entryClassName"));
            long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((String)className, (long)classPK);
                assetEntries.add(assetEntry);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return assetEntries;
    }

    public static String getAssetKeywords(String className, long classPK) {
        List tags = AssetTagLocalServiceUtil.getTags((String)className, (long)classPK);
        List categories = AssetCategoryLocalServiceUtil.getCategories((String)className, (long)classPK);
        StringBuffer sb = new StringBuffer();
        sb.append(ListUtil.toString((List)tags, (Accessor)AssetTag.NAME_ACCESSOR));
        if (!tags.isEmpty()) {
            sb.append(",");
        }
        sb.append(ListUtil.toString((List)categories, (Accessor)AssetCategory.NAME_ACCESSOR));
        return sb.toString();
    }

    public static Set<String> getLayoutTagNames(HttpServletRequest request) {
        HashSet tagNames = (HashSet)request.getAttribute("ASSET_LAYOUT_TAG_NAMES");
        if (tagNames == null) {
            tagNames = new HashSet();
            request.setAttribute("ASSET_LAYOUT_TAG_NAMES", tagNames);
        }
        return tagNames;
    }

    public static boolean hasSubtype(String subtypeClassName, Map<String, PortletURL> addPortletURLs) {
        for (Map.Entry<String, PortletURL> entry : addPortletURLs.entrySet()) {
            String className = entry.getKey();
            if (!className.startsWith(subtypeClassName) || className.equals(subtypeClassName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefaultAssetPublisher(Layout layout, String portletId, String portletResource) {
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        String defaultAssetPublisherPortletId = typeSettingsProperties.getProperty("default-asset-publisher-portlet-id", "");
        if (Validator.isNull((String)defaultAssetPublisherPortletId)) {
            return false;
        }
        return defaultAssetPublisherPortletId.equals(portletId) || defaultAssetPublisherPortletId.equals(portletResource);
    }

    public static boolean isValidWord(String word) {
        char[] wordCharArray;
        if (Validator.isNull((String)word)) {
            return false;
        }
        for (char c : wordCharArray = word.toCharArray()) {
            for (char invalidChar : INVALID_CHARACTERS) {
                if (c != invalidChar) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Word " + word + " is not valid because " + c + " is not allowed"));
                }
                return false;
            }
        }
        return true;
    }

    public static Hits search(HttpServletRequest request, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)request);
        return AssetUtil.search(searchContext, assetEntryQuery, start, end);
    }

    public static Hits search(SearchContext searchContext, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        AssetSearcher assetSearcher = AssetUtil.getAssetSearcher(searchContext, assetEntryQuery, start, end);
        return assetSearcher.search(searchContext);
    }

    public static BaseModelSearchResult<AssetEntry> searchAssetEntries(HttpServletRequest request, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)request);
        return AssetUtil.searchAssetEntries(searchContext, assetEntryQuery, start, end);
    }

    public static BaseModelSearchResult<AssetEntry> searchAssetEntries(SearchContext searchContext, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        AssetSearcher assetSearcher = AssetUtil.getAssetSearcher(searchContext, assetEntryQuery, start, end);
        Hits hits = assetSearcher.search(searchContext);
        List<AssetEntry> assetEntries = AssetUtil.getAssetEntries(hits);
        return new BaseModelSearchResult(assetEntries, hits.getLength());
    }

    public static String substituteCategoryPropertyVariables(long groupId, long categoryId, String s) {
        String result = s;
        AssetCategory category = null;
        if (categoryId > 0L) {
            category = AssetCategoryLocalServiceUtil.fetchCategory((long)categoryId);
        }
        if (category != null) {
            List categoryProperties = AssetCategoryPropertyLocalServiceUtil.getCategoryProperties((long)categoryId);
            for (AssetCategoryProperty categoryProperty : categoryProperties) {
                result = StringUtil.replace((String)result, (String)("[$" + categoryProperty.getKey() + "$]"), (String)categoryProperty.getValue());
            }
        }
        return StringUtil.stripBetween((String)result, (String)"[$", (String)"$]");
    }

    public static String substituteTagPropertyVariables(long groupId, String tagName, String s) throws PortalException {
        String result = s;
        AssetTag tag = null;
        if (tagName != null) {
            try {
                tag = AssetTagLocalServiceUtil.getTag((long)groupId, (String)tagName);
            }
            catch (NoSuchTagException nste) {
                // empty catch block
            }
        }
        if (tag != null) {
            List tagProperties = AssetTagPropertyLocalServiceUtil.getTagProperties((long)tag.getTagId());
            for (AssetTagProperty tagProperty : tagProperties) {
                result = StringUtil.replace((String)result, (String)("[$" + tagProperty.getKey() + "$]"), (String)tagProperty.getValue());
            }
        }
        return StringUtil.stripBetween((String)result, (String)"[$", (String)"$]");
    }

    public static String toWord(String text) {
        if (Validator.isNull((String)text)) {
            return text;
        }
        char[] textCharArray = text.toCharArray();
        block0: for (int i = 0; i < textCharArray.length; ++i) {
            char c = textCharArray[i];
            for (char invalidChar : INVALID_CHARACTERS) {
                if (c != invalidChar) continue;
                textCharArray[i] = 32;
                continue block0;
            }
        }
        return new String(textCharArray);
    }

    protected static AssetSearcher getAssetSearcher(SearchContext searchContext, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        String paginationType;
        Indexer searcher = AssetSearcher.getInstance();
        AssetSearcher assetSearcher = (AssetSearcher)searcher;
        assetSearcher.setAssetEntryQuery(assetEntryQuery);
        Layout layout = assetEntryQuery.getLayout();
        if (layout != null) {
            searchContext.setAttribute("layoutUuid", (Serializable)((Object)layout.getUuid()));
        }
        String ddmStructureFieldName = (String)((Object)assetEntryQuery.getAttribute("ddmStructureFieldName"));
        Serializable ddmStructureFieldValue = assetEntryQuery.getAttribute("ddmStructureFieldValue");
        if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
            searchContext.setAttribute("ddmStructureFieldName", (Serializable)((Object)ddmStructureFieldName));
            searchContext.setAttribute("ddmStructureFieldValue", ddmStructureFieldValue);
        }
        if (!(paginationType = GetterUtil.getString((String)assetEntryQuery.getPaginationType(), (String)"more")).equals("none") && !paginationType.equals("simple")) {
            searchContext.setAttribute("paginationType", (Serializable)((Object)paginationType));
        }
        searchContext.setClassTypeIds(assetEntryQuery.getClassTypeIds());
        searchContext.setEnd(end);
        searchContext.setGroupIds(assetEntryQuery.getGroupIds());
        if (Validator.isNotNull((String)assetEntryQuery.getKeywords())) {
            searchContext.setLike(true);
        }
        searchContext.setSorts(AssetUtil.getSorts(assetEntryQuery, searchContext.getLocale()));
        searchContext.setStart(start);
        return assetSearcher;
    }

    protected static Sort getSort(String orderByType, String sortField, Locale locale) throws Exception {
        if (Validator.isNull((String)orderByType)) {
            orderByType = "asc";
        }
        int sortType = AssetUtil.getSortType(sortField);
        if (sortField.startsWith("ddm/")) {
            String[] sortFields = sortField.split("/");
            long ddmStructureId = GetterUtil.getLong((String)sortFields[1]);
            String fieldName = sortFields[2];
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
            String fieldType = ddmStructure.getFieldType(fieldName);
            sortType = AssetUtil.getSortType(fieldType);
            sortField = sortField.concat("_").concat(LocaleUtil.toLanguageId((Locale)locale));
        } else if (sortField.equals("modifiedDate")) {
            sortField = "modified";
        } else if (sortField.equals("title")) {
            sortField = DocumentImpl.getSortableFieldName((String)"localized_title_".concat(LocaleUtil.toLanguageId((Locale)locale)));
        }
        return SortFactoryUtil.getSort(AssetEntry.class, (int)sortType, (String)sortField, (String)orderByType);
    }

    protected static Sort[] getSorts(AssetEntryQuery assetEntryQuery, Locale locale) throws Exception {
        Sort sort1 = AssetUtil.getSort(assetEntryQuery.getOrderByType1(), assetEntryQuery.getOrderByCol1(), locale);
        Sort sort2 = AssetUtil.getSort(assetEntryQuery.getOrderByType2(), assetEntryQuery.getOrderByCol2(), locale);
        return new Sort[]{sort1, sort2};
    }

    protected static int getSortType(String sortField) {
        int sortType = 3;
        if (sortField.equals("createDate") || sortField.equals("expirationDate") || sortField.equals("publishDate") || sortField.equals("ddm-date") || sortField.equals("modifiedDate")) {
            sortType = 6;
        } else if (sortField.equals("priority") || sortField.equals("ratings") || sortField.equals("ddm-decimal") || sortField.equals("ddm-number")) {
            sortType = 7;
        } else if (sortField.equals("viewCount") || sortField.equals("ddm-integer")) {
            sortType = 4;
        }
        return sortType;
    }
}

