/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class AssetCategoryUtil {
    public static void addPortletBreadcrumbEntry(AssetVocabulary vocabulary, AssetCategory category, HttpServletRequest request, RenderResponse renderResponse) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/asset_category_admin/view");
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)LanguageUtil.get((HttpServletRequest)request, (String)"vocabularies"), (String)portletURL.toString());
        if (category == null) {
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)vocabulary.getTitle(themeDisplay.getLocale()), null);
            return;
        }
        portletURL.setParameter("struts_action", "/asset_category_admin/view_categories");
        portletURL.setParameter("vocabularyId", String.valueOf(vocabulary.getVocabularyId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)vocabulary.getTitle(themeDisplay.getLocale()), (String)portletURL.toString());
        List ancestorsCategories = category.getAncestors();
        Collections.reverse(ancestorsCategories);
        for (AssetCategory curCategory : ancestorsCategories) {
            portletURL.setParameter("categoryId", String.valueOf(curCategory.getCategoryId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)curCategory.getTitle(themeDisplay.getLocale()), (String)portletURL.toString());
        }
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)category.getTitle(themeDisplay.getLocale()), null);
    }

    public static List<AssetCategory> getCategories(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<AssetCategory> categories = new ArrayList<AssetCategory>(documents.size());
        for (Document document : documents) {
            long categoryId = GetterUtil.getLong((String)document.get("assetCategoryId"));
            AssetCategory category = AssetCategoryLocalServiceUtil.getCategory((long)categoryId);
            if (category == null) {
                categories = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(AssetCategory.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (categories == null) continue;
            categories.add(category);
        }
        return categories;
    }
}

