/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;

public class AssetCategoryIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{AssetCategory.class.getName()};
    public static final String PORTLET_ID = "147";
    private static Log _log = LogFactoryUtil.getLog(AssetCategoryIndexer.class);

    public AssetCategoryIndexer() {
        this.setCommitImmediately(true);
        this.setDefaultSelectedFieldNames(new String[]{"assetCategoryId", "companyId", "groupId", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        AssetCategory category = AssetCategoryLocalServiceUtil.getCategory((long)entryClassPK);
        return AssetCategoryPermission.contains(permissionChecker, category, "VIEW");
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] vocabularyIds;
        long[] parentCategoryIds = (long[])searchContext.getAttribute("parentCategoryIds");
        if (!ArrayUtil.isEmpty((long[])parentCategoryIds)) {
            BooleanQuery parentCategoryQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            for (long parentCategoryId : parentCategoryIds) {
                parentCategoryQuery.addTerm("parentCategoryId", String.valueOf(parentCategoryId));
            }
            contextQuery.add((Query)parentCategoryQuery, BooleanClauseOccur.MUST);
        }
        if (!ArrayUtil.isEmpty((long[])(vocabularyIds = (long[])searchContext.getAttribute("assetVocabularyIds")))) {
            BooleanQuery vocabularyQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            for (long vocabularyId : vocabularyIds) {
                vocabularyQuery.addTerm("assetVocabularyId", String.valueOf(vocabularyId));
            }
            contextQuery.add((Query)vocabularyQuery, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String title = (String)((Object)searchContext.getAttribute("title"));
        if (Validator.isNotNull((String)title)) {
            BooleanQuery localizedQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            searchContext.setAttribute("assetCategoryTitle", (Serializable)((Object)title));
            this.addSearchLocalizedTerm(localizedQuery, searchContext, "assetCategoryTitle", true);
            this.addSearchLocalizedTerm(localizedQuery, searchContext, "title", true);
            searchQuery.add((Query)localizedQuery, BooleanClauseOccur.SHOULD);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        AssetCategory assetCategory = (AssetCategory)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, assetCategory.getCategoryId());
        SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)assetCategory.getCompanyId(), (String)document.get("uid"), (boolean)this.isCommitImmediately());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        AssetCategory category = (AssetCategory)obj;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing category " + category));
        }
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)category);
        document.addKeyword("assetCategoryId", category.getCategoryId());
        ArrayList<AssetCategory> categories = new ArrayList<AssetCategory>(1);
        categories.add(category);
        this.addSearchAssetCategoryTitles(document, "assetCategoryTitle", categories);
        document.addKeyword("parentCategoryId", category.getParentCategoryId());
        document.addKeyword("assetVocabularyId", category.getVocabularyId());
        document.addLocalizedText("description", category.getDescriptionMap());
        document.addText("name", category.getName());
        document.addLocalizedText("title", category.getTitleMap());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + category + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    protected void doReindex(Object obj) throws Exception {
        AssetCategory category = (AssetCategory)obj;
        Document document = this.getDocument(category);
        if (document != null) {
            SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)category.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        AssetCategory category = AssetCategoryLocalServiceUtil.getCategory((long)classPK);
        this.doReindex(category);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCategories(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexCategories(long companyId) throws PortalException {
        final ActionableDynamicQuery actionableDynamicQuery = AssetCategoryLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                AssetCategory category = (AssetCategory)object;
                Document document = AssetCategoryIndexer.this.getDocument(category);
                if (document != null) {
                    actionableDynamicQuery.addDocument(document);
                }
            }
        });
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }
}

