/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;

public class AssetVocabularyPermission {
    public static void check(PermissionChecker permissionChecker, AssetVocabulary vocabulary, String actionId) throws PortalException {
        if (!AssetVocabularyPermission.contains(permissionChecker, vocabulary, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long vocabularyId, String actionId) throws PortalException {
        if (!AssetVocabularyPermission.contains(permissionChecker, vocabularyId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, AssetVocabulary vocabulary, String actionId) {
        if (permissionChecker.hasOwnerPermission(vocabulary.getCompanyId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), vocabulary.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(vocabulary.getGroupId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long vocabularyId, String actionId) throws PortalException {
        AssetVocabulary vocabulary = AssetVocabularyLocalServiceUtil.getVocabulary((long)vocabularyId);
        return AssetVocabularyPermission.contains(permissionChecker, vocabulary, actionId);
    }
}

