/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.model.AssetVocabularyDisplay;
import com.liferay.portlet.asset.service.base.AssetVocabularyServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetPermission;
import com.liferay.portlet.asset.service.permission.AssetVocabularyPermission;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetVocabularyServiceImpl
extends AssetVocabularyServiceBaseImpl {
    @Deprecated
    public AssetVocabulary addVocabulary(Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        return this.addVocabulary("", titleMap, descriptionMap, settings, serviceContext);
    }

    public AssetVocabulary addVocabulary(String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        AssetPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_VOCABULARY");
        return this.assetVocabularyLocalService.addVocabulary(this.getUserId(), title, titleMap, descriptionMap, settings, serviceContext);
    }

    public AssetVocabulary addVocabulary(String title, ServiceContext serviceContext) throws PortalException {
        AssetPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_VOCABULARY");
        return this.assetVocabularyLocalService.addVocabulary(this.getUserId(), title, serviceContext);
    }

    @Deprecated
    public void deleteVocabularies(long[] vocabularyIds) throws PortalException {
        this.deleteVocabularies(vocabularyIds, null);
    }

    public List<AssetVocabulary> deleteVocabularies(long[] vocabularyIds, ServiceContext serviceContext) throws PortalException {
        ArrayList<AssetVocabulary> failedVocabularies = new ArrayList<AssetVocabulary>();
        for (long vocabularyId : vocabularyIds) {
            try {
                AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "DELETE");
                this.assetVocabularyLocalService.deleteVocabulary(vocabularyId);
            }
            catch (PortalException pe) {
                if (serviceContext == null) {
                    return null;
                }
                if (serviceContext.isFailOnPortalException()) {
                    throw pe;
                }
                AssetVocabulary vocabulary = this.assetVocabularyPersistence.fetchByPrimaryKey(vocabularyId);
                if (vocabulary == null) {
                    vocabulary = this.assetVocabularyPersistence.create(vocabularyId);
                }
                failedVocabularies.add(vocabulary);
            }
        }
        return failedVocabularies;
    }

    public void deleteVocabulary(long vocabularyId) throws PortalException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "DELETE");
        this.assetVocabularyLocalService.deleteVocabulary(vocabularyId);
    }

    @Deprecated
    public List<AssetVocabulary> getCompanyVocabularies(long companyId) throws PortalException {
        return this.filterVocabularies(this.assetVocabularyLocalService.getCompanyVocabularies(companyId));
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds) {
        return this.getGroupsVocabularies(groupIds, null);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className) {
        return this.getGroupsVocabularies(groupIds, className, -1L);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className, long classTypePK) {
        List vocabularies = this.assetVocabularyPersistence.filterFindByGroupId(groupIds);
        if (Validator.isNull((String)className)) {
            return vocabularies;
        }
        return AssetUtil.filterVocabularies(vocabularies, className, classTypePK);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId) throws PortalException {
        return this.getGroupVocabularies(groupId, true);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, boolean createDefaultVocabulary) throws PortalException {
        ArrayList<AssetVocabulary> vocabularies = this.assetVocabularyPersistence.filterFindByGroupId(groupId);
        if (!vocabularies.isEmpty() || !createDefaultVocabulary) {
            return vocabularies;
        }
        vocabularies = new ArrayList<AssetVocabulary>();
        AssetVocabulary vocabulary = this.assetVocabularyLocalService.addDefaultVocabulary(groupId);
        vocabularies.add(vocabulary);
        return vocabularies;
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, boolean createDefaultVocabulary, int start, int end, OrderByComparator<AssetVocabulary> obc) throws PortalException {
        List<AssetVocabulary> vocabularies = this.getGroupVocabularies(groupId, start, end, obc);
        if (!vocabularies.isEmpty() || !createDefaultVocabulary) {
            return vocabularies;
        }
        vocabularies = new ArrayList<AssetVocabulary>();
        AssetVocabulary vocabulary = this.assetVocabularyLocalService.addDefaultVocabulary(groupId);
        vocabularies.add(vocabulary);
        return vocabularies;
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, int start, int end, OrderByComparator<AssetVocabulary> obc) {
        return this.assetVocabularyPersistence.filterFindByGroupId(groupId, start, end, obc);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, String name, int start, int end, OrderByComparator<AssetVocabulary> obc) {
        return this.assetVocabularyPersistence.filterFindByG_LikeN(groupId, name, start, end, obc);
    }

    public List<AssetVocabulary> getGroupVocabularies(long[] groupIds) {
        return this.assetVocabularyPersistence.filterFindByGroupId(groupIds);
    }

    public int getGroupVocabulariesCount(long groupId) {
        return this.assetVocabularyPersistence.filterCountByGroupId(groupId);
    }

    public int getGroupVocabulariesCount(long groupId, String name) {
        return this.assetVocabularyPersistence.filterCountByG_LikeN(groupId, name);
    }

    public int getGroupVocabulariesCount(long[] groupIds) {
        return this.assetVocabularyPersistence.filterCountByGroupId(groupIds);
    }

    public AssetVocabularyDisplay getGroupVocabulariesDisplay(long groupId, String name, int start, int end, boolean addDefaultVocabulary, OrderByComparator<AssetVocabulary> obc) throws PortalException {
        List<AssetVocabulary> vocabularies;
        int total = 0;
        if (Validator.isNotNull((String)name)) {
            name = CustomSQLUtil.keywords((String)name)[0];
            vocabularies = this.getGroupVocabularies(groupId, name, start, end, obc);
            total = this.getGroupVocabulariesCount(groupId, name);
        } else {
            vocabularies = this.getGroupVocabularies(groupId, start, end, obc);
            total = this.getGroupVocabulariesCount(groupId);
        }
        if (addDefaultVocabulary && total == 0 && this.assetVocabularyPersistence.countByGroupId(groupId) == 0) {
            vocabularies = new ArrayList<AssetVocabulary>();
            vocabularies.add(this.assetVocabularyLocalService.addDefaultVocabulary(groupId));
            total = 1;
        }
        return new AssetVocabularyDisplay(vocabularies, total, start, end);
    }

    public AssetVocabularyDisplay getGroupVocabulariesDisplay(long groupId, String name, int start, int end, OrderByComparator<AssetVocabulary> obc) throws PortalException {
        return this.getGroupVocabulariesDisplay(groupId, name, start, end, false, obc);
    }

    @Deprecated
    public JSONObject getJSONGroupVocabularies(long groupId, String name, int start, int end, OrderByComparator<AssetVocabulary> obc) throws PortalException {
        List<AssetVocabulary> vocabularies;
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        int page = end / (end - start);
        jsonObject.put("page", page);
        int total = 0;
        if (Validator.isNotNull((String)name)) {
            name = CustomSQLUtil.keywords((String)name)[0];
            vocabularies = this.getGroupVocabularies(groupId, name, start, end, obc);
            total = this.getGroupVocabulariesCount(groupId, name);
        } else {
            vocabularies = this.getGroupVocabularies(groupId, start, end, obc);
            total = this.getGroupVocabulariesCount(groupId);
        }
        String vocabulariesJSON = JSONFactoryUtil.looseSerialize(vocabularies);
        JSONArray vocabulariesJSONArray = JSONFactoryUtil.createJSONArray((String)vocabulariesJSON);
        jsonObject.put("vocabularies", vocabulariesJSONArray);
        jsonObject.put("total", total);
        return jsonObject;
    }

    @Deprecated
    public List<AssetVocabulary> getVocabularies(long[] vocabularyIds) throws PortalException {
        return this.filterVocabularies(this.assetVocabularyLocalService.getVocabularies(vocabularyIds));
    }

    public AssetVocabulary getVocabulary(long vocabularyId) throws PortalException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "VIEW");
        return this.assetVocabularyLocalService.getVocabulary(vocabularyId);
    }

    public AssetVocabularyDisplay searchVocabulariesDisplay(long groupId, String title, int start, int end, boolean addDefaultVocabulary) throws PortalException {
        User user = this.getUser();
        BaseModelSearchResult baseModelSearchResult = this.assetVocabularyLocalService.searchVocabularies(user.getCompanyId(), groupId, title, start, end);
        ArrayList<AssetVocabulary> vocabularies = baseModelSearchResult.getBaseModels();
        int total = baseModelSearchResult.getLength();
        if (addDefaultVocabulary && total == 0 && (total = this.assetVocabularyPersistence.countByGroupId(groupId)) == 0) {
            vocabularies = new ArrayList<AssetVocabulary>(1);
            AssetVocabulary defaultVocabulary = this.assetVocabularyLocalService.addDefaultVocabulary(groupId);
            vocabularies.add(defaultVocabulary);
            total = 1;
        }
        return new AssetVocabularyDisplay((List)vocabularies, total, start, end);
    }

    @Deprecated
    public AssetVocabulary updateVocabulary(long vocabularyId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        return this.updateVocabulary(vocabularyId, "", titleMap, descriptionMap, settings, serviceContext);
    }

    public AssetVocabulary updateVocabulary(long vocabularyId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "UPDATE");
        return this.assetVocabularyLocalService.updateVocabulary(vocabularyId, title, titleMap, descriptionMap, settings, serviceContext);
    }

    @Deprecated
    protected List<AssetVocabulary> filterVocabularies(List<AssetVocabulary> vocabularies) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        vocabularies = ListUtil.copy(vocabularies);
        Iterator itr = vocabularies.iterator();
        while (itr.hasNext()) {
            AssetVocabulary vocabulary = (AssetVocabulary)itr.next();
            if (AssetVocabularyPermission.contains(permissionChecker, vocabulary, "VIEW")) continue;
            itr.remove();
        }
        return vocabularies;
    }
}

