/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.DuplicateVocabularyException;
import com.liferay.portlet.asset.VocabularyNameException;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.base.AssetVocabularyLocalServiceBaseImpl;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.portlet.asset.util.AssetVocabularyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetVocabularyLocalServiceImpl
extends AssetVocabularyLocalServiceBaseImpl {
    public AssetVocabulary addDefaultVocabulary(long groupId) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        titleMap.put(LocaleUtil.getSiteDefault(), PropsValues.ASSET_VOCABULARY_DEFAULT);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        return this.assetVocabularyLocalService.addVocabulary(defaultUserId, "", titleMap, null, "", serviceContext);
    }

    @Deprecated
    public AssetVocabulary addVocabulary(long userId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        return this.assetVocabularyLocalService.addVocabulary(userId, "", titleMap, descriptionMap, settings, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetVocabulary addVocabulary(long userId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        String name = titleMap.get(LocaleUtil.getSiteDefault());
        Date now = new Date();
        this.validate(groupId, name);
        long vocabularyId = this.counterLocalService.increment();
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.create(vocabularyId);
        vocabulary.setUuid(serviceContext.getUuid());
        vocabulary.setGroupId(groupId);
        vocabulary.setCompanyId(user.getCompanyId());
        vocabulary.setUserId(user.getUserId());
        vocabulary.setUserName(user.getFullName());
        vocabulary.setCreateDate(now);
        vocabulary.setModifiedDate(now);
        vocabulary.setName(name);
        if (Validator.isNotNull((String)title)) {
            vocabulary.setTitle(title);
        } else {
            vocabulary.setTitleMap(titleMap);
        }
        vocabulary.setDescriptionMap(descriptionMap);
        vocabulary.setSettings(settings);
        this.assetVocabularyPersistence.update((BaseModel)vocabulary);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addVocabularyResources(vocabulary, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addVocabularyResources(vocabulary, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return vocabulary;
    }

    public AssetVocabulary addVocabulary(long userId, String title, ServiceContext serviceContext) throws PortalException {
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        Locale locale = LocaleUtil.getSiteDefault();
        titleMap.put(locale, title);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, "");
        return this.assetVocabularyLocalService.addVocabulary(userId, title, titleMap, descriptionMap, null, serviceContext);
    }

    public void addVocabularyResources(AssetVocabulary vocabulary, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(vocabulary.getCompanyId(), vocabulary.getGroupId(), vocabulary.getUserId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addVocabularyResources(AssetVocabulary vocabulary, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(vocabulary.getCompanyId(), vocabulary.getGroupId(), vocabulary.getUserId(), AssetVocabulary.class.getName(), vocabulary.getVocabularyId(), groupPermissions, guestPermissions);
    }

    public void deleteVocabularies(long groupId) throws PortalException {
        List vocabularies = this.assetVocabularyPersistence.findByGroupId(groupId);
        for (AssetVocabulary vocabulary : vocabularies) {
            this.assetVocabularyLocalService.deleteVocabulary(vocabulary);
        }
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public void deleteVocabulary(AssetVocabulary vocabulary) throws PortalException {
        this.assetVocabularyPersistence.remove((BaseModel)vocabulary);
        this.resourceLocalService.deleteResource(vocabulary.getCompanyId(), AssetVocabulary.class.getName(), 4, vocabulary.getVocabularyId());
        this.assetCategoryLocalService.deleteVocabularyCategories(vocabulary.getVocabularyId());
    }

    public void deleteVocabulary(long vocabularyId) throws PortalException {
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        this.assetVocabularyLocalService.deleteVocabulary(vocabulary);
    }

    public List<AssetVocabulary> getCompanyVocabularies(long companyId) {
        return this.assetVocabularyPersistence.findByCompanyId(companyId);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds) {
        return this.getGroupsVocabularies(groupIds, null);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className) {
        return this.getGroupsVocabularies(groupIds, className, -1L);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className, long classTypePK) {
        List vocabularies = this.assetVocabularyPersistence.findByGroupId(groupIds);
        if (Validator.isNull((String)className)) {
            return vocabularies;
        }
        return AssetUtil.filterVocabularies(vocabularies, className, classTypePK);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId) throws PortalException {
        return this.getGroupVocabularies(groupId, true);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, boolean addDefaultVocabulary) throws PortalException {
        ArrayList<AssetVocabulary> vocabularies = this.assetVocabularyPersistence.findByGroupId(groupId);
        if (!vocabularies.isEmpty() || !addDefaultVocabulary) {
            return vocabularies;
        }
        AssetVocabulary vocabulary = this.addDefaultVocabulary(groupId);
        vocabularies = new ArrayList<AssetVocabulary>();
        vocabularies.add(vocabulary);
        return vocabularies;
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, String name, int start, int end, OrderByComparator<AssetVocabulary> obc) {
        return this.assetVocabularyFinder.findByG_N(groupId, name, start, end, obc);
    }

    public List<AssetVocabulary> getGroupVocabularies(long[] groupIds) {
        return this.assetVocabularyPersistence.findByGroupId(groupIds);
    }

    public int getGroupVocabulariesCount(long[] groupIds) {
        return this.assetVocabularyPersistence.countByGroupId(groupIds);
    }

    public AssetVocabulary getGroupVocabulary(long groupId, String name) throws PortalException {
        return this.assetVocabularyPersistence.findByG_N(groupId, name);
    }

    public List<AssetVocabulary> getVocabularies(long[] vocabularyIds) throws PortalException {
        ArrayList<AssetVocabulary> vocabularies = new ArrayList<AssetVocabulary>();
        for (long vocabularyId : vocabularyIds) {
            AssetVocabulary vocabulary = this.getVocabulary(vocabularyId);
            vocabularies.add(vocabulary);
        }
        return vocabularies;
    }

    public AssetVocabulary getVocabulary(long vocabularyId) throws PortalException {
        return this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
    }

    public BaseModelSearchResult<AssetVocabulary> searchVocabularies(long companyId, long groupId, String title, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, title, start, end);
        return this.searchVocabularies(searchContext);
    }

    @Deprecated
    public AssetVocabulary updateVocabulary(long vocabularyId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        return this.assetVocabularyLocalService.updateVocabulary(vocabularyId, "", titleMap, descriptionMap, settings, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetVocabulary updateVocabulary(long vocabularyId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        long groupId = serviceContext.getScopeGroupId();
        String name = titleMap.get(LocaleUtil.getSiteDefault());
        AssetVocabulary vocabulary = this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        if (!vocabulary.getName().equals(name)) {
            this.validate(groupId, name);
        }
        vocabulary.setModifiedDate(new Date());
        vocabulary.setName(name);
        vocabulary.setTitleMap(titleMap);
        if (Validator.isNotNull((String)title)) {
            vocabulary.setTitle(title);
        }
        vocabulary.setDescriptionMap(descriptionMap);
        vocabulary.setSettings(settings);
        this.assetVocabularyPersistence.update((BaseModel)vocabulary);
        return vocabulary;
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, String title, int start, int end) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("title", (Serializable)((Object)title));
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setKeywords(title);
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected boolean hasVocabulary(long groupId, String name) {
        return this.assetVocabularyPersistence.countByG_N(groupId, name) != 0;
    }

    protected BaseModelSearchResult<AssetVocabulary> searchVocabularies(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetVocabulary.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<AssetVocabulary> vocabularies = AssetVocabularyUtil.getVocabularies(hits);
            if (vocabularies == null) continue;
            return new BaseModelSearchResult(vocabularies, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validate(long groupId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new VocabularyNameException();
        }
        if (this.hasVocabulary(groupId, name)) {
            throw new DuplicateVocabularyException("A category vocabulary with the name " + name + " already exists");
        }
    }
}

