/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetTagDisplay;
import com.liferay.portlet.asset.service.base.AssetTagServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetPermission;
import com.liferay.portlet.asset.service.permission.AssetTagPermission;
import com.liferay.portlet.asset.util.comparator.AssetTagNameComparator;
import com.liferay.util.Autocomplete;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class AssetTagServiceImpl
extends AssetTagServiceBaseImpl {
    public AssetTag addTag(String name, String[] tagProperties, ServiceContext serviceContext) throws PortalException {
        AssetPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_TAG");
        return this.assetTagLocalService.addTag(this.getUserId(), name, tagProperties, serviceContext);
    }

    public void deleteTag(long tagId) throws PortalException {
        AssetTagPermission.check(this.getPermissionChecker(), tagId, "DELETE");
        this.assetTagLocalService.deleteTag(tagId);
    }

    public void deleteTags(long[] tagIds) throws PortalException {
        for (long tagId : tagIds) {
            AssetTagPermission.check(this.getPermissionChecker(), tagId, "DELETE");
            this.assetTagLocalService.deleteTag(tagId);
        }
    }

    public List<AssetTag> getGroupsTags(long[] groupIds) {
        TreeSet<AssetTag> groupsTags = new TreeSet<AssetTag>(new AssetTagNameComparator());
        for (long groupId : groupIds) {
            List<AssetTag> groupTags = this.getGroupTags(groupId);
            groupsTags.addAll(groupTags);
        }
        return new ArrayList<AssetTag>(groupsTags);
    }

    public List<AssetTag> getGroupTags(long groupId) {
        return this.assetTagPersistence.filterFindByGroupId(groupId);
    }

    public List<AssetTag> getGroupTags(long groupId, int start, int end, OrderByComparator<AssetTag> obc) {
        return this.assetTagPersistence.filterFindByGroupId(groupId, start, end, obc);
    }

    public int getGroupTagsCount(long groupId) {
        return this.assetTagPersistence.filterCountByGroupId(groupId);
    }

    public AssetTagDisplay getGroupTagsDisplay(long groupId, String name, int start, int end) {
        List<AssetTag> tags = null;
        int total = 0;
        if (Validator.isNotNull((String)name)) {
            name = CustomSQLUtil.keywords((String)name)[0];
            tags = this.getTags(groupId, name, new String[0], start, end);
            total = this.getTagsCount(groupId, name, new String[0]);
        } else {
            tags = this.getGroupTags(groupId, start, end, null);
            total = this.getGroupTagsCount(groupId);
        }
        return new AssetTagDisplay(tags, total, start, end);
    }

    @Deprecated
    public JSONObject getJSONGroupTags(long groupId, String name, int start, int end) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        int page = end / (end - start);
        jsonObject.put("page", page);
        List<AssetTag> tags = null;
        int total = 0;
        if (Validator.isNotNull((String)name)) {
            name = CustomSQLUtil.keywords((String)name)[0];
            tags = this.getTags(groupId, name, new String[0], start, end);
            total = this.getTagsCount(groupId, name, new String[0]);
        } else {
            tags = this.getGroupTags(groupId, start, end, null);
            total = this.getGroupTagsCount(groupId);
        }
        String tagsJSON = JSONFactoryUtil.looseSerialize(tags);
        JSONArray tagsJSONArray = JSONFactoryUtil.createJSONArray((String)tagsJSON);
        jsonObject.put("tags", tagsJSONArray);
        jsonObject.put("total", total);
        return jsonObject;
    }

    public AssetTag getTag(long tagId) throws PortalException {
        AssetTagPermission.check(this.getPermissionChecker(), tagId, "VIEW");
        return this.assetTagLocalService.getTag(tagId);
    }

    public List<AssetTag> getTags(long groupId, long classNameId, String name) {
        return this.assetTagFinder.filterFindByG_C_N(groupId, classNameId, name, -1, -1, null);
    }

    public List<AssetTag> getTags(long groupId, long classNameId, String name, int start, int end, OrderByComparator<AssetTag> obc) {
        return this.assetTagFinder.filterFindByG_C_N(groupId, classNameId, name, start, end, obc);
    }

    public List<AssetTag> getTags(long groupId, String name, String[] tagProperties, int start, int end) {
        return this.getTags(new long[]{groupId}, name, tagProperties, start, end);
    }

    public List<AssetTag> getTags(long[] groupIds, String name, String[] tagProperties, int start, int end) {
        return this.assetTagFinder.filterFindByG_N_P(groupIds, name, tagProperties, start, end, null);
    }

    public List<AssetTag> getTags(String className, long classPK) throws PortalException {
        return this.filterTags(this.assetTagLocalService.getTags(className, classPK));
    }

    public int getTagsCount(long groupId, long classNameId, String name) {
        return this.assetTagFinder.filterCountByG_C_N(groupId, classNameId, name);
    }

    public int getTagsCount(long groupId, String name) {
        return this.assetTagFinder.filterCountByG_N(groupId, name);
    }

    public int getTagsCount(long groupId, String name, String[] tagProperties) {
        return this.assetTagFinder.filterCountByG_N_P(groupId, name, tagProperties);
    }

    public void mergeTags(long fromTagId, long toTagId, boolean overrideProperties) throws PortalException {
        AssetTagPermission.check(this.getPermissionChecker(), fromTagId, "VIEW");
        AssetTagPermission.check(this.getPermissionChecker(), toTagId, "UPDATE");
        this.assetTagLocalService.mergeTags(fromTagId, toTagId, overrideProperties);
    }

    public void mergeTags(long[] fromTagIds, long toTagId, boolean overrideProperties) throws PortalException {
        for (long fromTagId : fromTagIds) {
            this.mergeTags(fromTagId, toTagId, overrideProperties);
        }
    }

    public JSONArray search(long groupId, String name, String[] tagProperties, int start, int end) {
        return this.search(new long[]{groupId}, name, tagProperties, start, end);
    }

    public JSONArray search(long[] groupIds, String name, String[] tagProperties, int start, int end) {
        List<AssetTag> tags = this.getTags(groupIds, name, tagProperties, start, end);
        return Autocomplete.listToJson(tags, (String)"name", (String)"name");
    }

    public AssetTag updateTag(long tagId, String name, String[] tagProperties, ServiceContext serviceContext) throws PortalException {
        AssetTagPermission.check(this.getPermissionChecker(), tagId, "UPDATE");
        return this.assetTagLocalService.updateTag(this.getUserId(), tagId, name, tagProperties, serviceContext);
    }

    protected List<AssetTag> filterTags(List<AssetTag> tags) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        tags = ListUtil.copy(tags);
        Iterator itr = tags.iterator();
        while (itr.hasNext()) {
            AssetTag tag = (AssetTag)itr.next();
            if (AssetTagPermission.contains(permissionChecker, tag, "VIEW")) continue;
            itr.remove();
        }
        return tags;
    }
}

