/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portlet.asset.NoSuchLinkException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.asset.model.AssetLinkConstants;
import com.liferay.portlet.asset.service.base.AssetLinkLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class AssetLinkLocalServiceImpl
extends AssetLinkLocalServiceBaseImpl {
    public AssetLink addLink(long userId, long entryId1, long entryId2, int type, int weight) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        long linkId = this.counterLocalService.increment();
        AssetLink link = this.assetLinkPersistence.create(linkId);
        link.setCompanyId(user.getCompanyId());
        link.setUserId(user.getUserId());
        link.setUserName(user.getFullName());
        link.setCreateDate(now);
        link.setEntryId1(entryId1);
        link.setEntryId2(entryId2);
        link.setType(type);
        link.setWeight(weight);
        this.assetLinkPersistence.update((BaseModel)link);
        if (AssetLinkConstants.isTypeBi((int)type)) {
            long linkId2 = this.counterLocalService.increment();
            AssetLink link2 = this.assetLinkPersistence.create(linkId2);
            link2.setCompanyId(user.getCompanyId());
            link2.setUserId(user.getUserId());
            link2.setUserName(user.getFullName());
            link2.setCreateDate(now);
            link2.setEntryId1(entryId2);
            link2.setEntryId2(entryId1);
            link2.setType(type);
            link2.setWeight(weight);
            this.assetLinkPersistence.update((BaseModel)link2);
        }
        return link;
    }

    public void deleteLink(AssetLink link) {
        if (AssetLinkConstants.isTypeBi((int)link.getType())) {
            try {
                this.assetLinkPersistence.removeByE_E_T(link.getEntryId2(), link.getEntryId1(), link.getType());
            }
            catch (NoSuchLinkException noSuchLinkException) {
                // empty catch block
            }
        }
        this.assetLinkPersistence.remove((BaseModel)link);
    }

    public void deleteLink(long linkId) throws PortalException {
        AssetLink link = this.assetLinkPersistence.findByPrimaryKey(linkId);
        this.deleteLink(link);
    }

    public void deleteLinks(long entryId) {
        for (AssetLink link : this.assetLinkPersistence.findByE1(entryId)) {
            this.deleteLink(link);
        }
        for (AssetLink link : this.assetLinkPersistence.findByE2(entryId)) {
            this.deleteLink(link);
        }
    }

    public void deleteLinks(long entryId1, long entryId2) {
        List links = this.assetLinkPersistence.findByE_E(entryId1, entryId2);
        for (AssetLink link : links) {
            this.deleteLink(link);
        }
    }

    public List<AssetLink> getDirectLinks(long entryId) {
        List<AssetLink> assetLinks = this.assetLinkPersistence.findByE1(entryId);
        if (!assetLinks.isEmpty()) {
            ArrayList<AssetLink> filteredAssetLinks = new ArrayList<AssetLink>(assetLinks.size());
            for (AssetLink assetLink : assetLinks) {
                AssetEntry assetEntry = this.assetEntryPersistence.fetchByPrimaryKey(assetLink.getEntryId2());
                if (assetEntry == null || !assetEntry.isVisible()) continue;
                filteredAssetLinks.add(assetLink);
            }
            assetLinks = Collections.unmodifiableList(filteredAssetLinks);
        }
        return assetLinks;
    }

    public List<AssetLink> getDirectLinks(long entryId, int typeId) {
        List<AssetLink> assetLinks = this.assetLinkPersistence.findByE1_T(entryId, typeId);
        if (!assetLinks.isEmpty()) {
            ArrayList<AssetLink> filteredAssetLinks = new ArrayList<AssetLink>(assetLinks.size());
            for (AssetLink assetLink : assetLinks) {
                AssetEntry assetEntry = this.assetEntryPersistence.fetchByPrimaryKey(assetLink.getEntryId2());
                if (assetEntry == null || !assetEntry.isVisible()) continue;
                filteredAssetLinks.add(assetLink);
            }
            assetLinks = Collections.unmodifiableList(filteredAssetLinks);
        }
        return assetLinks;
    }

    public List<AssetLink> getLinks(long entryId) {
        List e1Links = this.assetLinkPersistence.findByE1(entryId);
        List e2Links = this.assetLinkPersistence.findByE2(entryId);
        ArrayList<AssetLink> links = new ArrayList<AssetLink>(e1Links.size() + e2Links.size());
        links.addAll(e1Links);
        links.addAll(e2Links);
        return links;
    }

    public List<AssetLink> getLinks(long entryId, int typeId) {
        List e1Links = this.assetLinkPersistence.findByE1_T(entryId, typeId);
        List e2Links = this.assetLinkPersistence.findByE2_T(entryId, typeId);
        ArrayList<AssetLink> links = new ArrayList<AssetLink>(e1Links.size() + e2Links.size());
        links.addAll(e1Links);
        links.addAll(e2Links);
        return links;
    }

    public List<AssetLink> getReverseLinks(long entryId, int typeId) {
        return this.assetLinkPersistence.findByE2_T(entryId, typeId);
    }

    public AssetLink updateLink(long userId, long entryId1, long entryId2, int typeId, int weight) throws PortalException {
        AssetLink assetLink = this.assetLinkPersistence.fetchByE_E_T(entryId1, entryId2, typeId);
        if (assetLink == null) {
            return this.addLink(userId, entryId1, entryId2, typeId, weight);
        }
        assetLink.setWeight(weight);
        this.assetLinkPersistence.update((BaseModel)assetLink);
        return assetLink;
    }

    public void updateLinks(long userId, long entryId, long[] linkEntryIds, int typeId) throws PortalException {
        if (linkEntryIds == null) {
            return;
        }
        List<AssetLink> links = this.getLinks(entryId, typeId);
        for (AssetLink link : links) {
            if ((link.getEntryId1() != entryId || ArrayUtil.contains((long[])linkEntryIds, (long)link.getEntryId2())) && (link.getEntryId2() != entryId || ArrayUtil.contains((long[])linkEntryIds, (long)link.getEntryId1()))) continue;
            this.deleteLink(link);
        }
        for (long assetLinkEntryId : linkEntryIds) {
            AssetLink link;
            if (assetLinkEntryId == entryId || (link = this.assetLinkPersistence.fetchByE_E_T(entryId, assetLinkEntryId, typeId)) != null) continue;
            this.addLink(userId, entryId, assetLinkEntryId, typeId, 0);
        }
    }
}

