/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.cache.Lifecycle;
import com.liferay.portal.kernel.cache.ThreadLocalCache;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.service.base.AssetEntryServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetEntryPermission;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.asset.util.AssetUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AssetEntryServiceImpl
extends AssetEntryServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(AssetEntryServiceImpl.class);

    public List<AssetEntry> getCompanyEntries(long companyId, int start, int end) {
        ArrayList<AssetEntry> entries = new ArrayList<AssetEntry>();
        List companyEntries = this.assetEntryLocalService.getCompanyEntries(companyId, start, end);
        for (AssetEntry entry : companyEntries) {
            try {
                if (!AssetEntryPermission.contains(this.getPermissionChecker(), entry, "VIEW")) continue;
                entries.add(entry);
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)pe, (Throwable)pe);
            }
        }
        return entries;
    }

    public int getCompanyEntriesCount(long companyId) {
        return this.assetEntryLocalService.getCompanyEntriesCount(companyId);
    }

    public List<AssetEntry> getEntries(AssetEntryQuery entryQuery) throws PortalException {
        AssetEntryQuery filteredEntryQuery = this.buildFilteredEntryQuery(entryQuery);
        if (this.hasEntryQueryResults(entryQuery, filteredEntryQuery)) {
            return new ArrayList<AssetEntry>();
        }
        Object[] results = this.filterEntryQuery(filteredEntryQuery, false);
        return (List)results[0];
    }

    public int getEntriesCount(AssetEntryQuery entryQuery) throws PortalException {
        AssetEntryQuery filteredEntryQuery = this.buildFilteredEntryQuery(entryQuery);
        if (this.hasEntryQueryResults(entryQuery, filteredEntryQuery)) {
            return 0;
        }
        Object[] results = this.filterEntryQuery(filteredEntryQuery, true);
        return (Integer)results[1];
    }

    public AssetEntry getEntry(long entryId) throws PortalException {
        AssetEntryPermission.check(this.getPermissionChecker(), entryId, "VIEW");
        return this.assetEntryLocalService.getEntry(entryId);
    }

    public AssetEntry incrementViewCounter(String className, long classPK) throws PortalException {
        AssetEntryPermission.check(this.getPermissionChecker(), className, classPK, "VIEW");
        return this.assetEntryLocalService.incrementViewCounter(this.getGuestOrUserId(), className, classPK);
    }

    public AssetEntry updateEntry(long groupId, Date createDate, Date modifiedDate, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Integer priority, boolean sync) throws PortalException {
        AssetEntryPermission.check(this.getPermissionChecker(), className, classPK, "UPDATE");
        return this.assetEntryLocalService.updateEntry(this.getUserId(), groupId, createDate, modifiedDate, className, classPK, classUuid, classTypeId, categoryIds, tagNames, visible, startDate, endDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority, sync);
    }

    @Deprecated
    public AssetEntry updateEntry(long groupId, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Integer priority, boolean sync) throws PortalException {
        AssetEntryPermission.check(this.getPermissionChecker(), className, classPK, "UPDATE");
        return this.assetEntryLocalService.updateEntry(this.getUserId(), groupId, className, classPK, classUuid, classTypeId, categoryIds, tagNames, visible, startDate, endDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority, sync);
    }

    @Deprecated
    public AssetEntry updateEntry(long groupId, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Integer priority, boolean sync) throws PortalException {
        return this.assetEntryLocalService.updateEntry(this.getUserId(), groupId, null, null, className, classPK, classUuid, classTypeId, categoryIds, tagNames, visible, startDate, endDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority, sync);
    }

    protected AssetEntryQuery buildFilteredEntryQuery(AssetEntryQuery entryQuery) throws PortalException {
        AssetEntryQuery filteredEntryQuery = new AssetEntryQuery(entryQuery);
        filteredEntryQuery.setAllCategoryIds(AssetUtil.filterCategoryIds(this.getPermissionChecker(), entryQuery.getAllCategoryIds()));
        filteredEntryQuery.setAllTagIdsArray(AssetUtil.filterTagIdsArray(this.getPermissionChecker(), entryQuery.getAllTagIdsArray()));
        filteredEntryQuery.setAnyCategoryIds(AssetUtil.filterCategoryIds(this.getPermissionChecker(), entryQuery.getAnyCategoryIds()));
        filteredEntryQuery.setAnyTagIds(AssetUtil.filterTagIds(this.getPermissionChecker(), entryQuery.getAnyTagIds()));
        return filteredEntryQuery;
    }

    protected Object[] filterEntryQuery(AssetEntryQuery entryQuery, boolean returnEntriesCountOnly) throws PortalException {
        ThreadLocalCache threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)Lifecycle.REQUEST, (Serializable)((Object)AssetEntryServiceImpl.class.getName()));
        String key = entryQuery.toString();
        Object[] results = (Object[])threadLocalCache.get(key = key.concat("#").concat(Boolean.toString(returnEntriesCountOnly)));
        if (results != null) {
            return results;
        }
        if (returnEntriesCountOnly && !entryQuery.isEnablePermissions()) {
            int entriesCount = this.assetEntryLocalService.getEntriesCount(entryQuery);
            results = new Object[]{null, entriesCount};
            threadLocalCache.put(key, (Object)results);
            return results;
        }
        int end = entryQuery.getEnd();
        int start = entryQuery.getStart();
        if (entryQuery.isEnablePermissions()) {
            entryQuery.setEnd(end + PropsValues.ASSET_FILTER_SEARCH_LIMIT);
            entryQuery.setStart(0);
        }
        ArrayList entries = this.assetEntryLocalService.getEntries(entryQuery);
        List<AssetEntry> filteredEntries = null;
        int filteredEntriesCount = 0;
        if (entryQuery.isEnablePermissions()) {
            PermissionChecker permissionChecker = this.getPermissionChecker();
            filteredEntries = new ArrayList();
            for (AssetEntry entry : entries) {
                String className = entry.getClassName();
                long classPK = entry.getClassPK();
                AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
                try {
                    if (assetRendererFactory.hasPermission(permissionChecker, classPK, "VIEW")) {
                        filteredEntries.add(entry);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (end == -1 || filteredEntries.size() <= end) continue;
                break;
            }
            filteredEntriesCount = filteredEntries.size();
            if (end != -1 && start != -1) {
                if (end > filteredEntriesCount) {
                    end = filteredEntriesCount;
                }
                if (start > filteredEntriesCount) {
                    start = filteredEntriesCount;
                }
                filteredEntries = filteredEntries.subList(start, end);
            }
            entryQuery.setEnd(end);
            entryQuery.setStart(start);
        } else {
            filteredEntries = entries;
            filteredEntriesCount = filteredEntries.size();
        }
        results = new Object[]{filteredEntries, filteredEntriesCount};
        threadLocalCache.put(key, (Object)results);
        return results;
    }

    protected boolean hasEntryQueryResults(AssetEntryQuery originalEntryQuery, AssetEntryQuery filteredEntryQuery) {
        if (originalEntryQuery.getAllCategoryIds().length > filteredEntryQuery.getAllCategoryIds().length) {
            return true;
        }
        if (originalEntryQuery.getAllTagIds().length > filteredEntryQuery.getAllTagIds().length) {
            return true;
        }
        if (originalEntryQuery.getAnyCategoryIds().length > 0 && filteredEntryQuery.getAnyCategoryIds().length == 0) {
            return true;
        }
        return originalEntryQuery.getAnyTagIds().length > 0 && filteredEntryQuery.getAnyTagIds().length == 0;
    }
}

