/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.NoSuchEntryException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.service.base.AssetEntryLocalServiceBaseImpl;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.asset.util.AssetEntryValidator;
import com.liferay.portlet.assetpublisher.util.AssetSearcher;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.wiki.model.WikiPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AssetEntryLocalServiceImpl
extends AssetEntryLocalServiceBaseImpl {
    public void deleteEntry(AssetEntry entry) throws PortalException {
        List tags = this.assetEntryPersistence.getAssetTags(entry.getEntryId());
        this.assetEntryPersistence.remove((BaseModel)entry);
        this.assetLinkLocalService.deleteLinks(entry.getEntryId());
        for (AssetTag tag : tags) {
            if (!entry.isVisible()) continue;
            this.assetTagLocalService.decrementAssetCount(tag.getTagId(), entry.getClassNameId());
        }
        this.socialActivityLocalService.deleteActivities(entry);
    }

    public void deleteEntry(long entryId) throws PortalException {
        AssetEntry entry = this.assetEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public void deleteEntry(String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (entry != null) {
            this.deleteEntry(entry);
        }
    }

    public void deleteGroupEntries(long groupId) throws PortalException {
        List<AssetEntry> assetEntries = this.getGroupEntries(groupId);
        for (AssetEntry assetEntry : assetEntries) {
            this.deleteEntry(assetEntry);
        }
    }

    public AssetEntry fetchEntry(long entryId) {
        return this.assetEntryPersistence.fetchByPrimaryKey(entryId);
    }

    public AssetEntry fetchEntry(long groupId, String classUuid) {
        return this.assetEntryPersistence.fetchByG_CU(groupId, classUuid);
    }

    public AssetEntry fetchEntry(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
    }

    public List<AssetEntry> getAncestorEntries(long entryId) throws PortalException {
        ArrayList<AssetEntry> entries = new ArrayList<AssetEntry>();
        AssetEntry parentEntry = this.getParentEntry(entryId);
        while (parentEntry != null) {
            entries.add(parentEntry);
            parentEntry = this.getParentEntry(parentEntry.getEntryId());
        }
        return entries;
    }

    public List<AssetEntry> getChildEntries(long entryId) throws PortalException {
        ArrayList<AssetEntry> entries = new ArrayList<AssetEntry>();
        List links = this.assetLinkLocalService.getDirectLinks(entryId, 1);
        for (AssetLink link : links) {
            AssetEntry curAsset = this.getEntry(link.getEntryId2());
            entries.add(curAsset);
        }
        return entries;
    }

    public List<AssetEntry> getCompanyEntries(long companyId, int start, int end) {
        return this.assetEntryPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyEntriesCount(long companyId) {
        return this.assetEntryPersistence.countByCompanyId(companyId);
    }

    public List<AssetEntry> getEntries(AssetEntryQuery entryQuery) {
        return this.assetEntryFinder.findEntries(entryQuery);
    }

    public int getEntriesCount(AssetEntryQuery entryQuery) {
        return this.assetEntryFinder.countEntries(entryQuery);
    }

    public AssetEntry getEntry(long entryId) throws PortalException {
        return this.assetEntryPersistence.findByPrimaryKey(entryId);
    }

    public AssetEntry getEntry(long groupId, String classUuid) throws PortalException {
        return this.assetEntryPersistence.findByG_CU(groupId, classUuid);
    }

    public AssetEntry getEntry(String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.assetEntryPersistence.findByC_C(classNameId, classPK);
    }

    public List<AssetEntry> getGroupEntries(long groupId) {
        return this.assetEntryPersistence.findByGroupId(groupId);
    }

    public AssetEntry getNextEntry(long entryId) throws PortalException {
        try {
            this.getParentEntry(entryId);
        }
        catch (NoSuchEntryException nsee) {
            List<AssetEntry> childEntries = this.getChildEntries(entryId);
            if (childEntries.isEmpty()) {
                throw new NoSuchEntryException("{entryId=" + entryId + "}");
            }
            return childEntries.get(0);
        }
        List links = this.assetLinkLocalService.getDirectLinks(entryId, 1);
        for (int i = 0; i < links.size(); ++i) {
            AssetLink link = (AssetLink)links.get(i);
            if (link.getEntryId2() != entryId) continue;
            if (i + 1 >= links.size()) {
                throw new NoSuchEntryException("{entryId=" + entryId + "}");
            }
            AssetLink nextLink = (AssetLink)links.get(i + 1);
            return this.getEntry(nextLink.getEntryId2());
        }
        throw new NoSuchEntryException("{entryId=" + entryId + "}");
    }

    public AssetEntry getParentEntry(long entryId) throws PortalException {
        List links = this.assetLinkLocalService.getReverseLinks(entryId, 1);
        if (links.isEmpty()) {
            throw new NoSuchEntryException("{entryId=" + entryId + "}");
        }
        AssetLink link = (AssetLink)links.get(0);
        return this.getEntry(link.getEntryId1());
    }

    public AssetEntry getPreviousEntry(long entryId) throws PortalException {
        this.getParentEntry(entryId);
        List links = this.assetLinkLocalService.getDirectLinks(entryId, 1);
        for (int i = 0; i < links.size(); ++i) {
            AssetLink link = (AssetLink)links.get(i);
            if (link.getEntryId2() != entryId) continue;
            if (i == 0) {
                throw new NoSuchEntryException("{entryId=" + entryId + "}");
            }
            AssetLink nextAssetLink = (AssetLink)links.get(i - 1);
            return this.getEntry(nextAssetLink.getEntryId2());
        }
        throw new NoSuchEntryException("{entryId=" + entryId + "}");
    }

    public List<AssetEntry> getTopViewedEntries(String className, boolean asc, int start, int end) {
        return this.getTopViewedEntries(new String[]{className}, asc, start, end);
    }

    public List<AssetEntry> getTopViewedEntries(String[] className, boolean asc, int start, int end) {
        long[] classNameIds = new long[className.length];
        for (int i = 0; i < className.length; ++i) {
            classNameIds[i] = this.classNameLocalService.getClassNameId(className[i]);
        }
        AssetEntryQuery entryQuery = new AssetEntryQuery();
        entryQuery.setClassNameIds(classNameIds);
        entryQuery.setEnd(end);
        entryQuery.setExcludeZeroViewCount(true);
        entryQuery.setOrderByCol1("viewCount");
        entryQuery.setOrderByType1(asc ? "ASC" : "DESC");
        entryQuery.setStart(start);
        return this.assetEntryFinder.findEntries(entryQuery);
    }

    public AssetEntry incrementViewCounter(long userId, String className, long classPK) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.assetEntryLocalService.incrementViewCounter(user.getUserId(), className, classPK, 1);
        AssetEntry assetEntry = this.getEntry(className, classPK);
        if (!user.isDefaultUser()) {
            this.socialActivityLocalService.addActivity(user.getUserId(), assetEntry.getGroupId(), className, classPK, 10001, "", 0L);
        }
        return assetEntry;
    }

    @BufferedIncrement(configuration="AssetEntry", incrementClass=NumberIncrement.class)
    public void incrementViewCounter(long userId, String className, long classPK, int increment) {
        if (ExportImportThreadLocal.isImportInProcess() || classPK <= 0L) {
            return;
        }
        long classNameId = this.classNameLocalService.getClassNameId(className);
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (entry == null) {
            return;
        }
        entry.setViewCount(entry.getViewCount() + increment);
        this.assetEntryPersistence.update((BaseModel)entry);
    }

    public void reindex(List<AssetEntry> entries) throws PortalException {
        for (AssetEntry entry : entries) {
            String className = PortalUtil.getClassName((long)entry.getClassNameId());
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)className);
            indexer.reindex(className, entry.getClassPK());
        }
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, long classTypeId, String keywords, int status, int start, int end) {
        return this.search(companyId, groupIds, userId, className, classTypeId, null, null, null, null, null, status, false, start, end);
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, long classTypeId, String userName, String title, String description, String assetCategoryIds, String assetTagNames, int status, boolean andSearch, int start, int end) {
        try {
            Indexer indexer = AssetSearcher.getInstance();
            AssetSearcher assetSearcher = (AssetSearcher)indexer;
            AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
            assetEntryQuery.setClassNameIds(this.getClassNameIds(companyId, className));
            SearchContext searchContext = new SearchContext();
            searchContext.setAndSearch(andSearch);
            searchContext.setAssetCategoryIds(StringUtil.split((String)assetCategoryIds, (long)0L));
            searchContext.setAssetTagNames(StringUtil.split((String)assetTagNames));
            searchContext.setAttribute("description", (Serializable)((Object)description));
            searchContext.setAttribute("title", (Serializable)((Object)title));
            searchContext.setAttribute("userName", (Serializable)((Object)userName));
            searchContext.setAttribute("paginationType", (Serializable)((Object)"regular"));
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
            if (classTypeId > 0L) {
                searchContext.setClassTypeIds(new long[]{classTypeId});
            }
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            searchContext.setGroupIds(groupIds);
            searchContext.setStart(start);
            searchContext.setUserId(userId);
            QueryConfig queryConfig = searchContext.getQueryConfig();
            queryConfig.setHighlightEnabled(false);
            queryConfig.setScoreEnabled(false);
            assetSearcher.setAssetEntryQuery(assetEntryQuery);
            return assetSearcher.search(searchContext);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    @Deprecated
    public Hits search(long companyId, long[] groupIds, long userId, String className, String keywords, int start, int end) {
        return this.search(companyId, groupIds, userId, className, keywords, -1, start, end);
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, String keywords, int status, int start, int end) {
        return this.search(companyId, groupIds, userId, className, 0L, keywords, status, start, end);
    }

    @Deprecated
    public Hits search(long companyId, long[] groupIds, long userId, String className, String userName, String title, String description, String assetCategoryIds, String assetTagNames, boolean andSearch, int start, int end) {
        return this.search(companyId, groupIds, userId, className, userName, title, description, assetCategoryIds, assetTagNames, -1, andSearch, start, end);
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, String userName, String title, String description, String assetCategoryIds, String assetTagNames, int status, boolean andSearch, int start, int end) {
        return this.search(companyId, groupIds, userId, className, 0L, userName, title, description, assetCategoryIds, assetTagNames, status, andSearch, start, end);
    }

    @Deprecated
    public Hits search(long companyId, long[] groupIds, String className, String keywords, int start, int end) {
        return this.search(companyId, groupIds, 0L, className, keywords, -1, start, end);
    }

    public AssetEntry updateEntry(long userId, long groupId, Date createDate, Date modifiedDate, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Integer priority, boolean sync) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.validate(groupId, className, classTypeId, categoryIds, tagNames);
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        boolean oldVisible = false;
        if (entry != null) {
            oldVisible = entry.isVisible();
        }
        if (modifiedDate == null) {
            modifiedDate = new Date();
        }
        if (entry == null) {
            long entryId = this.counterLocalService.increment();
            entry = this.assetEntryPersistence.create(entryId);
            Group group = this.groupLocalService.getGroup(groupId);
            entry.setCompanyId(group.getCompanyId());
            entry.setUserId(userId);
            User user = this.userPersistence.fetchByPrimaryKey(userId);
            if (user != null) {
                entry.setUserName(user.getFullName());
            } else {
                entry.setUserName("");
            }
            if (createDate == null) {
                createDate = new Date();
            }
            entry.setCreateDate(createDate);
            entry.setModifiedDate(modifiedDate);
            entry.setClassNameId(classNameId);
            entry.setClassPK(classPK);
            entry.setClassUuid(classUuid);
            entry.setVisible(visible);
            entry.setExpirationDate(expirationDate);
            if (priority == null) {
                entry.setPriority(0.0);
            }
            entry.setViewCount(0);
        }
        entry.setGroupId(groupId);
        entry.setModifiedDate(modifiedDate);
        entry.setClassTypeId(classTypeId);
        entry.setVisible(visible);
        entry.setStartDate(startDate);
        entry.setEndDate(endDate);
        entry.setExpirationDate(expirationDate);
        entry.setMimeType(mimeType);
        entry.setTitle(title);
        entry.setDescription(description);
        entry.setSummary(summary);
        entry.setUrl(url);
        entry.setLayoutUuid(layoutUuid);
        entry.setHeight(height);
        entry.setWidth(width);
        if (priority != null) {
            entry.setPriority((double)priority.intValue());
        }
        if (categoryIds != null) {
            this.assetEntryPersistence.setAssetCategories(entry.getEntryId(), categoryIds);
        }
        if (tagNames != null) {
            long siteGroupId = PortalUtil.getSiteGroupId((long)groupId);
            Group siteGroup = this.groupLocalService.getGroup(siteGroupId);
            List tags = this.assetTagLocalService.checkTags(userId, siteGroup, tagNames);
            List oldTags = this.assetEntryPersistence.getAssetTags(entry.getEntryId());
            this.assetEntryPersistence.setAssetTags(entry.getEntryId(), tags);
            if (entry.isVisible()) {
                boolean isNew = entry.isNew();
                this.assetEntryPersistence.updateImpl(entry);
                if (isNew) {
                    for (AssetTag tag : tags) {
                        this.assetTagLocalService.incrementAssetCount(tag.getTagId(), classNameId);
                    }
                } else {
                    for (AssetTag oldTag : oldTags) {
                        if (tags.contains(oldTag)) continue;
                        this.assetTagLocalService.decrementAssetCount(oldTag.getTagId(), classNameId);
                    }
                    for (AssetTag tag : tags) {
                        if (oldTags.contains(tag)) continue;
                        this.assetTagLocalService.incrementAssetCount(tag.getTagId(), classNameId);
                    }
                }
            } else if (oldVisible) {
                for (AssetTag oldTag : oldTags) {
                    this.assetTagLocalService.decrementAssetCount(oldTag.getTagId(), classNameId);
                }
            }
        }
        this.assetEntryPersistence.update((BaseModel)entry);
        if (!sync) {
            return entry;
        }
        if (className.equals(BlogsEntry.class.getName())) {
            BlogsEntry blogsEntry = this.blogsEntryPersistence.findByPrimaryKey(classPK);
            blogsEntry.setTitle(title);
            this.blogsEntryPersistence.update((BaseModel)blogsEntry);
        } else if (className.equals(BookmarksEntry.class.getName())) {
            BookmarksEntry bookmarksEntry = this.bookmarksEntryPersistence.findByPrimaryKey(classPK);
            bookmarksEntry.setName(title);
            bookmarksEntry.setDescription(description);
            bookmarksEntry.setUrl(url);
            this.bookmarksEntryPersistence.update((BaseModel)bookmarksEntry);
        } else if (className.equals(DLFileEntry.class.getName())) {
            DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(classPK);
            String fileName = DLUtil.getSanitizedFileName((String)title, (String)dlFileEntry.getExtension());
            dlFileEntry.setFileName(fileName);
            dlFileEntry.setTitle(title);
            dlFileEntry.setDescription(description);
            this.dlFileEntryPersistence.update((BaseModel)dlFileEntry);
        } else if (className.equals(JournalArticle.class.getName())) {
            JournalArticle journalArticle = this.journalArticlePersistence.findByPrimaryKey(classPK);
            journalArticle.setTitle(title);
            journalArticle.setDescription(description);
            this.journalArticlePersistence.update((BaseModel)journalArticle);
        } else if (className.equals(MBMessage.class.getName())) {
            MBMessage mbMessage = this.mbMessagePersistence.findByPrimaryKey(classPK);
            mbMessage.setSubject(title);
            this.mbMessagePersistence.update((BaseModel)mbMessage);
        } else if (className.equals(WikiPage.class.getName())) {
            WikiPage wikiPage = this.wikiPagePersistence.findByPrimaryKey(classPK);
            wikiPage.setTitle(title);
            this.wikiPagePersistence.update((BaseModel)wikiPage);
        }
        return entry;
    }

    public AssetEntry updateEntry(long userId, long groupId, String className, long classPK, long[] categoryIds, String[] tagNames) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (entry != null) {
            return this.updateEntry(userId, groupId, entry.getCreateDate(), entry.getModifiedDate(), className, classPK, entry.getClassUuid(), entry.getClassTypeId(), categoryIds, tagNames, entry.isVisible(), entry.getStartDate(), entry.getEndDate(), entry.getExpirationDate(), entry.getMimeType(), entry.getTitle(), entry.getDescription(), entry.getSummary(), entry.getUrl(), entry.getLayoutUuid(), entry.getHeight(), entry.getWidth(), GetterUtil.getInteger((Object)entry.getPriority()), false);
        }
        return this.updateEntry(userId, groupId, null, null, className, classPK, null, 0L, categoryIds, tagNames, true, null, null, null, null, null, null, null, null, null, 0, 0, null, false);
    }

    @Deprecated
    public AssetEntry updateEntry(long userId, long groupId, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Integer priority, boolean sync) throws PortalException {
        return this.updateEntry(userId, groupId, className, classPK, classUuid, classTypeId, categoryIds, tagNames, visible, startDate, endDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority, sync);
    }

    @Deprecated
    public AssetEntry updateEntry(long userId, long groupId, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Integer priority, boolean sync) throws PortalException {
        return this.updateEntry(userId, groupId, null, null, className, classPK, classUuid, classTypeId, categoryIds, tagNames, visible, startDate, endDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority, sync);
    }

    public AssetEntry updateEntry(String className, long classPK, Date publishDate, boolean visible) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        AssetEntry entry = this.assetEntryPersistence.findByC_C(classNameId, classPK);
        entry.setPublishDate(publishDate);
        return this.updateVisible(entry, visible);
    }

    public AssetEntry updateEntry(String className, long classPK, Date publishDate, Date expirationDate, boolean visible) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        AssetEntry entry = this.assetEntryPersistence.findByC_C(classNameId, classPK);
        entry.setExpirationDate(expirationDate);
        entry.setPublishDate(publishDate);
        return this.updateVisible(entry, visible);
    }

    public AssetEntry updateVisible(String className, long classPK, boolean visible) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        AssetEntry entry = this.assetEntryPersistence.findByC_C(classNameId, classPK);
        return this.updateVisible(entry, visible);
    }

    public void validate(long groupId, String className, long classTypePK, long[] categoryIds, String[] tagNames) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        AssetEntryValidator validator = (AssetEntryValidator)InstancePool.get((String)PropsValues.ASSET_ENTRY_VALIDATOR);
        validator.validate(groupId, className, classTypePK, categoryIds, tagNames);
    }

    @Deprecated
    public void validate(long groupId, String className, long[] categoryIds, String[] tagNames) throws PortalException {
        this.validate(groupId, className, -1L, categoryIds, tagNames);
    }

    protected long[] getClassNameIds(long companyId, String className) {
        if (Validator.isNotNull((String)className)) {
            return new long[]{this.classNameLocalService.getClassNameId(className)};
        }
        List rendererFactories = AssetRendererFactoryRegistryUtil.getAssetRendererFactories((long)companyId);
        long[] classNameIds = new long[rendererFactories.size()];
        for (int i = 0; i < rendererFactories.size(); ++i) {
            AssetRendererFactory rendererFactory = (AssetRendererFactory)rendererFactories.get(i);
            classNameIds[i] = this.classNameLocalService.getClassNameId(rendererFactory.getClassName());
        }
        return classNameIds;
    }

    protected AssetEntry getEntry(Document document) throws PortalException {
        String portletId = GetterUtil.getString((String)document.get("portletId"));
        if (portletId.equals("33")) {
            long entryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            long classNameId = this.classNameLocalService.getClassNameId(BlogsEntry.class.getName());
            long classPK = entryId;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("28")) {
            long entryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            long classNameId = this.classNameLocalService.getClassNameId(BookmarksEntry.class.getName());
            long classPK = entryId;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("20")) {
            long fileEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            long classNameId = this.classNameLocalService.getClassNameId(DLFileEntry.class.getName());
            long classPK = fileEntryId;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("15")) {
            long groupId = GetterUtil.getLong((String)document.get("groupId"));
            String articleId = document.get("articleId");
            long articleResourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, articleId);
            long classNameId = this.classNameLocalService.getClassNameId(JournalArticle.class.getName());
            long classPK = articleResourcePrimKey;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("19")) {
            long messageId = GetterUtil.getLong((String)document.get("entryClassPK"));
            long classNameId = this.classNameLocalService.getClassNameId(MBMessage.class.getName());
            long classPK = messageId;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("36")) {
            long nodeId = GetterUtil.getLong((String)document.get("entryClassPK"));
            String title = document.get("title");
            long pageResourcePrimKey = this.wikiPageResourceLocalService.getPageResourcePrimKey(nodeId, title);
            long classNameId = this.classNameLocalService.getClassNameId(WikiPage.class.getName());
            long classPK = pageResourcePrimKey;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        return null;
    }

    protected AssetEntry updateVisible(AssetEntry entry, boolean visible) throws PortalException {
        if (visible == entry.isVisible()) {
            return (AssetEntry)this.assetEntryPersistence.update((BaseModel)entry);
        }
        entry.setVisible(visible);
        this.assetEntryPersistence.update((BaseModel)entry);
        List tags = this.assetEntryPersistence.getAssetTags(entry.getEntryId());
        if (visible) {
            for (AssetTag tag : tags) {
                this.assetTagLocalService.incrementAssetCount(tag.getTagId(), entry.getClassNameId());
            }
            this.socialActivityCounterLocalService.enableActivityCounters(entry.getClassNameId(), entry.getClassPK());
        } else {
            for (AssetTag tag : tags) {
                this.assetTagLocalService.decrementAssetCount(tag.getTagId(), entry.getClassNameId());
            }
            this.socialActivityCounterLocalService.disableActivityCounters(entry.getClassNameId(), entry.getClassPK());
        }
        return entry;
    }
}

