/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetCategoryDisplay;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.base.AssetCategoryServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.util.Autocomplete;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetCategoryServiceImpl
extends AssetCategoryServiceBaseImpl {
    public AssetCategory addCategory(long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentCategoryId, "ADD_CATEGORY");
        return this.assetCategoryLocalService.addCategory(this.getUserId(), parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }

    public AssetCategory addCategory(String title, long vocabularyId, ServiceContext serviceContext) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), 0L, "ADD_CATEGORY");
        return this.assetCategoryLocalService.addCategory(this.getUserId(), title, vocabularyId, serviceContext);
    }

    @Deprecated
    public void deleteCategories(long[] categoryIds) throws PortalException {
        this.deleteCategories(categoryIds, null);
    }

    public List<AssetCategory> deleteCategories(long[] categoryIds, ServiceContext serviceContext) throws PortalException {
        ArrayList<AssetCategory> failedCategories = new ArrayList<AssetCategory>();
        for (long categoryId : categoryIds) {
            try {
                AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "DELETE");
                this.assetCategoryLocalService.deleteCategory(categoryId);
            }
            catch (PortalException pe) {
                if (serviceContext == null) {
                    return null;
                }
                if (serviceContext.isFailOnPortalException()) {
                    throw pe;
                }
                AssetCategory category = this.assetCategoryPersistence.fetchByPrimaryKey(categoryId);
                if (category == null) {
                    category = this.assetCategoryPersistence.create(categoryId);
                }
                failedCategories.add(category);
            }
        }
        return failedCategories;
    }

    public void deleteCategory(long categoryId) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "DELETE");
        this.assetCategoryLocalService.deleteCategory(categoryId);
    }

    public List<AssetCategory> getCategories(String className, long classPK) throws PortalException {
        return this.filterCategories(this.assetCategoryLocalService.getCategories(className, classPK));
    }

    public AssetCategory getCategory(long categoryId) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "VIEW");
        return this.assetCategoryLocalService.getCategory(categoryId);
    }

    public String getCategoryPath(long categoryId) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "VIEW");
        AssetCategory category = this.getCategory(categoryId);
        return category.getPath(LocaleUtil.getMostRelevantLocale());
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId) throws PortalException {
        return this.filterCategories(this.assetCategoryLocalService.getChildCategories(parentCategoryId));
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId, int start, int end, OrderByComparator<AssetCategory> obc) throws PortalException {
        return this.filterCategories(this.assetCategoryLocalService.getChildCategories(parentCategoryId, start, end, obc));
    }

    @Deprecated
    public JSONArray getJSONSearch(long groupId, String name, long[] vocabularyIds, int start, int end) throws PortalException {
        return this.search(new long[]{groupId}, name, vocabularyIds, start, end);
    }

    @Deprecated
    public JSONObject getJSONVocabularyCategories(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        List<AssetCategory> categories = this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(vocabularyId, start, end, obc));
        jsonObject.put("categories", this.toJSONArray(categories));
        jsonObject.put("total", categories.size());
        return jsonObject;
    }

    @Deprecated
    public JSONObject getJSONVocabularyCategories(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws PortalException {
        List<AssetCategory> categories;
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        int page = 0;
        if (end > 0 && start > 0) {
            page = end / (end - start);
        }
        jsonObject.put("page", page);
        int total = 0;
        if (Validator.isNotNull((String)name)) {
            name = CustomSQLUtil.keywords((String)name)[0];
            categories = this.getVocabularyCategories(groupId, name, vocabularyId, start, end, obc);
            total = this.getVocabularyCategoriesCount(groupId, name, vocabularyId);
        } else {
            categories = this.getVocabularyCategories(vocabularyId, start, end, obc);
            total = this.getVocabularyCategoriesCount(groupId, vocabularyId);
        }
        jsonObject.put("categories", this.toJSONArray(categories));
        jsonObject.put("total", total);
        return jsonObject;
    }

    public List<AssetCategory> getVocabularyCategories(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws PortalException {
        return this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(vocabularyId, start, end, obc));
    }

    public List<AssetCategory> getVocabularyCategories(long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws PortalException {
        return this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(parentCategoryId, vocabularyId, start, end, obc));
    }

    public List<AssetCategory> getVocabularyCategories(long groupId, long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        return this.assetCategoryPersistence.filterFindByG_P_V(groupId, parentCategoryId, vocabularyId, start, end, obc);
    }

    public List<AssetCategory> getVocabularyCategories(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        if (Validator.isNull((String)name)) {
            return this.assetCategoryPersistence.filterFindByG_V(groupId, vocabularyId, start, end, obc);
        }
        return this.assetCategoryPersistence.filterFindByG_LikeN_V(groupId, name, vocabularyId, start, end, obc);
    }

    public int getVocabularyCategoriesCount(long groupId, long vocabularyId) {
        return this.assetCategoryPersistence.filterCountByG_V(groupId, vocabularyId);
    }

    public int getVocabularyCategoriesCount(long groupId, long parentCategory, long vocabularyId) {
        return this.assetCategoryPersistence.filterCountByG_P_V(groupId, parentCategory, vocabularyId);
    }

    public int getVocabularyCategoriesCount(long groupId, String name, long vocabularyId) {
        if (Validator.isNull((String)name)) {
            return this.assetCategoryPersistence.filterCountByG_V(groupId, vocabularyId);
        }
        return this.assetCategoryPersistence.filterCountByG_LikeN_V(groupId, name, vocabularyId);
    }

    public AssetCategoryDisplay getVocabularyCategoriesDisplay(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws PortalException {
        List<AssetCategory> categories = this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(vocabularyId, start, end, obc));
        return new AssetCategoryDisplay(categories, categories.size(), start, end);
    }

    public AssetCategoryDisplay getVocabularyCategoriesDisplay(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws PortalException {
        List<AssetCategory> categories = null;
        int total = 0;
        if (Validator.isNotNull((String)name)) {
            name = CustomSQLUtil.keywords((String)name)[0];
            categories = this.getVocabularyCategories(groupId, name, vocabularyId, start, end, obc);
            total = this.getVocabularyCategoriesCount(groupId, name, vocabularyId);
        } else {
            categories = this.getVocabularyCategories(vocabularyId, start, end, obc);
            total = this.getVocabularyCategoriesCount(groupId, vocabularyId);
        }
        return new AssetCategoryDisplay(categories, total, start, end);
    }

    @Deprecated
    public List<AssetCategory> getVocabularyRootCategories(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws PortalException {
        AssetVocabulary vocabulary = this.assetVocabularyLocalService.getVocabulary(vocabularyId);
        return this.getVocabularyRootCategories(vocabulary.getGroupId(), vocabularyId, start, end, obc);
    }

    public List<AssetCategory> getVocabularyRootCategories(long groupId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        return this.assetCategoryPersistence.filterFindByG_P_V(groupId, 0L, vocabularyId, start, end, obc);
    }

    public int getVocabularyRootCategoriesCount(long groupId, long vocabularyId) {
        return this.assetCategoryPersistence.filterCountByG_P_V(groupId, 0L, vocabularyId);
    }

    public AssetCategory moveCategory(long categoryId, long parentCategoryId, long vocabularyId, ServiceContext serviceContext) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "UPDATE");
        return this.assetCategoryLocalService.moveCategory(categoryId, parentCategoryId, vocabularyId, serviceContext);
    }

    public List<AssetCategory> search(long groupId, String keywords, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        String name = CustomSQLUtil.keywords((String)keywords)[0];
        if (Validator.isNull((String)name)) {
            return this.assetCategoryPersistence.filterFindByG_V(groupId, vocabularyId, start, end, obc);
        }
        return this.assetCategoryPersistence.filterFindByG_LikeN_V(groupId, name, vocabularyId, start, end, obc);
    }

    public JSONArray search(long groupId, String name, String[] categoryProperties, int start, int end) throws PortalException {
        List<AssetCategory> categories = this.assetCategoryLocalService.search(groupId, name, categoryProperties, start, end);
        categories = this.filterCategories(categories);
        return Autocomplete.listToJson(categories, (String)"name", (String)"name");
    }

    public JSONArray search(long[] groupIds, String name, long[] vocabularyIds, int start, int end) throws PortalException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (long groupId : groupIds) {
            JSONArray categoriesJSONArray = null;
            categoriesJSONArray = Validator.isNull((String)name) ? this.toJSONArray(this.assetCategoryPersistence.filterFindByG_V(groupId, vocabularyIds)) : this.toJSONArray(this.assetCategoryPersistence.filterFindByG_LikeN_V(groupId, name, vocabularyIds));
            for (int j = 0; j < categoriesJSONArray.length(); ++j) {
                jsonArray.put(categoriesJSONArray.getJSONObject(j));
            }
        }
        return jsonArray;
    }

    public AssetCategoryDisplay searchCategoriesDisplay(long groupId, String title, long vocabularyId, int start, int end) throws PortalException {
        return this.searchCategoriesDisplay(new long[]{groupId}, title, new long[]{vocabularyId}, start, end);
    }

    public AssetCategoryDisplay searchCategoriesDisplay(long groupId, String title, long parentCategoryId, long vocabularyId, int start, int end) throws PortalException {
        return this.searchCategoriesDisplay(new long[]{groupId}, title, new long[]{parentCategoryId}, new long[]{vocabularyId}, start, end);
    }

    public AssetCategoryDisplay searchCategoriesDisplay(long[] groupIds, String title, long[] vocabularyIds, int start, int end) throws PortalException {
        User user = this.getUser();
        BaseModelSearchResult baseModelSearchResult = this.assetCategoryLocalService.searchCategories(user.getCompanyId(), groupIds, title, vocabularyIds, start, end);
        return new AssetCategoryDisplay(baseModelSearchResult.getBaseModels(), baseModelSearchResult.getLength(), start, end);
    }

    public AssetCategoryDisplay searchCategoriesDisplay(long[] groupIds, String title, long[] parentCategoryIds, long[] vocabularyIds, int start, int end) throws PortalException {
        User user = this.getUser();
        BaseModelSearchResult baseModelSearchResult = this.assetCategoryLocalService.searchCategories(user.getCompanyId(), groupIds, title, parentCategoryIds, vocabularyIds, start, end);
        return new AssetCategoryDisplay(baseModelSearchResult.getBaseModels(), baseModelSearchResult.getLength(), start, end);
    }

    public AssetCategory updateCategory(long categoryId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "UPDATE");
        return this.assetCategoryLocalService.updateCategory(this.getUserId(), categoryId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }

    protected List<AssetCategory> filterCategories(List<AssetCategory> categories) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        categories = ListUtil.copy(categories);
        Iterator itr = categories.iterator();
        while (itr.hasNext()) {
            AssetCategory category = (AssetCategory)itr.next();
            if (AssetCategoryPermission.contains(permissionChecker, category, "VIEW")) continue;
            itr.remove();
        }
        return categories;
    }

    protected JSONArray toJSONArray(List<AssetCategory> categories) throws PortalException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (AssetCategory category : categories) {
            String categoryJSON = JSONFactoryUtil.looseSerialize((Object)category);
            JSONObject categoryJSONObject = JSONFactoryUtil.createJSONObject((String)categoryJSON);
            categoryJSONObject.put("path", this.getCategoryPath(category.getCategoryId()));
            jsonArray.put(categoryJSONObject);
        }
        return jsonArray;
    }
}

