/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.cache.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.AssetCategoryNameException;
import com.liferay.portlet.asset.DuplicateCategoryException;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetCategoryProperty;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.service.base.AssetCategoryLocalServiceBaseImpl;
import com.liferay.portlet.asset.util.AssetCategoryUtil;
import com.liferay.portlet.asset.util.comparator.AssetCategoryLeftCategoryIdComparator;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;

public class AssetCategoryLocalServiceImpl
extends AssetCategoryLocalServiceBaseImpl {
    @Indexable(type=IndexableType.REINDEX)
    public AssetCategory addCategory(long userId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        String name = titleMap.get(LocaleUtil.getSiteDefault());
        name = ModelHintsUtil.trimString((String)AssetCategory.class.getName(), (String)"name", (String)name);
        if (categoryProperties == null) {
            categoryProperties = new String[]{};
        }
        Date now = new Date();
        this.validate(0L, parentCategoryId, name, vocabularyId);
        if (parentCategoryId > 0L) {
            this.assetCategoryPersistence.findByPrimaryKey(parentCategoryId);
        }
        this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        long categoryId = this.counterLocalService.increment();
        AssetCategory category = this.assetCategoryPersistence.create(categoryId);
        category.setUuid(serviceContext.getUuid());
        category.setGroupId(groupId);
        category.setCompanyId(user.getCompanyId());
        category.setUserId(user.getUserId());
        category.setUserName(user.getFullName());
        category.setCreateDate(now);
        category.setModifiedDate(now);
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setTitleMap(titleMap);
        category.setDescriptionMap(descriptionMap);
        category.setVocabularyId(vocabularyId);
        this.assetCategoryPersistence.update((BaseModel)category);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addCategoryResources(category, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addCategoryResources(category, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        for (int i = 0; i < categoryProperties.length; ++i) {
            String[] categoryProperty = StringUtil.split((String)categoryProperties[i], (String)"_KEY_VALUE_");
            if (categoryProperty.length <= 1) {
                categoryProperty = StringUtil.split((String)categoryProperties[i], (char)':');
            }
            String key = "";
            String value = "";
            if (categoryProperty.length > 1) {
                key = GetterUtil.getString((String)categoryProperty[0]);
                value = GetterUtil.getString((String)categoryProperty[1]);
            }
            if (!Validator.isNotNull((String)key)) continue;
            this.assetCategoryPropertyLocalService.addCategoryProperty(userId, categoryId, key, value);
        }
        return category;
    }

    public AssetCategory addCategory(long userId, String title, long vocabularyId, ServiceContext serviceContext) throws PortalException {
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        Locale locale = LocaleUtil.getSiteDefault();
        titleMap.put(locale, title);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, "");
        return this.assetCategoryLocalService.addCategory(userId, 0L, titleMap, descriptionMap, vocabularyId, null, serviceContext);
    }

    public void addCategoryResources(AssetCategory category, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), AssetCategory.class.getName(), category.getCategoryId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(AssetCategory category, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), AssetCategory.class.getName(), category.getCategoryId(), groupPermissions, guestPermissions);
    }

    @SystemEvent(type=1)
    public AssetCategory deleteCategory(AssetCategory category) throws PortalException {
        return this.assetCategoryLocalService.deleteCategory(category, false);
    }

    @Indexable(type=IndexableType.DELETE)
    public AssetCategory deleteCategory(AssetCategory category, boolean childCategory) throws PortalException {
        List categories = this.assetCategoryPersistence.findByParentCategoryId(category.getCategoryId());
        for (AssetCategory curCategory : categories) {
            this.deleteCategory(curCategory, true);
        }
        if (!categories.isEmpty() && !childCategory) {
            final long groupId = category.getGroupId();
            TransactionCommitCallbackRegistryUtil.registerCallback((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    AssetCategoryLocalServiceImpl.this.assetCategoryLocalService.rebuildTree(groupId, true);
                    return null;
                }
            });
        }
        this.assetCategoryPersistence.remove((BaseModel)category);
        this.resourceLocalService.deleteResource(category.getCompanyId(), AssetCategory.class.getName(), 4, category.getCategoryId());
        List entries = this.assetTagPersistence.getAssetEntries(category.getCategoryId());
        this.assetCategoryPropertyLocalService.deleteCategoryProperties(category.getCategoryId());
        this.assetEntryLocalService.reindex(entries);
        return category;
    }

    public AssetCategory deleteCategory(long categoryId) throws PortalException {
        AssetCategory category = this.assetCategoryPersistence.findByPrimaryKey(categoryId);
        return this.assetCategoryLocalService.deleteCategory(category);
    }

    public void deleteVocabularyCategories(long vocabularyId) throws PortalException {
        List categories = this.assetCategoryPersistence.findByP_V(0L, vocabularyId, -1, -1, (OrderByComparator)new AssetCategoryLeftCategoryIdComparator(false));
        for (AssetCategory category : categories) {
            this.assetCategoryLocalService.deleteCategory(category);
        }
    }

    public AssetCategory fetchCategory(long categoryId) {
        return this.assetCategoryPersistence.fetchByPrimaryKey(categoryId);
    }

    public List<AssetCategory> getCategories() {
        return this.assetCategoryPersistence.findAll();
    }

    @ThreadLocalCachable
    public List<AssetCategory> getCategories(long classNameId, long classPK) {
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (entry == null) {
            return Collections.emptyList();
        }
        return this.assetEntryPersistence.getAssetCategories(entry.getEntryId());
    }

    public List<AssetCategory> getCategories(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getCategories(classNameId, classPK);
    }

    public AssetCategory getCategory(long categoryId) throws PortalException {
        return this.assetCategoryPersistence.findByPrimaryKey(categoryId);
    }

    public AssetCategory getCategory(String uuid, long groupId) throws PortalException {
        return this.assetCategoryPersistence.findByUUID_G(uuid, groupId);
    }

    public long[] getCategoryIds(String className, long classPK) {
        return this.getCategoryIds(this.getCategories(className, classPK));
    }

    public String[] getCategoryNames() {
        return this.getCategoryNames(this.getCategories());
    }

    public String[] getCategoryNames(long classNameId, long classPK) {
        return this.getCategoryNames(this.getCategories(classNameId, classPK));
    }

    public String[] getCategoryNames(String className, long classPK) {
        return this.getCategoryNames(this.getCategories(className, classPK));
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId) {
        return this.assetCategoryPersistence.findByParentCategoryId(parentCategoryId);
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId, int start, int end, OrderByComparator<AssetCategory> obc) {
        return this.assetCategoryPersistence.findByParentCategoryId(parentCategoryId, start, end, obc);
    }

    public int getChildCategoriesCount(long parentCategoryId) {
        return this.assetCategoryPersistence.countByParentCategoryId(parentCategoryId);
    }

    public List<AssetCategory> getEntryCategories(long entryId) {
        return this.assetEntryPersistence.getAssetCategories(entryId);
    }

    public List<Long> getSubcategoryIds(long parentCategoryId) {
        AssetCategory parentAssetCategory = this.assetCategoryPersistence.fetchByPrimaryKey(parentCategoryId);
        if (parentAssetCategory == null) {
            return Collections.emptyList();
        }
        return ListUtil.toList((List)this.assetCategoryPersistence.getDescendants(parentAssetCategory), (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
    }

    public List<AssetCategory> getVocabularyCategories(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        return this.assetCategoryPersistence.findByVocabularyId(vocabularyId, start, end, obc);
    }

    public List<AssetCategory> getVocabularyCategories(long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        return this.assetCategoryPersistence.findByP_V(parentCategoryId, vocabularyId, start, end, obc);
    }

    public int getVocabularyCategoriesCount(long vocabularyId) {
        return this.assetCategoryPersistence.countByVocabularyId(vocabularyId);
    }

    public List<AssetCategory> getVocabularyRootCategories(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        return this.getVocabularyCategories(0L, vocabularyId, start, end, obc);
    }

    public int getVocabularyRootCategoriesCount(long vocabularyId) {
        return this.assetCategoryPersistence.countByP_V(0L, vocabularyId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetCategory mergeCategories(long fromCategoryId, long toCategoryId) throws PortalException {
        List entries = this.assetCategoryPersistence.getAssetEntries(fromCategoryId);
        this.assetCategoryPersistence.addAssetEntries(toCategoryId, entries);
        List categoryProperties = this.assetCategoryPropertyPersistence.findByCategoryId(fromCategoryId);
        for (AssetCategoryProperty fromCategoryProperty : categoryProperties) {
            AssetCategoryProperty toCategoryProperty = this.assetCategoryPropertyPersistence.fetchByCA_K(toCategoryId, fromCategoryProperty.getKey());
            if (toCategoryProperty != null) continue;
            fromCategoryProperty.setCategoryId(toCategoryId);
            this.assetCategoryPropertyPersistence.update((BaseModel)fromCategoryProperty);
        }
        this.assetCategoryLocalService.deleteCategory(fromCategoryId);
        return this.getCategory(toCategoryId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetCategory moveCategory(long categoryId, long parentCategoryId, long vocabularyId, ServiceContext serviceContext) throws PortalException {
        AssetCategory category = this.assetCategoryPersistence.findByPrimaryKey(categoryId);
        this.validate(categoryId, parentCategoryId, category.getName(), vocabularyId);
        if (parentCategoryId > 0L) {
            this.assetCategoryPersistence.findByPrimaryKey(parentCategoryId);
        }
        if (vocabularyId != category.getVocabularyId()) {
            this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
            category.setVocabularyId(vocabularyId);
            this.updateChildrenVocabularyId(category, vocabularyId);
        }
        category.setModifiedDate(new Date());
        category.setParentCategoryId(parentCategoryId);
        this.assetCategoryPersistence.update((BaseModel)category);
        return category;
    }

    public void rebuildTree(long groupId, boolean force) {
        this.assetCategoryPersistence.rebuildTree(groupId, force);
    }

    public List<AssetCategory> search(long groupId, String name, String[] categoryProperties, int start, int end) {
        return this.assetCategoryFinder.findByG_N_P(groupId, name, categoryProperties, start, end);
    }

    public BaseModelSearchResult<AssetCategory> searchCategories(long companyId, long groupIds, String title, long vocabularyId, int start, int end) throws PortalException {
        return this.searchCategories(companyId, new long[]{groupIds}, title, new long[]{vocabularyId}, start, end);
    }

    public BaseModelSearchResult<AssetCategory> searchCategories(long companyId, long[] groupIds, String title, long[] vocabularyIds, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, title, new long[0], vocabularyIds, start, end);
        return this.searchCategories(searchContext);
    }

    public BaseModelSearchResult<AssetCategory> searchCategories(long companyId, long[] groupIds, String title, long[] parentCategoryIds, long[] vocabularyIds, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, title, parentCategoryIds, vocabularyIds, start, end);
        return this.searchCategories(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetCategory updateCategory(long userId, long categoryId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        String name = titleMap.get(LocaleUtil.getSiteDefault());
        name = ModelHintsUtil.trimString((String)AssetCategory.class.getName(), (String)"name", (String)name);
        if (categoryProperties == null) {
            categoryProperties = new String[]{};
        }
        this.validate(categoryId, parentCategoryId, name, vocabularyId);
        if (parentCategoryId > 0L) {
            this.assetCategoryPersistence.findByPrimaryKey(parentCategoryId);
        }
        AssetCategory category = this.assetCategoryPersistence.findByPrimaryKey(categoryId);
        String oldName = category.getName();
        if (vocabularyId != category.getVocabularyId()) {
            this.assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
            parentCategoryId = 0L;
            category.setVocabularyId(vocabularyId);
            this.updateChildrenVocabularyId(category, vocabularyId);
        }
        category.setModifiedDate(new Date());
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setTitleMap(titleMap);
        category.setDescriptionMap(descriptionMap);
        this.assetCategoryPersistence.update((BaseModel)category);
        List oldCategoryProperties = this.assetCategoryPropertyPersistence.findByCategoryId(categoryId);
        oldCategoryProperties = ListUtil.copy((List)oldCategoryProperties);
        for (int i = 0; i < categoryProperties.length; ++i) {
            String[] categoryProperty = StringUtil.split((String)categoryProperties[i], (String)"_KEY_VALUE_");
            if (categoryProperty.length <= 1) {
                categoryProperty = StringUtil.split((String)categoryProperties[i], (char)':');
            }
            String key = "";
            if (categoryProperty.length > 0) {
                key = GetterUtil.getString((String)categoryProperty[0]);
            }
            String value = "";
            if (categoryProperty.length > 1) {
                value = GetterUtil.getString((String)categoryProperty[1]);
            }
            if (!Validator.isNotNull((String)key)) continue;
            boolean addCategoryProperty = true;
            AssetCategoryProperty oldCategoryProperty = null;
            Iterator iterator = oldCategoryProperties.iterator();
            while (iterator.hasNext()) {
                oldCategoryProperty = (AssetCategoryProperty)iterator.next();
                if (categoryId != oldCategoryProperty.getCategoryId() || !key.equals(oldCategoryProperty.getKey())) continue;
                addCategoryProperty = false;
                if (!value.equals(oldCategoryProperty.getValue())) {
                    this.assetCategoryPropertyLocalService.updateCategoryProperty(userId, oldCategoryProperty.getCategoryPropertyId(), key, value);
                }
                iterator.remove();
                break;
            }
            if (!addCategoryProperty) continue;
            this.assetCategoryPropertyLocalService.addCategoryProperty(userId, categoryId, key, value);
        }
        for (String[] categoryProperty : oldCategoryProperties) {
            this.assetCategoryPropertyLocalService.deleteAssetCategoryProperty((AssetCategoryProperty)categoryProperty);
        }
        if (!oldName.equals(name)) {
            List entries = this.assetCategoryPersistence.getAssetEntries(category.getCategoryId());
            this.assetEntryLocalService.reindex(entries);
        }
        return category;
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, String title, long[] parentCategoryIds, long[] vocabularyIds, int start, int end) {
        SearchContext searchContext = new SearchContext();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("parentCategoryIds", parentCategoryIds);
        attributes.put("assetVocabularyIds", vocabularyIds);
        attributes.put("title", title);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        searchContext.setKeywords(title);
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected long[] getCategoryIds(List<AssetCategory> categories) {
        return ListUtil.toLongArray(categories, (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
    }

    protected String[] getCategoryNames(List<AssetCategory> categories) {
        return (String[])ListUtil.toArray(categories, (Accessor)AssetCategory.NAME_ACCESSOR);
    }

    protected BaseModelSearchResult<AssetCategory> searchCategories(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetCategory.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<AssetCategory> categories = AssetCategoryUtil.getCategories(hits);
            if (categories == null) continue;
            return new BaseModelSearchResult(categories, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void updateChildrenVocabularyId(AssetCategory category, long vocabularyId) {
        List childrenCategories = this.assetCategoryPersistence.findByParentCategoryId(category.getCategoryId());
        if (!childrenCategories.isEmpty()) {
            for (AssetCategory childCategory : childrenCategories) {
                childCategory.setVocabularyId(vocabularyId);
                childCategory.setModifiedDate(new Date());
                this.assetCategoryPersistence.update((BaseModel)childCategory);
                this.updateChildrenVocabularyId(childCategory, vocabularyId);
            }
        }
    }

    protected void validate(long categoryId, long parentCategoryId, String name, long vocabularyId) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new AssetCategoryNameException();
        }
        AssetCategory category = this.assetCategoryPersistence.fetchByP_N_V(parentCategoryId, name, vocabularyId);
        if (category != null && category.getCategoryId() != categoryId) {
            StringBundler sb = new StringBundler(4);
            sb.append("There is another category named ");
            sb.append(name);
            sb.append(" as a child of category ");
            sb.append(parentCategoryId);
            throw new DuplicateCategoryException(sb.toString());
        }
    }
}

