/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.model.impl.AssetVocabularyBaseImpl;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.util.List;
import java.util.Locale;

public class AssetVocabularyImpl
extends AssetVocabularyBaseImpl {
    private AssetVocabularySettingsHelper _vocabularySettingsHelper;

    public List<AssetCategory> getCategories() {
        return AssetCategoryLocalServiceUtil.getVocabularyCategories((long)this.getVocabularyId(), (int)-1, (int)-1, null);
    }

    public int getCategoriesCount() {
        return AssetCategoryLocalServiceUtil.getVocabularyCategoriesCount((long)this.getVocabularyId());
    }

    public long[] getRequiredClassNameIds() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.getRequiredClassNameIds();
    }

    public long[] getSelectedClassNameIds() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.getClassNameIds();
    }

    public long[] getSelectedClassTypePKs() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.getClassTypePKs();
    }

    @Override
    public String getSettings() {
        if (this._vocabularySettingsHelper == null) {
            return super.getSettings();
        }
        return this._vocabularySettingsHelper.toString();
    }

    @Deprecated
    public UnicodeProperties getSettingsProperties() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        UnicodeProperties settingsProperties = new UnicodeProperties(true);
        settingsProperties.fastLoad(vocabularySettingsHelper.toString());
        return settingsProperties;
    }

    @Override
    public String getTitle(String languageId) {
        String value = super.getTitle(languageId);
        if (Validator.isNull((String)value)) {
            value = this.getName();
        }
        return value;
    }

    @Override
    public String getTitle(String languageId, boolean useDefault) {
        String value = super.getTitle(languageId, useDefault);
        if (Validator.isNull((String)value)) {
            value = this.getName();
        }
        return value;
    }

    public String getUnambiguousTitle(List<AssetVocabulary> vocabularies, long groupId, final Locale locale) throws PortalException {
        if (this.getGroupId() == groupId) {
            return this.getTitle(locale);
        }
        boolean hasAmbiguousTitle = ListUtil.exists(vocabularies, (PredicateFilter)new PredicateFilter<AssetVocabulary>(){

            public boolean filter(AssetVocabulary vocabulary) {
                String title = vocabulary.getTitle(locale);
                return title.equals(AssetVocabularyImpl.this.getTitle(locale)) && vocabulary.getVocabularyId() != AssetVocabularyImpl.this.getVocabularyId();
            }
        });
        if (hasAmbiguousTitle) {
            Group group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
            return group.getUnambiguousName(this.getTitle(locale), locale);
        }
        return this.getTitle(locale);
    }

    public boolean hasMoreThanOneCategorySelected(final long[] categoryIds) {
        PredicateFilter<AssetCategory> predicateFilter = new PredicateFilter<AssetCategory>(){

            public boolean filter(AssetCategory assetCategory) {
                return ArrayUtil.contains((long[])categoryIds, (long)assetCategory.getCategoryId());
            }
        };
        return ListUtil.count(this.getCategories(), (PredicateFilter)predicateFilter) > 1;
    }

    public boolean isAssociatedToClassNameId(long classNameId) {
        return this.isAssociatedToClassNameIdAndClassTypePK(classNameId, -1L);
    }

    public boolean isAssociatedToClassNameIdAndClassTypePK(long classNameId, long classTypePK) {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.hasClassNameIdAndClassTypePK(classNameId, classTypePK);
    }

    public boolean isMissingRequiredCategory(long classNameId, long classTypePK, final long[] categoryIds) {
        if (!this.isRequired(classNameId, classTypePK)) {
            return false;
        }
        PredicateFilter<AssetCategory> predicateFilter = new PredicateFilter<AssetCategory>(){

            public boolean filter(AssetCategory assetCategory) {
                return ArrayUtil.contains((long[])categoryIds, (long)assetCategory.getCategoryId());
            }
        };
        return !ListUtil.exists(this.getCategories(), (PredicateFilter)predicateFilter);
    }

    public boolean isMultiValued() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.isMultiValued();
    }

    @Deprecated
    public boolean isRequired(long classNameId) {
        return this.isRequired(classNameId, -1L);
    }

    public boolean isRequired(long classNameId, long classTypePK) {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.isClassNameIdAndClassTypePKRequired(classNameId, classTypePK);
    }

    @Override
    public void setSettings(String settings) {
        this._vocabularySettingsHelper = null;
        super.setSettings(settings);
    }

    @Deprecated
    public void setSettingsProperties(UnicodeProperties settingsProperties) {
        super.setSettings(settingsProperties.toString());
        this._vocabularySettingsHelper = this.getVocabularySettingsHelper();
    }

    protected AssetVocabularySettingsHelper getVocabularySettingsHelper() {
        if (this._vocabularySettingsHelper == null) {
            this._vocabularySettingsHelper = new AssetVocabularySettingsHelper(super.getSettings());
        }
        return this._vocabularySettingsHelper;
    }
}

