/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.impl.AssetEntryBaseImpl;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import java.util.List;

public class AssetEntryImpl
extends AssetEntryBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(AssetEntryImpl.class);

    public AssetRenderer getAssetRenderer() {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this.getClassName());
        try {
            return assetRendererFactory.getAssetRenderer(this.getClassPK());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to get asset renderer", (Throwable)e);
            }
            return null;
        }
    }

    public AssetRendererFactory getAssetRendererFactory() {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this.getClassName());
    }

    public List<AssetCategory> getCategories() {
        return AssetCategoryLocalServiceUtil.getEntryCategories((long)this.getEntryId());
    }

    public long[] getCategoryIds() {
        return ListUtil.toLongArray(this.getCategories(), (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
    }

    public String[] getTagNames() {
        return (String[])ListUtil.toArray(this.getTags(), (Accessor)AssetTag.NAME_ACCESSOR);
    }

    public List<AssetTag> getTags() {
        return AssetTagLocalServiceUtil.getEntryTags((long)this.getEntryId());
    }
}

