/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.model.impl.AssetCategoryBaseImpl;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class AssetCategoryImpl
extends AssetCategoryBaseImpl {
    public List<AssetCategory> getAncestors() throws PortalException {
        ArrayList<AssetCategory> categories = new ArrayList<AssetCategory>();
        AssetCategoryImpl category = this;
        while (!category.isRootCategory()) {
            category = AssetCategoryLocalServiceUtil.getAssetCategory((long)category.getParentCategoryId());
            categories.add(category);
        }
        return categories;
    }

    public AssetCategory getParentCategory() {
        return AssetCategoryLocalServiceUtil.fetchCategory((long)this.getParentCategoryId());
    }

    public String getPath(Locale locale) throws PortalException {
        List<AssetCategory> categories = this.getAncestors();
        StringBundler sb = new StringBundler(categories.size() * 4 + 1);
        AssetVocabulary vocabulary = AssetVocabularyLocalServiceUtil.getVocabulary((long)this.getVocabularyId());
        sb.append(vocabulary.getTitle(locale));
        for (AssetCategory category : categories) {
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
            sb.append(category.getTitle(locale));
        }
        return sb.toString();
    }

    @Override
    public String getTitle(String languageId) {
        String value = super.getTitle(languageId);
        if (Validator.isNull((String)value)) {
            value = this.getName();
        }
        return value;
    }

    @Override
    public String getTitle(String languageId, boolean useDefault) {
        String value = super.getTitle(languageId, useDefault);
        if (Validator.isNull((String)value)) {
            value = this.getName();
        }
        return value;
    }

    public boolean isRootCategory() {
        return this.getParentCategoryId() == 0L;
    }
}

