/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetVocabularyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetVocabularyStagedModelDataHandler
extends BaseStagedModelDataHandler<AssetVocabulary> {
    public static final String[] CLASS_NAMES = new String[]{AssetVocabulary.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        AssetVocabulary vocabulary = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (vocabulary != null) {
            AssetVocabularyLocalServiceUtil.deleteAssetVocabulary((AssetVocabulary)vocabulary);
        }
    }

    public AssetVocabulary fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List vocabularies = AssetVocabularyLocalServiceUtil.getAssetVocabulariesByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)vocabularies)) {
            return null;
        }
        return (AssetVocabulary)vocabularies.get(0);
    }

    public AssetVocabulary fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return AssetVocabularyLocalServiceUtil.fetchAssetVocabularyByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(AssetVocabulary vocabulary) {
        return vocabulary.getTitleCurrentValue();
    }

    protected ServiceContext createServiceContext(PortletDataContext portletDataContext, AssetVocabulary vocabulary) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(vocabulary.getCreateDate());
        serviceContext.setModifiedDate(vocabulary.getModifiedDate());
        serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
        return serviceContext;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, AssetVocabulary vocabulary) throws Exception {
        Element vocabularyElement = portletDataContext.getExportDataElement((ClassedModel)vocabulary);
        String vocabularyPath = ExportImportPathUtil.getModelPath((StagedModel)vocabulary);
        vocabularyElement.addAttribute("path", vocabularyPath);
        vocabulary.setUserUuid(vocabulary.getUserUuid());
        portletDataContext.addPermissions(AssetVocabulary.class, vocabulary.getVocabularyId());
        portletDataContext.addZipEntry(vocabularyPath, (Object)vocabulary);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long vocabularyId) throws Exception {
        AssetVocabulary existingVocabulary = (AssetVocabulary)this.fetchMissingReference(uuid, groupId);
        Map vocabularyIds = portletDataContext.getNewPrimaryKeysMap(AssetVocabulary.class);
        vocabularyIds.put(vocabularyId, existingVocabulary.getVocabularyId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, AssetVocabulary vocabulary) throws Exception {
        String name;
        long userId = portletDataContext.getUserId(vocabulary.getUserUuid());
        ServiceContext serviceContext = this.createServiceContext(portletDataContext, vocabulary);
        AssetVocabulary importedVocabulary = null;
        AssetVocabulary existingVocabulary = this.fetchStagedModelByUuidAndGroupId(vocabulary.getUuid(), portletDataContext.getScopeGroupId());
        if (existingVocabulary == null) {
            name = this.getVocabularyName(null, portletDataContext.getScopeGroupId(), vocabulary.getName(), 2);
            serviceContext.setUuid(vocabulary.getUuid());
            importedVocabulary = AssetVocabularyLocalServiceUtil.addVocabulary((long)userId, (String)"", this.getVocabularyTitleMap(portletDataContext.getScopeGroupId(), vocabulary, name), (Map)vocabulary.getDescriptionMap(), (String)vocabulary.getSettings(), (ServiceContext)serviceContext);
        } else {
            name = this.getVocabularyName(vocabulary.getUuid(), portletDataContext.getScopeGroupId(), vocabulary.getName(), 2);
            importedVocabulary = AssetVocabularyLocalServiceUtil.updateVocabulary((long)existingVocabulary.getVocabularyId(), (String)"", this.getVocabularyTitleMap(portletDataContext.getScopeGroupId(), vocabulary, name), (Map)vocabulary.getDescriptionMap(), (String)vocabulary.getSettings(), (ServiceContext)serviceContext);
        }
        Map vocabularyIds = portletDataContext.getNewPrimaryKeysMap(AssetVocabulary.class);
        vocabularyIds.put(vocabulary.getVocabularyId(), importedVocabulary.getVocabularyId());
        portletDataContext.importPermissions(AssetVocabulary.class, vocabulary.getVocabularyId(), importedVocabulary.getVocabularyId());
    }

    protected String getVocabularyName(String uuid, long groupId, String name, int count) throws Exception {
        AssetVocabulary vocabulary = AssetVocabularyUtil.fetchByG_N((long)groupId, (String)name);
        if (vocabulary == null) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(vocabulary.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return this.getVocabularyName(uuid, groupId, name, ++count);
    }

    protected Map<Locale, String> getVocabularyTitleMap(long groupId, AssetVocabulary vocabulary, String name) throws PortalException {
        HashMap<Locale, String> titleMap = vocabulary.getTitleMap();
        if (titleMap == null) {
            titleMap = new HashMap<Locale, String>();
        }
        titleMap.put(PortalUtil.getSiteDefaultLocale((long)groupId), name);
        return titleMap;
    }
}

