/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetCategoryProperty;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetCategoryPropertyLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetCategoryUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetCategoryStagedModelDataHandler
extends BaseStagedModelDataHandler<AssetCategory> {
    public static final String[] CLASS_NAMES = new String[]{AssetCategory.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        AssetCategory category = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (category != null) {
            AssetCategoryLocalServiceUtil.deleteAssetCategory((AssetCategory)category);
        }
    }

    public AssetCategory fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List categories = AssetCategoryLocalServiceUtil.getAssetCategoriesByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)categories)) {
            return null;
        }
        return (AssetCategory)categories.get(0);
    }

    public AssetCategory fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return AssetCategoryLocalServiceUtil.fetchAssetCategoryByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(AssetCategory category) {
        return category.getTitleCurrentValue();
    }

    protected ServiceContext createServiceContext(PortletDataContext portletDataContext, AssetCategory category) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(category.getCreateDate());
        serviceContext.setModifiedDate(category.getModifiedDate());
        serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
        return serviceContext;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, AssetCategory category) throws Exception {
        if (category.getParentCategoryId() != 0L) {
            AssetCategory parentCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)category.getParentCategoryId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)category, (StagedModel)parentCategory, (String)"parent");
        } else {
            AssetVocabulary vocabulary = AssetVocabularyLocalServiceUtil.fetchAssetVocabulary((long)category.getVocabularyId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)category, (StagedModel)vocabulary, (String)"parent");
        }
        Element categoryElement = portletDataContext.getExportDataElement((ClassedModel)category);
        category.setUserUuid(category.getUserUuid());
        List categoryProperties = AssetCategoryPropertyLocalServiceUtil.getCategoryProperties((long)category.getCategoryId());
        for (AssetCategoryProperty categoryProperty : categoryProperties) {
            Element propertyElement = categoryElement.addElement("property");
            propertyElement.addAttribute("userUuid", categoryProperty.getUserUuid());
            propertyElement.addAttribute("key", categoryProperty.getKey());
            propertyElement.addAttribute("value", categoryProperty.getValue());
        }
        String categoryPath = ExportImportPathUtil.getModelPath((StagedModel)category);
        categoryElement.addAttribute("path", categoryPath);
        portletDataContext.addPermissions(AssetCategory.class, category.getCategoryId());
        portletDataContext.addZipEntry(categoryPath, (Object)category);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long categoryId) throws Exception {
        AssetCategory existingCategory = (AssetCategory)this.fetchMissingReference(uuid, groupId);
        Map categoryIds = portletDataContext.getNewPrimaryKeysMap(AssetCategory.class);
        categoryIds.put(categoryId, existingCategory.getCategoryId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, AssetCategory category) throws Exception {
        String name;
        long userId = portletDataContext.getUserId(category.getUserUuid());
        Map vocabularyIds = portletDataContext.getNewPrimaryKeysMap(AssetVocabulary.class);
        long vocabularyId = MapUtil.getLong((Map)vocabularyIds, (long)category.getVocabularyId(), (long)category.getVocabularyId());
        Map categoryIds = portletDataContext.getNewPrimaryKeysMap(AssetCategory.class);
        long parentCategoryId = MapUtil.getLong((Map)categoryIds, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
        Element categoryElement = portletDataContext.getImportDataElement((StagedModel)category);
        List propertyElements = categoryElement.elements("property");
        String[] properties = new String[propertyElements.size()];
        for (int i = 0; i < propertyElements.size(); ++i) {
            Element propertyElement = (Element)propertyElements.get(i);
            String key = propertyElement.attributeValue("key");
            String value = propertyElement.attributeValue("value");
            properties[i] = key.concat("_KEY_VALUE_").concat(value);
        }
        ServiceContext serviceContext = this.createServiceContext(portletDataContext, category);
        AssetCategory importedCategory = null;
        AssetCategory existingCategory = this.fetchStagedModelByUuidAndGroupId(category.getUuid(), portletDataContext.getScopeGroupId());
        if (existingCategory == null) {
            name = this.getCategoryName(null, portletDataContext.getScopeGroupId(), parentCategoryId, category.getName(), vocabularyId, 2);
            serviceContext.setUuid(category.getUuid());
            importedCategory = AssetCategoryLocalServiceUtil.addCategory((long)userId, (long)parentCategoryId, this.getCategoryTitleMap(portletDataContext.getScopeGroupId(), category, name), (Map)category.getDescriptionMap(), (long)vocabularyId, (String[])properties, (ServiceContext)serviceContext);
        } else {
            name = this.getCategoryName(category.getUuid(), portletDataContext.getScopeGroupId(), parentCategoryId, category.getName(), vocabularyId, 2);
            importedCategory = AssetCategoryLocalServiceUtil.updateCategory((long)userId, (long)existingCategory.getCategoryId(), (long)parentCategoryId, this.getCategoryTitleMap(portletDataContext.getScopeGroupId(), category, name), (Map)category.getDescriptionMap(), (long)vocabularyId, (String[])properties, (ServiceContext)serviceContext);
        }
        categoryIds.put(category.getCategoryId(), importedCategory.getCategoryId());
        Map categoryUuids = portletDataContext.getNewPrimaryKeysMap(AssetCategory.class + ".uuid");
        categoryUuids.put(category.getUuid(), importedCategory.getUuid());
        portletDataContext.importPermissions(AssetCategory.class, category.getCategoryId(), importedCategory.getCategoryId());
    }

    protected String getCategoryName(String uuid, long groupId, long parentCategoryId, String name, long vocabularyId, int count) throws Exception {
        AssetCategory category = AssetCategoryUtil.fetchByG_P_N_V_First((long)groupId, (long)parentCategoryId, (String)name, (long)vocabularyId, null);
        if (category == null || Validator.isNotNull((String)uuid) && uuid.equals(category.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return this.getCategoryName(uuid, groupId, parentCategoryId, name, vocabularyId, ++count);
    }

    protected Map<Locale, String> getCategoryTitleMap(long groupId, AssetCategory category, String name) throws PortalException {
        HashMap<Locale, String> titleMap = category.getTitleMap();
        if (titleMap == null) {
            titleMap = new HashMap<Locale, String>();
        }
        titleMap.put(PortalUtil.getSiteDefaultLocale((long)groupId), name);
        return titleMap;
    }
}

