/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.lar;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.lar.xstream.XStreamAliasRegistryUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.model.impl.AssetCategoryImpl;
import com.liferay.portlet.asset.model.impl.AssetVocabularyImpl;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import java.util.List;
import javax.portlet.PortletPreferences;

public class AssetCategoryPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "asset_category";

    public AssetCategoryPortletDataHandler() {
        this.setDataAlwaysStaged(true);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(AssetCategory.class), new StagedModelType(AssetVocabulary.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "categories", true, false, null, AssetCategory.class.getName()), new PortletDataHandlerBoolean(NAMESPACE, "vocabularies", true, false, null, AssetVocabulary.class.getName())});
        this.setPublishToLiveByDefault(true);
        XStreamAliasRegistryUtil.register(AssetCategoryImpl.class, (String)"AssetCategory");
        XStreamAliasRegistryUtil.register(AssetVocabularyImpl.class, (String)"AssetVocabulary");
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (portletDataContext.addPrimaryKey(AssetCategoryPortletDataHandler.class, "deleteData")) {
            return portletPreferences;
        }
        AssetVocabularyLocalServiceUtil.deleteVocabularies((long)portletDataContext.getScopeGroupId());
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        if (portletDataContext.getBooleanParameter(NAMESPACE, "categories")) {
            ActionableDynamicQuery categoryActionableDynamicQuery = this.getCategoryActionableDynamicQuery(portletDataContext);
            categoryActionableDynamicQuery.performActions();
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "vocabularies")) {
            ActionableDynamicQuery vocabularyActionableDynamicQuery = this.getVocabularyActionableDynamicQuery(portletDataContext);
            vocabularyActionableDynamicQuery.performActions();
        }
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        if (portletDataContext.getBooleanParameter(NAMESPACE, "categories")) {
            Element categoriesElement = portletDataContext.getImportDataGroupElement(AssetCategory.class);
            List categoryElements = categoriesElement.elements();
            for (Element categoryElement : categoryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)categoryElement);
            }
        }
        if (portletDataContext.getBooleanParameter(NAMESPACE, "vocabularies")) {
            Element vocabulariesElement = portletDataContext.getImportDataGroupElement(AssetVocabulary.class);
            List vocabularyElements = vocabulariesElement.elements();
            for (Element vocabularyElement : vocabularyElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)vocabularyElement);
            }
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ActionableDynamicQuery categoryActionableDynamicQuery = this.getCategoryActionableDynamicQuery(portletDataContext);
        categoryActionableDynamicQuery.performCount();
        ActionableDynamicQuery vocabularyActionableDynamicQuery = this.getVocabularyActionableDynamicQuery(portletDataContext);
        vocabularyActionableDynamicQuery.performCount();
    }

    protected ActionableDynamicQuery getCategoryActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery actionableDynamicQuery = AssetCategoryLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        actionableDynamicQuery.setAddCriteriaMethod(null);
        return actionableDynamicQuery;
    }

    protected ActionableDynamicQuery getVocabularyActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery actionableDynamicQuery = AssetVocabularyLocalServiceUtil.getExportActionableDynamicQuery((PortletDataContext)portletDataContext);
        actionableDynamicQuery.setAddCriteriaMethod(null);
        return actionableDynamicQuery;
    }
}

