/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.action;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.AssetCategoryServiceUtil;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class GetCategoriesAction
extends JSONAction {
    @Override
    public String getJSON(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List<AssetCategory> categories = this.getCategories(request);
        for (AssetCategory category : categories) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            List childCategories = AssetCategoryServiceUtil.getChildCategories((long)category.getCategoryId());
            jsonObject.put("categoryId", category.getCategoryId());
            jsonObject.put("childrenCount", childCategories.size());
            jsonObject.put("hasChildren", !childCategories.isEmpty());
            jsonObject.put("name", category.getName());
            jsonObject.put("parentCategoryId", category.getParentCategoryId());
            jsonObject.put("titleCurrentValue", category.getTitleCurrentValue());
            jsonArray.put(jsonObject);
        }
        return jsonArray.toString();
    }

    protected List<AssetCategory> getCategories(HttpServletRequest request) throws Exception {
        long categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"categoryId");
        long vocabularyId = ParamUtil.getLong((HttpServletRequest)request, (String)"vocabularyId");
        int start = ParamUtil.getInteger((HttpServletRequest)request, (String)"start", (int)-1);
        int end = ParamUtil.getInteger((HttpServletRequest)request, (String)"end", (int)-1);
        List categories = Collections.emptyList();
        if (categoryId > 0L) {
            categories = AssetCategoryServiceUtil.getChildCategories((long)categoryId, (int)start, (int)end, null);
        } else if (vocabularyId > 0L) {
            long parentCategoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"parentCategoryId", (long)0L);
            categories = AssetCategoryServiceUtil.getVocabularyCategories((long)parentCategoryId, (long)vocabularyId, (int)start, (int)end, null);
        }
        return categories;
    }
}

