/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portlet.announcements.model.AnnouncementsEntry;
import com.liferay.portlet.announcements.service.AnnouncementsEntryLocalServiceUtil;

public class AnnouncementsEntryPermission {
    public static void check(PermissionChecker permissionChecker, AnnouncementsEntry entry, String actionId) throws PortalException {
        if (!AnnouncementsEntryPermission.contains(permissionChecker, entry, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, Layout layout, String name, String actionId) throws PortalException {
        if (!AnnouncementsEntryPermission.contains(permissionChecker, layout, name, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException {
        if (!AnnouncementsEntryPermission.contains(permissionChecker, entryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long plid, String name, String actionId) throws PortalException {
        if (!AnnouncementsEntryPermission.contains(permissionChecker, plid, name, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, AnnouncementsEntry entry, String actionId) throws PortalException {
        if (permissionChecker.hasOwnerPermission(entry.getCompanyId(), AnnouncementsEntry.class.getName(), entry.getEntryId(), entry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(entry.getGroupId(), AnnouncementsEntry.class.getName(), entry.getEntryId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, Layout layout, String name, String actionId) throws PortalException {
        if (layout instanceof VirtualLayout) {
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            layout = virtualLayout.getSourceLayout();
        }
        if (permissionChecker.isGroupAdmin(layout.getGroupId()) || permissionChecker.isGroupOwner(layout.getGroupId())) {
            return true;
        }
        return PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)name, (String)actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException {
        AnnouncementsEntry entry = AnnouncementsEntryLocalServiceUtil.getEntry((long)entryId);
        return AnnouncementsEntryPermission.contains(permissionChecker, entry, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long plid, String name, String actionId) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        return AnnouncementsEntryPermission.contains(permissionChecker, layout, name, actionId);
    }
}

