/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;

public class OmniadminUtil {
    private static Log _log = LogFactoryUtil.getLog(OmniadminUtil.class);

    public static boolean isOmniadmin(long userId) {
        try {
            User user = UserLocalServiceUtil.fetchUser((long)userId);
            if (user == null) {
                return false;
            }
            return OmniadminUtil.isOmniadmin(user);
        }
        catch (SystemException se) {
            return false;
        }
    }

    public static boolean isOmniadmin(User user) {
        long userId = user.getUserId();
        if (userId <= 0L) {
            return false;
        }
        try {
            if (PropsValues.OMNIADMIN_USERS.length > 0) {
                for (int i = 0; i < PropsValues.OMNIADMIN_USERS.length; ++i) {
                    if (PropsValues.OMNIADMIN_USERS[i] != userId) continue;
                    return user.getCompanyId() == PortalInstances.getDefaultCompanyId();
                }
                return false;
            }
            if (user.getCompanyId() != PortalInstances.getDefaultCompanyId()) {
                return false;
            }
            return RoleLocalServiceUtil.hasUserRole((long)userId, (long)user.getCompanyId(), (String)"Administrator", (boolean)true);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
            return false;
        }
    }
}

