/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.action;

import com.liferay.portal.CompanyMxException;
import com.liferay.portal.CompanyVirtualHostException;
import com.liferay.portal.CompanyWebIdException;
import com.liferay.portal.NoSuchCompanyException;
import com.liferay.portal.RequiredCompanyException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.CompanyServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.admin.action.ActionUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditInstanceAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteInstance(actionRequest);
            } else {
                this.updateInstance(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchCompanyException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.admin.error");
            }
            if (e instanceof CompanyMxException || e instanceof CompanyVirtualHostException || e instanceof CompanyWebIdException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof RequiredCompanyException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.sendRedirect(actionRequest, actionResponse);
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getInstance((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchCompanyException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.admin.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.admin.edit_instance"));
    }

    protected void deleteInstance(ActionRequest actionRequest) throws Exception {
        long companyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"companyId");
        CompanyServiceUtil.deleteCompany((long)companyId);
    }

    protected void updateInstance(ActionRequest actionRequest) throws Exception {
        long companyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"companyId");
        String webId = ParamUtil.getString((PortletRequest)actionRequest, (String)"webId");
        String virtualHostname = ParamUtil.getString((PortletRequest)actionRequest, (String)"virtualHostname");
        String mx = ParamUtil.getString((PortletRequest)actionRequest, (String)"mx");
        String shardName = ParamUtil.getString((PortletRequest)actionRequest, (String)"shardName", (String)PropsValues.SHARD_DEFAULT_NAME);
        boolean system = false;
        int maxUsers = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"maxUsers", (int)0);
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        if (companyId <= 0L) {
            Company company = CompanyServiceUtil.addCompany((String)webId, (String)virtualHostname, (String)mx, (String)shardName, (boolean)system, (int)maxUsers, (boolean)active);
            ServletContext servletContext = (ServletContext)actionRequest.getAttribute("CTX");
            PortalInstances.initCompany(servletContext, company.getWebId());
        } else {
            CompanyServiceUtil.updateCompany((long)companyId, (String)virtualHostname, (String)mx, (int)maxUsers, (boolean)active);
        }
    }
}

