/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.RenderParametersPool;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PublicRenderParametersPool {
    private static final String _PUBLIC_RENDER_PARAMETERS = "PUBLIC_RENDER_PARAMETERS";
    private static Log _log = LogFactoryUtil.getLog(PublicRenderParametersPool.class);

    public static Map<String, String[]> get(HttpServletRequest request, long plid) {
        if (PropsValues.PORTLET_PUBLIC_RENDER_PARAMETER_DISTRIBUTION_LAYOUT) {
            return RenderParametersPool.get(request, plid, _PUBLIC_RENDER_PARAMETERS);
        }
        HttpSession session = request.getSession();
        ConcurrentHashMap publicRenderParametersPool = (ConcurrentHashMap)session.getAttribute("PUBLIC_RENDER_PARAMETERS_POOL_");
        if (publicRenderParametersPool == null) {
            publicRenderParametersPool = new ConcurrentHashMap();
            session.setAttribute("PUBLIC_RENDER_PARAMETERS_POOL_", publicRenderParametersPool);
        }
        try {
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            LayoutSet layoutSet = layout.getLayoutSet();
            HashMap publicRenderParameters = (HashMap)publicRenderParametersPool.get(layoutSet.getLayoutSetId());
            if (publicRenderParameters == null) {
                publicRenderParameters = new HashMap();
                publicRenderParametersPool.put(layoutSet.getLayoutSetId(), publicRenderParameters);
            }
            return publicRenderParameters;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return new HashMap<String, String[]>();
        }
    }
}

