/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.portlet.WindowStateFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.security.auth.AuthTokenUtil;
import com.liferay.portal.security.auth.AuthTokenWhitelistUtil;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletQNameUtil;
import com.liferay.portlet.RenderParametersPool;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.Key;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;

public class PortletURLImpl
implements LiferayPortletURL,
PortletURL,
ResourceURL,
Serializable {
    private static Log _log = LogFactoryUtil.getLog(PortletURLImpl.class);
    private boolean _anchor = true;
    private String _cacheability = "cacheLevelPage";
    private String _controlPanelCategory;
    private boolean _copyCurrentRenderParameters;
    private long _doAsGroupId;
    private long _doAsUserId;
    private String _doAsUserLanguageId;
    private boolean _encrypt;
    private boolean _escapeXml = PropsValues.PORTLET_URL_ESCAPE_XML;
    private Layout _layout;
    private String _layoutFriendlyURL;
    private String _lifecycle;
    private String _namespace;
    private Set<String> _parametersIncludedInPath;
    private Map<String, String[]> _params;
    private long _plid;
    private Portlet _portlet;
    private String _portletId;
    private String _portletModeString;
    private PortletRequest _portletRequest;
    private long _refererGroupId;
    private long _refererPlid;
    private Set<String> _removedParameterNames;
    private Map<String, String[]> _removePublicRenderParameters;
    private HttpServletRequest _request;
    private Map<String, String> _reservedParameters;
    private String _resourceID;
    private boolean _secure;
    private String _toString;
    private boolean _windowStateRestoreCurrentView;
    private String _windowStateString;
    private boolean _wsrp;

    public PortletURLImpl(HttpServletRequest request, String portletId, long plid, String lifecycle) {
        Layout layout;
        this._request = request;
        this._portletId = portletId;
        this._plid = plid;
        this._lifecycle = lifecycle;
        this._parametersIncludedInPath = new LinkedHashSet<String>();
        this._params = new LinkedHashMap<String, String[]>();
        this._removePublicRenderParameters = new LinkedHashMap<String, String[]>();
        this._secure = PortalUtil.isSecure((HttpServletRequest)request);
        this._wsrp = ParamUtil.getBoolean((HttpServletRequest)request, (String)"wsrp");
        Portlet portlet = this.getPortlet();
        if (portlet != null) {
            Set autopropagatedParameters = portlet.getAutopropagatedParameters();
            for (String autopropagatedParameter : autopropagatedParameters) {
                String value;
                if (PortalUtil.isReservedParameter((String)autopropagatedParameter) || (value = request.getParameter(autopropagatedParameter)) == null) continue;
                this.setParameter(autopropagatedParameter, value);
            }
            PortletApp portletApp = portlet.getPortletApp();
            this._escapeXml = MapUtil.getBoolean((Map)portletApp.getContainerRuntimeOptions(), (String)"javax.portlet.escapeXml", (boolean)PropsValues.PORTLET_URL_ESCAPE_XML);
        }
        if ((layout = (Layout)request.getAttribute("LAYOUT")) != null && layout.getPlid() == this._plid && layout instanceof VirtualLayout) {
            this._layout = layout;
        }
    }

    public PortletURLImpl(PortletRequest portletRequest, String portletId, long plid, String lifecycle) {
        this(PortalUtil.getHttpServletRequest((PortletRequest)portletRequest), portletId, plid, lifecycle);
        this._portletRequest = portletRequest;
    }

    public void addParameterIncludedInPath(String name) {
        this._parametersIncludedInPath.add(name);
    }

    public void addProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
    }

    public String getCacheability() {
        return this._cacheability;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._request;
    }

    public Layout getLayout() {
        block4: {
            if (this._layout == null) {
                try {
                    if (this._plid > 0L) {
                        this._layout = LayoutLocalServiceUtil.getLayout((long)this._plid);
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)("Layout cannot be found for " + this._plid));
                }
            }
        }
        return this._layout;
    }

    public String getLayoutFriendlyURL() {
        return this._layoutFriendlyURL;
    }

    public String getLifecycle() {
        return this._lifecycle;
    }

    public String getNamespace() {
        if (this._namespace == null) {
            this._namespace = PortalUtil.getPortletNamespace((String)this._portletId);
        }
        return this._namespace;
    }

    public String getParameter(String name) {
        Object[] values = this._params.get(name);
        if (ArrayUtil.isNotEmpty((Object[])values)) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return this._params;
    }

    public Set<String> getParametersIncludedInPath() {
        return this._parametersIncludedInPath;
    }

    public long getPlid() {
        return this._plid;
    }

    public Portlet getPortlet() {
        if (this._portlet == null) {
            try {
                this._portlet = PortletLocalServiceUtil.getPortletById((long)PortalUtil.getCompanyId((HttpServletRequest)this._request), (String)this._portletId);
            }
            catch (SystemException se) {
                _log.error((Object)se.getMessage());
            }
        }
        return this._portlet;
    }

    public String getPortletFriendlyURLPath() {
        FriendlyURLMapper friendlyURLMapper;
        String portletFriendlyURLPath = null;
        Portlet portlet = this.getPortlet();
        if (portlet != null && (friendlyURLMapper = portlet.getFriendlyURLMapperInstance()) != null) {
            portletFriendlyURLPath = friendlyURLMapper.buildPath((LiferayPortletURL)this);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Portlet friendly URL path " + portletFriendlyURLPath));
            }
        }
        return portletFriendlyURLPath;
    }

    public String getPortletId() {
        return this._portletId;
    }

    public PortletMode getPortletMode() {
        if (this._portletModeString == null) {
            return null;
        }
        return PortletModeFactory.getPortletMode((String)this._portletModeString);
    }

    public PortletRequest getPortletRequest() {
        return this._portletRequest;
    }

    public Set<String> getRemovedParameterNames() {
        return this._removedParameterNames;
    }

    public Map<String, String> getReservedParameterMap() {
        ThemeDisplay themeDisplay;
        PortletDisplay portletDisplay;
        if (this._reservedParameters != null) {
            return this._reservedParameters;
        }
        this._reservedParameters = new LinkedHashMap<String, String>();
        this._reservedParameters.put("p_p_id", this._portletId);
        if (this._lifecycle.equals("ACTION_PHASE")) {
            this._reservedParameters.put("p_p_lifecycle", "1");
        } else if (this._lifecycle.equals("RENDER_PHASE")) {
            this._reservedParameters.put("p_p_lifecycle", "0");
        } else if (this._lifecycle.equals("RESOURCE_PHASE")) {
            this._reservedParameters.put("p_p_lifecycle", "2");
        }
        if (this._windowStateString != null) {
            this._reservedParameters.put("p_p_state", this._windowStateString);
        }
        if (this._windowStateRestoreCurrentView) {
            this._reservedParameters.put("p_p_state_rcv", "1");
        }
        if (this._portletModeString != null) {
            this._reservedParameters.put("p_p_mode", this._portletModeString);
        }
        if (this._resourceID != null) {
            this._reservedParameters.put("p_p_resource_id", this._resourceID);
        }
        if (this._lifecycle.equals("RESOURCE_PHASE")) {
            this._reservedParameters.put("p_p_cacheability", this._cacheability);
        }
        if (Validator.isNotNull((String)(portletDisplay = (themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY")).getPortletDisplay()).getColumnId())) {
            this._reservedParameters.put("p_p_col_id", portletDisplay.getColumnId());
        }
        if (portletDisplay.getColumnPos() > 0) {
            this._reservedParameters.put("p_p_col_pos", String.valueOf(portletDisplay.getColumnPos()));
        }
        if (portletDisplay.getColumnCount() > 0) {
            this._reservedParameters.put("p_p_col_count", String.valueOf(portletDisplay.getColumnCount()));
        }
        this._reservedParameters = Collections.unmodifiableMap(this._reservedParameters);
        return this._reservedParameters;
    }

    public String getResourceID() {
        return this._resourceID;
    }

    public WindowState getWindowState() {
        if (this._windowStateString == null) {
            return null;
        }
        return WindowStateFactory.getWindowState((String)this._windowStateString);
    }

    public boolean isAnchor() {
        return this._anchor;
    }

    public boolean isCopyCurrentRenderParameters() {
        return this._copyCurrentRenderParameters;
    }

    public boolean isEncrypt() {
        return this._encrypt;
    }

    public boolean isEscapeXml() {
        return this._escapeXml;
    }

    public boolean isParameterIncludedInPath(String name) {
        return this._parametersIncludedInPath.contains(name);
    }

    public boolean isSecure() {
        return this._secure;
    }

    public void removePublicRenderParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Portlet portlet = this.getPortlet();
        if (portlet == null) {
            return;
        }
        PublicRenderParameter publicRenderParameter = portlet.getPublicRenderParameter(name);
        if (publicRenderParameter == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Public parameter " + name + "does not exist"));
            }
            return;
        }
        QName qName = publicRenderParameter.getQName();
        this._removePublicRenderParameters.put(PortletQNameUtil.getRemovePublicRenderParameterName((QName)qName), new String[]{"1"});
    }

    public void setAnchor(boolean anchor) {
        this._anchor = anchor;
        this.clearCache();
    }

    public void setCacheability(String cacheability) {
        ResourceRequest resourceRequest;
        String parentCacheability;
        if (cacheability == null) {
            throw new IllegalArgumentException("Cacheability is null");
        }
        if (!(cacheability.equals("cacheLevelFull") || cacheability.equals("cacheLevelPortlet") || cacheability.equals("cacheLevelPage"))) {
            throw new IllegalArgumentException("Cacheability " + cacheability + " is not " + "cacheLevelFull" + ", " + "cacheLevelPortlet" + ", or " + "cacheLevelPage");
        }
        if (this._portletRequest instanceof ResourceRequest && ((parentCacheability = (resourceRequest = (ResourceRequest)this._portletRequest).getCacheability()).equals("cacheLevelFull") ? !cacheability.equals("cacheLevelFull") : parentCacheability.equals("cacheLevelPortlet") && !cacheability.equals("cacheLevelFull") && !cacheability.equals("cacheLevelPortlet"))) {
            throw new IllegalStateException("Unable to set a weaker cacheability " + cacheability);
        }
        this._cacheability = cacheability;
        this.clearCache();
    }

    public void setControlPanelCategory(String controlPanelCategory) {
        this._controlPanelCategory = controlPanelCategory;
        this.clearCache();
    }

    public void setCopyCurrentRenderParameters(boolean copyCurrentRenderParameters) {
        this._copyCurrentRenderParameters = copyCurrentRenderParameters;
    }

    public void setDoAsGroupId(long doAsGroupId) {
        this._doAsGroupId = doAsGroupId;
        this.clearCache();
    }

    public void setDoAsUserId(long doAsUserId) {
        this._doAsUserId = doAsUserId;
        this.clearCache();
    }

    public void setDoAsUserLanguageId(String doAsUserLanguageId) {
        this._doAsUserLanguageId = doAsUserLanguageId;
        this.clearCache();
    }

    public void setEncrypt(boolean encrypt) {
        this._encrypt = encrypt;
        this.clearCache();
    }

    public void setEscapeXml(boolean escapeXml) {
        this._escapeXml = escapeXml;
        this.clearCache();
    }

    public void setLifecycle(String lifecycle) {
        this._lifecycle = lifecycle;
        this.clearCache();
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, value, PropsValues.PORTLET_URL_APPEND_PARAMETERS);
    }

    public void setParameter(String name, String value, boolean append) {
        if (name == null || value == null) {
            throw new IllegalArgumentException();
        }
        this.setParameter(name, new String[]{value}, append);
    }

    public void setParameter(String name, String[] values) {
        this.setParameter(name, values, PropsValues.PORTLET_URL_APPEND_PARAMETERS);
    }

    public void setParameter(String name, String[] values, boolean append) {
        if (name == null || values == null) {
            throw new IllegalArgumentException();
        }
        for (String value : values) {
            if (value != null) continue;
            throw new IllegalArgumentException();
        }
        if (!append) {
            this._params.put(name, values);
        } else {
            Object[] oldValues = this._params.get(name);
            if (oldValues == null) {
                this._params.put(name, values);
            } else {
                String[] newValues = (String[])ArrayUtil.append((Object[])oldValues, (Object[])values);
                this._params.put(name, newValues);
            }
        }
        this.clearCache();
    }

    public void setParameters(Map<String, String[]> params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<String, String[]> newParams = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            try {
                String key = entry.getKey();
                String[] value = entry.getValue();
                if (key == null) {
                    throw new IllegalArgumentException();
                }
                if (value == null) {
                    throw new IllegalArgumentException();
                }
                newParams.put(key, value);
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException(cce);
            }
        }
        this._params = newParams;
        this.clearCache();
    }

    public void setPlid(long plid) {
        this._plid = plid;
        this.clearCache();
    }

    public void setPortletId(String portletId) {
        this._portletId = portletId;
        this.clearCache();
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        Portlet portlet;
        if (this._portletRequest != null && (portlet = this.getPortlet()) != null && !portlet.hasPortletMode(this._portletRequest.getResponseContentType(), portletMode)) {
            throw new PortletModeException(portletMode.toString(), portletMode);
        }
        this._portletModeString = portletMode.toString();
        this.clearCache();
    }

    public void setPortletMode(String portletMode) throws PortletModeException {
        this.setPortletMode(PortletModeFactory.getPortletMode((String)portletMode));
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
    }

    public void setRefererGroupId(long refererGroupId) {
        this._refererGroupId = refererGroupId;
        this.clearCache();
    }

    public void setRefererPlid(long refererPlid) {
        this._refererPlid = refererPlid;
        this.clearCache();
    }

    public void setRemovedParameterNames(Set<String> removedParameterNames) {
        this._removedParameterNames = removedParameterNames;
        this.clearCache();
    }

    public void setResourceID(String resourceID) {
        this._resourceID = resourceID;
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
        this.clearCache();
    }

    public void setWindowState(String windowState) throws WindowStateException {
        this.setWindowState(WindowStateFactory.getWindowState((String)windowState));
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (this._portletRequest != null && !this._portletRequest.isWindowStateAllowed(windowState)) {
            throw new WindowStateException(windowState.toString(), windowState);
        }
        if (LiferayWindowState.isWindowStatePreserved((WindowState)this.getWindowState(), (WindowState)windowState)) {
            this._windowStateString = windowState.toString();
        }
        this.clearCache();
    }

    public void setWindowStateRestoreCurrentView(boolean windowStateRestoreCurrentView) {
        this._windowStateRestoreCurrentView = windowStateRestoreCurrentView;
    }

    public String toString() {
        if (this._toString != null) {
            return this._toString;
        }
        this._toString = (String)((Object)DoPrivilegedUtil.wrap(new ToStringPrivilegedAction()));
        return this._toString;
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, this._escapeXml);
    }

    public void write(Writer writer, boolean escapeXml) throws IOException {
        String toString = this.toString();
        if (escapeXml && !this._escapeXml) {
            toString = HtmlUtil.escape((String)toString);
        }
        writer.write(toString);
    }

    protected void addPortalAuthToken(StringBundler sb, Key key) {
        if (!PropsValues.AUTH_TOKEN_CHECK_ENABLED || !this._lifecycle.equals("ACTION_PHASE")) {
            return;
        }
        Portlet portlet = this.getPortlet();
        if (portlet == null) {
            return;
        }
        String strutsAction = this.getParameter("struts_action");
        if (AuthTokenWhitelistUtil.isPortletCSRFWhitelisted((long)portlet.getCompanyId(), (String)this._portletId, (String)strutsAction)) {
            return;
        }
        sb.append("p_auth");
        sb.append("=");
        sb.append(this.processValue(key, AuthTokenUtil.getToken((HttpServletRequest)this._request)));
        sb.append("&");
    }

    protected void addPortletAuthToken(StringBundler sb, Key key) {
        block8: {
            if (!PropsValues.PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED) {
                return;
            }
            Portlet portlet = this.getPortlet();
            if (portlet == null) {
                return;
            }
            if (!portlet.isAddDefaultResource()) {
                return;
            }
            String strutsAction = this.getParameter("struts_action");
            if (AuthTokenWhitelistUtil.isPortletInvocationWhitelisted((long)portlet.getCompanyId(), (String)this._portletId, (String)strutsAction)) {
                return;
            }
            try {
                LayoutTypePortlet targetLayoutTypePortlet = (LayoutTypePortlet)this.getLayout().getLayoutType();
                if (targetLayoutTypePortlet.hasPortletId(this._portletId)) {
                    return;
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block8;
                _log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this._portletId.equals("160")) {
            return;
        }
        sb.append("p_p_auth");
        sb.append("=");
        sb.append(this.processValue(key, AuthTokenUtil.getToken((HttpServletRequest)this._request, (long)this._plid, (String)this._portletId)));
        sb.append("&");
    }

    protected void clearCache() {
        this._reservedParameters = null;
        this._toString = null;
    }

    protected String generateToString() {
        String result;
        String controlPanelCategory;
        long refererPlid;
        long refererGroupId;
        long doAsGroupId;
        String doAsUserLanguageId;
        Company company;
        StringBundler sb = new StringBundler(64);
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portalURL = null;
        portalURL = themeDisplay.isFacebook() ? "http://apps.facebook.com/" + themeDisplay.getFacebookCanvasPageURL() : PortalUtil.getPortalURL((HttpServletRequest)this._request, (boolean)this._secure);
        try {
            Layout layout;
            if (this._layoutFriendlyURL == null && (layout = this.getLayout()) != null) {
                this._layoutFriendlyURL = GetterUtil.getString((String)PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay));
                if (this._secure) {
                    this._layoutFriendlyURL = HttpUtil.protocolize((String)this._layoutFriendlyURL, (int)PropsValues.WEB_SERVER_HTTPS_PORT, (boolean)true);
                }
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        Key key = null;
        try {
            if (this._encrypt) {
                company = PortalUtil.getCompany((HttpServletRequest)this._request);
                key = company.getKeyObj();
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        if (Validator.isNull((String)this._layoutFriendlyURL)) {
            sb.append(portalURL);
            sb.append(themeDisplay.getPathMain());
            sb.append("/portal/layout?");
            this.addPortalAuthToken(sb, key);
            sb.append("p_l_id");
            sb.append("=");
            sb.append(this.processValue(key, this._plid));
            sb.append("&");
        } else {
            if (themeDisplay.isFacebook()) {
                sb.append(portalURL);
            } else {
                if (!this._layoutFriendlyURL.startsWith("http://") && !this._layoutFriendlyURL.startsWith("https://")) {
                    sb.append(portalURL);
                }
                sb.append(this._layoutFriendlyURL);
            }
            String friendlyURLPath = this.getPortletFriendlyURLPath();
            if (Validator.isNotNull((String)friendlyURLPath)) {
                if (themeDisplay.isFacebook()) {
                    int pos = friendlyURLPath.indexOf(47, 1);
                    if (pos != -1) {
                        sb.append(friendlyURLPath.substring(pos));
                    } else {
                        sb.append(friendlyURLPath);
                    }
                } else {
                    sb.append("/-");
                    sb.append(friendlyURLPath);
                }
            }
            sb.append("?");
            this.addPortalAuthToken(sb, key);
        }
        this.addPortletAuthToken(sb, key);
        for (Map.Entry<String, String> entry : this.getReservedParameterMap().entrySet()) {
            String name = entry.getKey();
            if (this.isParameterIncludedInPath(name)) continue;
            sb.append(HttpUtil.encodeURL((String)name));
            sb.append("=");
            sb.append(this.processValue(key, entry.getValue()));
            sb.append("&");
        }
        if (this._doAsUserId > 0L) {
            try {
                company = PortalUtil.getCompany((HttpServletRequest)this._request);
                sb.append("doAsUserId");
                sb.append("=");
                sb.append(this.processValue(company.getKeyObj(), this._doAsUserId));
                sb.append("&");
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        } else {
            String doAsUserId = themeDisplay.getDoAsUserId();
            if (Validator.isNotNull((String)doAsUserId)) {
                sb.append("doAsUserId");
                sb.append("=");
                sb.append(this.processValue(key, doAsUserId));
                sb.append("&");
            }
        }
        if (Validator.isNull((String)(doAsUserLanguageId = this._doAsUserLanguageId))) {
            doAsUserLanguageId = themeDisplay.getDoAsUserLanguageId();
        }
        if (Validator.isNotNull((String)doAsUserLanguageId)) {
            sb.append("doAsUserLanguageId");
            sb.append("=");
            sb.append(this.processValue(key, doAsUserLanguageId));
            sb.append("&");
        }
        if ((doAsGroupId = this._doAsGroupId) <= 0L) {
            doAsGroupId = themeDisplay.getDoAsGroupId();
        }
        if (doAsGroupId > 0L) {
            sb.append("doAsGroupId");
            sb.append("=");
            sb.append(this.processValue(key, doAsGroupId));
            sb.append("&");
        }
        if ((refererGroupId = this._refererGroupId) <= 0L) {
            refererGroupId = themeDisplay.getRefererGroupId();
        }
        if (refererGroupId > 0L) {
            sb.append("refererGroupId");
            sb.append("=");
            sb.append(this.processValue(key, refererGroupId));
            sb.append("&");
        }
        if ((refererPlid = this._refererPlid) <= 0L) {
            refererPlid = themeDisplay.getRefererPlid();
        }
        if (refererPlid > 0L) {
            sb.append("refererPlid");
            sb.append("=");
            sb.append(this.processValue(key, refererPlid));
            sb.append("&");
        }
        if (Validator.isNull((String)(controlPanelCategory = this._controlPanelCategory))) {
            HttpServletRequest request = PortalUtil.getOriginalServletRequest((HttpServletRequest)this._request);
            controlPanelCategory = ParamUtil.getString((HttpServletRequest)request, (String)"controlPanelCategory");
        }
        if (Validator.isNotNull((String)controlPanelCategory)) {
            sb.append("controlPanelCategory");
            sb.append("=");
            sb.append(this.processValue(key, controlPanelCategory));
            sb.append("&");
        }
        for (Map.Entry<String, String[]> entry : this._removePublicRenderParameters.entrySet()) {
            String lastString = sb.stringAt(sb.index() - 1);
            if (lastString.charAt(lastString.length() - 1) != '&') {
                sb.append("&");
            }
            sb.append(HttpUtil.encodeURL((String)entry.getKey()));
            sb.append("=");
            sb.append(this.processValue(key, entry.getValue()[0]));
            sb.append("&");
        }
        if (this._copyCurrentRenderParameters) {
            this.mergeRenderParameters();
        }
        int previousSbIndex = sb.index();
        for (Map.Entry<String, String[]> entry : this._params.entrySet()) {
            String name = entry.getKey();
            String[] values = entry.getValue();
            if (this.isParameterIncludedInPath(name)) continue;
            String publicRenderParameterName = this.getPublicRenderParameterName(name);
            if (Validator.isNotNull((String)publicRenderParameterName)) {
                name = publicRenderParameterName;
            }
            name = HttpUtil.encodeURL((String)this.prependNamespace(name));
            for (String value : values) {
                sb.append(name);
                sb.append("=");
                sb.append(this.processValue(key, value));
                sb.append("&");
            }
        }
        if (sb.index() > previousSbIndex) {
            sb.setIndex(sb.index() - 1);
        }
        if (this._encrypt) {
            sb.append("&");
            sb.append("shuo");
            sb.append("=1");
        }
        if (PropsValues.PORTLET_URL_ANCHOR_ENABLE && this._anchor && this._windowStateString != null && !this._windowStateString.equals(WindowState.MAXIMIZED.toString()) && !this._windowStateString.equals(LiferayWindowState.EXCLUSIVE.toString()) && !this._windowStateString.equals(LiferayWindowState.POP_UP.toString())) {
            String lastString = sb.stringAt(sb.index() - 1);
            if (lastString.charAt(lastString.length() - 1) != '&') {
                sb.append("&");
            }
            sb.append("#p_");
            sb.append(HttpUtil.encodeURL((String)this._portletId));
        }
        if ((result = sb.toString()).endsWith("&") || result.endsWith("?")) {
            result = result.substring(0, result.length() - 1);
        }
        if (themeDisplay.isFacebook()) {
            int pos = result.indexOf(63);
            if (pos == -1) {
                if (!result.endsWith("/")) {
                    result = result + "/";
                }
            } else {
                String path = result.substring(0, pos);
                if (!result.endsWith("/")) {
                    result = path + "/" + result.substring(pos);
                }
            }
        } else if (!CookieKeys.hasSessionId((HttpServletRequest)this._request)) {
            result = PortalUtil.getURLWithSessionId((String)result, (String)this._request.getSession().getId());
        }
        if (this._escapeXml) {
            result = HtmlUtil.escape((String)result);
        }
        if (result.length() > 2083) {
            result = HttpUtil.shortenURL((String)result, (int)2);
        }
        return result;
    }

    protected String generateWSRPToString() {
        byte[] parameterBytes;
        StringBundler sb;
        block17: {
            sb = new StringBundler("wsrp_rewrite?");
            sb.append("wsrp-urlType");
            sb.append("=");
            if (this._lifecycle.equals("ACTION_PHASE")) {
                sb.append(HttpUtil.encodeURL((String)"blockingAction"));
            } else if (this._lifecycle.equals("RENDER_PHASE")) {
                sb.append(HttpUtil.encodeURL((String)"render"));
            } else if (this._lifecycle.equals("RESOURCE_PHASE")) {
                sb.append(HttpUtil.encodeURL((String)"resource"));
            }
            sb.append("&");
            if (this._windowStateString != null) {
                sb.append("wsrp-windowState");
                sb.append("=");
                sb.append(HttpUtil.encodeURL((String)("wsrp:" + this._windowStateString)));
                sb.append("&");
            }
            if (this._portletModeString != null) {
                sb.append("wsrp-mode");
                sb.append("=");
                sb.append(HttpUtil.encodeURL((String)("wsrp:" + this._portletModeString)));
                sb.append("&");
            }
            if (this._resourceID != null) {
                sb.append("wsrp-resourceID");
                sb.append("=");
                sb.append(HttpUtil.encodeURL((String)this._resourceID));
                sb.append("&");
            }
            if (this._lifecycle.equals("RESOURCE_PHASE")) {
                sb.append("wsrp-resourceCacheability");
                sb.append("=");
                sb.append(HttpUtil.encodeURL((String)this._cacheability));
                sb.append("&");
            }
            if (PropsValues.PORTLET_URL_ANCHOR_ENABLE && this._anchor && this._windowStateString != null && !this._windowStateString.equals(WindowState.MAXIMIZED.toString()) && !this._windowStateString.equals(LiferayWindowState.EXCLUSIVE.toString()) && !this._windowStateString.equals(LiferayWindowState.POP_UP.toString())) {
                sb.append("wsrp-fragmentID");
                sb.append("=");
                sb.append("#p_");
                sb.append(HttpUtil.encodeURL((String)this._portletId));
                sb.append("&");
            }
            if (this._copyCurrentRenderParameters) {
                this.mergeRenderParameters();
            }
            StringBundler parameterSb = new StringBundler();
            int previousSbIndex = sb.index();
            for (Map.Entry<String, String[]> entry : this._params.entrySet()) {
                String name = entry.getKey();
                String[] values = entry.getValue();
                if (this.isParameterIncludedInPath(name)) continue;
                String publicRenderParameterName = this.getPublicRenderParameterName(name);
                if (Validator.isNotNull((String)publicRenderParameterName)) {
                    name = publicRenderParameterName;
                }
                name = HttpUtil.encodeURL((String)this.prependNamespace(name));
                for (String value : values) {
                    parameterSb.append(name);
                    parameterSb.append("=");
                    parameterSb.append(HttpUtil.encodeURL((String)value));
                    parameterSb.append("&");
                }
            }
            if (sb.index() > previousSbIndex) {
                sb.setIndex(sb.index() - 1);
            }
            sb.append("wsrp-navigationalState");
            sb.append("=");
            parameterBytes = null;
            try {
                String parameterString = parameterSb.toString();
                parameterBytes = parameterString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                if (!_log.isWarnEnabled()) break block17;
                _log.warn((Object)uee, (Throwable)uee);
            }
        }
        String navigationalState = Base64.toURLSafe((String)Base64.encode((byte[])parameterBytes));
        sb.append(navigationalState);
        sb.append("/wsrp_rewrite");
        return sb.toString();
    }

    protected String getPublicRenderParameterName(String name) {
        PublicRenderParameter publicRenderParameter;
        Portlet portlet = this.getPortlet();
        String publicRenderParameterName = null;
        if (portlet != null && (publicRenderParameter = portlet.getPublicRenderParameter(name)) != null) {
            QName qName = publicRenderParameter.getQName();
            publicRenderParameterName = PortletQNameUtil.getPublicRenderParameterName((QName)qName);
        }
        return publicRenderParameterName;
    }

    protected boolean isBlankValue(String[] value) {
        return value != null && value.length == 1 && value[0].equals("");
    }

    protected void mergeRenderParameters() {
        String namespace = this.getNamespace();
        Layout layout = this.getLayout();
        Map<String, String[]> renderParameters = RenderParametersPool.get(this._request, layout.getPlid(), this.getPortlet().getPortletId());
        for (Map.Entry<String, String[]> entry : renderParameters.entrySet()) {
            String name = entry.getKey();
            if (name.contains(namespace)) {
                name = name.substring(namespace.length());
            }
            if (!this._lifecycle.equals("RESOURCE_PHASE") && this._removedParameterNames != null && this._removedParameterNames.contains(name)) continue;
            Object[] oldValues = entry.getValue();
            Object[] newValues = this._params.get(name);
            if (newValues == null) {
                this._params.put(name, (String[])oldValues);
                continue;
            }
            if (this.isBlankValue((String[])newValues)) {
                this._params.remove(name);
                continue;
            }
            newValues = (String[])ArrayUtil.append((Object[])newValues, (Object[])oldValues);
            this._params.put(name, (String[])newValues);
        }
    }

    protected String prependNamespace(String name) {
        String namespace = this.getNamespace();
        if (!(PortalUtil.isReservedParameter((String)name) || name.startsWith("p_r_p_") || name.startsWith(namespace))) {
            return namespace.concat(name);
        }
        return name;
    }

    protected String processValue(Key key, int value) {
        return this.processValue(key, String.valueOf(value));
    }

    protected String processValue(Key key, long value) {
        return this.processValue(key, String.valueOf(value));
    }

    protected String processValue(Key key, String value) {
        if (key == null) {
            return HttpUtil.encodeURL((String)value);
        }
        try {
            return HttpUtil.encodeURL((String)Encryptor.encrypt((Key)key, (String)value));
        }
        catch (EncryptorException ee) {
            return value;
        }
    }

    private class ToStringPrivilegedAction
    implements PrivilegedAction<String> {
        private ToStringPrivilegedAction() {
        }

        @Override
        public String run() {
            if (PortletURLImpl.this._wsrp) {
                return PortletURLImpl.this.generateWSRPToString();
            }
            return PortletURLImpl.this.generateToString();
        }
    }
}

