/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.InvokerPortletFactory;
import com.liferay.portlet.PortletBagFactory;
import com.liferay.portlet.PortletConfigFactoryUtil;
import com.liferay.portlet.PortletContextFactory;
import com.liferay.portlet.PortletInstanceFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.servlet.ServletContext;

@DoPrivileged
public class PortletInstanceFactoryImpl
implements PortletInstanceFactory {
    private InvokerPortletFactory _invokerPortletFactory;
    private Map<String, Map<String, InvokerPortlet>> _pool = new ConcurrentHashMap<String, Map<String, InvokerPortlet>>();

    public void clear(Portlet portlet) {
        this.clear(portlet, true);
    }

    public void clear(Portlet portlet, boolean resetRemotePortletBag) {
        PortletBag portletBag;
        String rootPortletId = portlet.getRootPortletId();
        Map<String, InvokerPortlet> portletInstances = this._pool.remove(rootPortletId);
        if (portletInstances != null) {
            InvokerPortlet rootInvokerPortletInstance = portletInstances.remove(rootPortletId);
            if (rootInvokerPortletInstance != null) {
                rootInvokerPortletInstance.destroy();
            }
            portletInstances.clear();
        }
        PortletApp portletApp = portlet.getPortletApp();
        if (resetRemotePortletBag && portletApp.isWARFile() && (portletBag = PortletBagPool.remove((String)rootPortletId)) != null) {
            portletBag.destroy();
        }
    }

    public InvokerPortlet create(Portlet portlet, ServletContext servletContext) throws PortletException {
        PortletConfig portletConfig;
        boolean deployed;
        boolean instanceable = false;
        boolean bl = deployed = !portlet.isUndeployedPortlet();
        if (portlet.isInstanceable() && deployed && PortletConstants.hasInstanceId((String)portlet.getPortletId())) {
            instanceable = true;
        }
        String rootPortletId = portlet.getRootPortletId();
        InvokerPortlet rootInvokerPortletInstance = null;
        Map<String, InvokerPortlet> portletInstances = null;
        if (deployed) {
            portletInstances = this._pool.get(rootPortletId);
            if (portletInstances == null) {
                portletInstances = new ConcurrentHashMap<String, InvokerPortlet>();
                this._pool.put(rootPortletId, portletInstances);
            } else {
                InvokerPortlet instanceInvokerPortletInstance;
                if (instanceable && (instanceInvokerPortletInstance = portletInstances.get(portlet.getPortletId())) != null) {
                    return instanceInvokerPortletInstance;
                }
                rootInvokerPortletInstance = portletInstances.get(rootPortletId);
            }
        }
        if (rootInvokerPortletInstance == null) {
            PortletBag portletBag = PortletBagPool.get((String)rootPortletId);
            if (portletBag == null) {
                PortletBagFactory portletBagFactory = new PortletBagFactory();
                portletBagFactory.setClassLoader(ClassLoaderUtil.getPortalClassLoader());
                portletBagFactory.setServletContext(servletContext);
                portletBagFactory.setWARFile(false);
                try {
                    portletBag = portletBagFactory.create(portlet);
                }
                catch (Exception e) {
                    throw new PortletException((Throwable)e);
                }
            }
            portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
            rootInvokerPortletInstance = this.init(portlet, portletConfig, portletBag.getPortletInstance());
            if (deployed) {
                portletInstances.put(rootPortletId, rootInvokerPortletInstance);
            }
        }
        if (!instanceable) {
            return rootInvokerPortletInstance;
        }
        javax.portlet.Portlet portletInstance = rootInvokerPortletInstance.getPortletInstance();
        portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        boolean checkAuthToken = rootInvokerPortletInstance.isCheckAuthToken();
        boolean facesPortlet = rootInvokerPortletInstance.isFacesPortlet();
        boolean strutsPortlet = rootInvokerPortletInstance.isStrutsPortlet();
        boolean strutsBridgePortlet = rootInvokerPortletInstance.isStrutsBridgePortlet();
        InvokerPortlet instanceInvokerPortletInstance = this._invokerPortletFactory.create(portlet, portletInstance, portletConfig, portletContext, checkAuthToken, facesPortlet, strutsPortlet, strutsBridgePortlet);
        if (deployed) {
            portletInstances.put(portlet.getPortletId(), instanceInvokerPortletInstance);
        }
        return instanceInvokerPortletInstance;
    }

    public void delete(Portlet portlet) {
        Map<String, InvokerPortlet> portletInstances;
        if (PortletConstants.hasInstanceId((String)portlet.getPortletId()) && (portletInstances = this._pool.get(portlet.getRootPortletId())) != null) {
            portletInstances.remove(portlet.getPortletId());
        }
    }

    public void destroy() {
    }

    public void destroy(Portlet portlet) {
        this.clear(portlet);
        PortletConfigFactoryUtil.destroy((Portlet)portlet);
        PortletContextFactory.destroy(portlet);
        PortletLocalServiceUtil.destroyPortlet((Portlet)portlet);
    }

    public void setInvokerPortletFactory(InvokerPortletFactory invokerPortletFactory) {
        this._invokerPortletFactory = invokerPortletFactory;
    }

    protected InvokerPortlet init(Portlet portlet, PortletConfig portletConfig, javax.portlet.Portlet portletInstance) throws PortletException {
        PortletContext portletContext = portletConfig.getPortletContext();
        InvokerPortlet invokerPortlet = this._invokerPortletFactory.create(portlet, portletInstance, portletContext);
        invokerPortlet.init(portletConfig);
        return invokerPortlet;
    }
}

