/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperTracker;
import com.liferay.portal.kernel.portlet.Route;
import com.liferay.portal.kernel.portlet.Router;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portlet.RouterImpl;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class FriendlyURLMapperTrackerImpl
implements FriendlyURLMapperTracker {
    private static Log _log = LogFactoryUtil.getLog(FriendlyURLMapperTrackerImpl.class);
    private Portlet _portlet;
    private Map<FriendlyURLMapper, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    private ServiceTracker<FriendlyURLMapper, FriendlyURLMapper> _serviceTracker;

    public FriendlyURLMapperTrackerImpl(Portlet portlet) {
        this._portlet = portlet;
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(&(javax.portlet.name=" + portlet.getPortletId() + ")(objectClass=" + FriendlyURLMapper.class.getName() + "))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new FriendlyURLMapperServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void close() {
        this._serviceTracker.close();
    }

    public FriendlyURLMapper getFriendlyURLMapper() {
        return (FriendlyURLMapper)this._serviceTracker.getService();
    }

    public void register(FriendlyURLMapper friendlyURLMapper) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.portlet.name", this._portlet.getPortletId());
        ServiceRegistration serviceRegistration = registry.registerService(FriendlyURLMapper.class, (Object)friendlyURLMapper, properties);
        this._serviceRegistrations.put(friendlyURLMapper, serviceRegistration);
    }

    public void unregister(FriendlyURLMapper friendlyURLMapper) {
        ServiceRegistration<?> serviceRegistration = this._serviceRegistrations.remove(friendlyURLMapper);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private class FriendlyURLMapperServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<FriendlyURLMapper, FriendlyURLMapper> {
        private FriendlyURLMapperServiceTrackerCustomizer() {
        }

        public FriendlyURLMapper addingService(ServiceReference<FriendlyURLMapper> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            FriendlyURLMapper friendlyURLMapper = (FriendlyURLMapper)registry.getService(serviceReference);
            try {
                friendlyURLMapper.setMapping(FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLMapping());
                friendlyURLMapper.setPortletId(FriendlyURLMapperTrackerImpl.this._portlet.getPortletId());
                friendlyURLMapper.setPortletInstanceable(FriendlyURLMapperTrackerImpl.this._portlet.isInstanceable());
                friendlyURLMapper.setRouter(this.newFriendlyURLRouter());
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                return null;
            }
            return friendlyURLMapper;
        }

        public void modifiedService(ServiceReference<FriendlyURLMapper> serviceReference, FriendlyURLMapper service) {
        }

        public void removedService(ServiceReference<FriendlyURLMapper> serviceReference, FriendlyURLMapper service) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
        }

        protected Router newFriendlyURLRouter() throws Exception {
            if (Validator.isNull((String)FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLRoutes())) {
                return null;
            }
            RouterImpl router = new RouterImpl();
            ClassLoader classLoader = this.getClassLoader();
            String xml = StringUtil.read((ClassLoader)classLoader, (String)FriendlyURLMapperTrackerImpl.this._portlet.getFriendlyURLRoutes());
            Document document = SAXReaderUtil.read((String)xml, (boolean)true);
            Element rootElement = document.getRootElement();
            for (Element routeElement : rootElement.elements("route")) {
                String value;
                String name;
                String pattern = routeElement.elementText("pattern");
                Route route = router.addRoute(pattern);
                for (Element generatedParameterElement : routeElement.elements("generated-parameter")) {
                    name = generatedParameterElement.attributeValue("name");
                    value = generatedParameterElement.getText();
                    route.addGeneratedParameter(name, value);
                }
                for (Element ignoredParameterElement : routeElement.elements("ignored-parameter")) {
                    name = ignoredParameterElement.attributeValue("name");
                    route.addIgnoredParameter(name);
                }
                for (Element implicitParameterElement : routeElement.elements("implicit-parameter")) {
                    name = implicitParameterElement.attributeValue("name");
                    value = implicitParameterElement.getText();
                    route.addImplicitParameter(name, value);
                }
                for (Element overriddenParameterElement : routeElement.elements("overridden-parameter")) {
                    name = overriddenParameterElement.attributeValue("name");
                    value = overriddenParameterElement.getText();
                    route.addOverriddenParameter(name, value);
                }
            }
            return router;
        }

        private ClassLoader getClassLoader() {
            PortletApp portletApp = FriendlyURLMapperTrackerImpl.this._portlet.getPortletApp();
            ServletContext servletContext = portletApp.getServletContext();
            return servletContext.getClassLoader();
        }
    }
}

