/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xuggler;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xuggler.Xuggler;
import com.liferay.portal.util.JarUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.log4j.Log4JUtil;
import com.xuggle.ferry.JNILibraryLoader;
import com.xuggle.xuggler.IContainer;

public class XugglerImpl
implements Xuggler {
    private static Log _log = LogFactoryUtil.getLog(XugglerImpl.class);
    private static boolean _informAdministrator = true;
    private static boolean _nativeLibraryInstalled;

    public void installNativeLibraries(String name, ProgressTracker progressTracker) throws Exception {
        try {
            String url = PropsValues.XUGGLER_JAR_URL + name;
            JarUtil.downloadAndInstallJar(false, url, name, progressTracker);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to install jar " + name), (Throwable)e);
            throw e;
        }
    }

    public boolean isEnabled() {
        return this.isEnabled(true);
    }

    public boolean isEnabled(boolean checkNativeLibraries) {
        boolean enabled;
        block4: {
            enabled = false;
            try {
                enabled = PrefsPropsUtil.getBoolean("xuggler.enabled", PropsValues.XUGGLER_ENABLED);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        if (!checkNativeLibraries) {
            return enabled;
        }
        if (enabled) {
            return this.isNativeLibraryInstalled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNativeLibraryInstalled() {
        if (_nativeLibraryInstalled) {
            return _nativeLibraryInstalled;
        }
        String originalLevel = Log4JUtil.getOriginalLevel((String)JNILibraryLoader.class.getName());
        try {
            Log4JUtil.setLevel((String)JNILibraryLoader.class.getName(), (String)"OFF", (boolean)false);
            IContainer.make();
            _nativeLibraryInstalled = true;
        }
        catch (NoClassDefFoundError ncdfe) {
            this.informAdministrator(ncdfe.getMessage());
        }
        catch (UnsatisfiedLinkError ule) {
            this.informAdministrator(ule.getMessage());
        }
        finally {
            Log4JUtil.setLevel((String)JNILibraryLoader.class.getName(), (String)originalLevel.toString(), (boolean)false);
        }
        return _nativeLibraryInstalled;
    }

    protected void informAdministrator(String errorMessage) {
        if (!_informAdministrator) {
            return;
        }
        _informAdministrator = false;
        StringBundler sb = new StringBundler(7);
        sb.append("Liferay does not have the Xuggler native libraries ");
        sb.append("installed. In order to generate video and audio previews, ");
        sb.append("please follow the instructions for Xuggler in the Server ");
        sb.append("Administration section of the Control Panel at: ");
        sb.append("http://<server>/group/control_panel/manage/-/server/");
        sb.append("external-services. Error message is: ");
        sb.append(errorMessage);
        _log.error((Object)sb.toString());
    }
}

